/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.services.repository;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.AbstractRepositoryProvider;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.services.repository.RepositoryProviderException;
import org.eaglei.services.repository.RepositorySession;
import org.eaglei.services.repository.SecurityProvider;

public final class RepositorySecurityProvider
extends AbstractRepositoryProvider
implements SecurityProvider {
    private static final Long SESSION_TIMEOUT = Long.getLong("org.eaglei.session.timeout", 14400000L);
    private static String WITDRAWN_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Withdrawn";
    private static String SANDBOX_WORKSPACE_URI = "http://eagle-i.org/ont/repo/1.0/NG_Sandbox";
    private static final Log log = LogFactory.getLog(RepositorySecurityProvider.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private final InstitutionRegistry institutionRegistry;

    public RepositorySecurityProvider(InstitutionRegistry institutionRegistry) {
        this.institutionRegistry = institutionRegistry;
        SessionReaper reaper = new SessionReaper();
        reaper.start();
        log.info("RepositorySecurityProvider initialized.  Session timeout:  " + SESSION_TIMEOUT / 60000L + " min");
    }

    @Override
    public Session logIn(String institutionId, String user, String password) throws RepositoryProviderException {
        HttpClient userClient = RepositoryHttpConfig.createHttpClient(user, password);
        userClient.setHttpConnectionManager(new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug("Logging in user: " + user);
        }
        return this.getUserInformation(institutionId, null, userClient);
    }

    private Session getUserInformation(String institutionId, RepositorySession repoSession, HttpClient client) throws RepositoryProviderException {
        if (client == null) {
            log.error("http Client is null");
            throw new RepositoryProviderException("trying to use null http client");
        }
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        if (repoConfig == null) {
            String msg = "Unrecognized login institution id: " + institutionId;
            log.error(msg);
            throw new RepositoryProviderException(msg, RepositoryProviderException.RepositoryProviderExceptionType.NOT_FOUND);
        }
        if (isDebugEnabled) {
            log.debug("Checking for user info with whoami URL of: " + repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.WHOAMI_URL));
        }
        ResultSet results = null;
        String responseBody = null;
        GetMethod method = new GetMethod(repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.WHOAMI_URL));
        try {
            responseBody = ProviderUtils.getHttpResponse(client, method);
            if (responseBody == null) {
                throw new RepositoryProviderException("got null responsebody from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            results = ResultSetFactory.fromXML(responseBody);
            if (results == null) {
                throw new RepositoryProviderException("got null result set from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            QuerySolution soln = results.nextSolution();
            Literal username = soln.getLiteral("username");
            Resource userURI = soln.getResource("uri");
            if (username == null || userURI == null) {
                throw new RepositoryProviderException("got null user/usederUri from whoami", RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED);
            }
            if (repoSession == null || !repoSession.isValid()) {
                if (repoSession != null) {
                    SessionManager.removeSession(repoSession.getSessionId());
                }
                String sessionId = UUID.randomUUID().toString();
                Session newSession = new Session(sessionId, institutionId, username.getString(), userURI.getURI());
                repoSession = SessionManager.addSession(client, newSession);
            }
            repoSession.setLastAccess(new Long(System.currentTimeMillis()));
            if (isDebugEnabled) {
                log.debug("Authenticated user: " + repoSession.getUserName() + " session id: " + repoSession.getSessionId());
            }
            Session session = repoSession.getInnerSession();
            return session;
        }
        catch (RepositoryProviderException e2) {
            log.error(e2.getMessage());
            throw e2;
        }
        catch (Exception e3) {
            String msg = "problem getting user info " + repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.WHOAMI_URL) + " Message from repo: " + responseBody + "; Exception " + e3;
            log.error(msg);
            throw new RepositoryProviderException(msg);
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void logOut(String sessionId) throws RepositoryProviderException {
        RepositorySession repoSession = SessionManager.removeSession(sessionId);
        if (repoSession == null) {
            return;
        }
        HttpMethodBase method = null;
        try {
            RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(repoSession.getInstitutionId());
            method = new PostMethod(repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.LOGOUT_URL));
            if (isDebugEnabled) {
                log.debug("Trying to logout at " + repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.LOGOUT_URL));
            }
            ProviderUtils.getHttpResponse(repoSession.getHttpClient(), method);
            if (isDebugEnabled) {
                log.debug("logout succeded");
            }
        }
        catch (RepositoryProviderException e2) {
            log.warn("Error on logout: " + e2.getMessage(), e2);
            throw e2;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Session whoami(String sessionId) throws RepositoryProviderException {
        if (!this.isValid(sessionId, false)) {
            log.info("Using invalid session.  Could not whoami user");
            SessionManager.removeSession(sessionId);
            return null;
        }
        RepositorySession repoSession = SessionManager.getSession(sessionId);
        if (repoSession == null || !repoSession.isValid()) {
            log.info("Using invalid session.  Could not whoami user");
            SessionManager.removeSession(sessionId);
            return null;
        }
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(repoSession.getInstitutionId());
        if (isDebugEnabled) {
            log.debug("Trying to whoami at " + repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.WHOAMI_URL));
        }
        return this.getUserInformation(repoSession.getInstitutionId(), repoSession, repoSession.getHttpClient());
    }

    @Override
    public boolean isValid(String sessionId, boolean shouldThrow) throws RepositoryProviderException {
        if (sessionId == null) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Null session id", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error("Null session id");
            return false;
        }
        if (!SessionManager.hasSession(sessionId)) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Invalid Session - non-existent session id", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error("Invalid Session - non-existent session id");
            return false;
        }
        RepositorySession repoSession = SessionManager.getSession(sessionId);
        if (repoSession == null || !repoSession.isValid()) {
            if (shouldThrow) {
                throw new RepositoryProviderException("Session invalid or null or client null", RepositoryProviderException.RepositoryProviderExceptionType.INVALID_SESSION);
            }
            log.error("Session invalid or null or client null");
            return false;
        }
        return true;
    }

    @Override
    public HttpClient getHttpClient(Session session) {
        RepositorySession repoSession = SessionManager.getSession(session.getSessionId());
        return repoSession == null ? null : repoSession.getHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnline(String institutionId) {
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        boolean online = false;
        String url = repoConfig.getBaseURL();
        GetMethod method = new GetMethod(url + "/admin");
        HttpClient client = new HttpClient();
        client.setHttpConnectionManager(new MultiThreadedHttpConnectionManager());
        if (isDebugEnabled) {
            log.debug("Trying to see if Repository is available: " + url);
        }
        try {
            ProviderUtils.getHttpResponse(client, method);
            if (isDebugEnabled) {
                log.debug("Repository is available: " + url + " is available with status 'OK'.");
            }
        }
        catch (RepositoryProviderException e2) {
            if (e2.getExceptionType() == RepositoryProviderException.RepositoryProviderExceptionType.UNAUTHORIZED) {
                online = true;
                if (isDebugEnabled) {
                    log.debug("Repository is available: " + url + " is available with status 'Unauthorized'.");
                }
            } else {
                log.error("problem checking online status of repository: " + url + " " + e2);
            }
        }
        finally {
            method.releaseConnection();
        }
        return online;
    }

    private EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create(solution.getResource(uriVariable).getURI());
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create(uri, label);
        }
        return EIEntity.NULL_ENTITY;
    }

    @Override
    public List<HashMap<String, EIEntity>> listWorkFlowTransitions(String institutionId, String sessionId, EIEntity workspaceEntity) throws RepositoryProviderException {
        this.isValid(sessionId, true);
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        PostMethod method = new PostMethod(repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.LIST_TRANSITIONS_URL));
        method.setParameter("format", "application/xml");
        if (workspaceEntity != null && !workspaceEntity.equals(EIEntity.NULL_ENTITY)) {
            method.setParameter("URI", workspaceEntity.getURI().toString());
        }
        log.info("executing " + repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.LIST_TRANSITIONS_URL) + " api call");
        HttpClient client = this.getHttpClient(SessionManager.getSession(sessionId).getInnerSession());
        String responseBody = ProviderUtils.getHttpResponse(client, method);
        if (responseBody == null) {
            throw new RepositoryProviderException("response to listWorkflowTransitions is null");
        }
        log.info("parsing response to make list of workflow transitions");
        ResultSet resultSet = ResultSetFactory.fromXML(responseBody);
        ArrayList<HashMap<String, EIEntity>> transitionList = new ArrayList<HashMap<String, EIEntity>>();
        while (resultSet.hasNext()) {
            boolean allowed;
            QuerySolution solution = resultSet.next();
            if (!solution.contains("allowed") || !(allowed = solution.getLiteral("allowed").getBoolean())) continue;
            HashMap<String, EIEntity> workFlowTransition = new HashMap<String, EIEntity>(3);
            workFlowTransition.put("subject", this.getEntityFromSolution(solution, "subject", "label"));
            workFlowTransition.put("initial", this.getEntityFromSolution(solution, "initial", "initialLabel"));
            workFlowTransition.put("final", this.getEntityFromSolution(solution, "final", "finalLabel"));
            transitionList.add(workFlowTransition);
        }
        log.info(transitionList.size() + " transitions were returned");
        return transitionList;
    }

    @Override
    public List<HashMap<String, String>> getWorkspaces(String institutionId, String sessionId) throws RepositoryProviderException {
        this.isValid(sessionId, true);
        RepositoryHttpConfig repoConfig = this.institutionRegistry.getRepositoryHttpConfig(institutionId);
        String methodURL = repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.LIST_GRAPHS_URL);
        PostMethod method = new PostMethod(methodURL);
        method.setParameter("format", "application/xml");
        log.info("executing " + methodURL + " api call");
        RepositorySession repoSession = SessionManager.getSession(sessionId);
        String responseBody = ProviderUtils.getHttpResponse(repoSession.getHttpClient(), method);
        log.info(methodURL + " api call has returned ,parsing the results");
        ArrayList<HashMap<String, String>> workspaceList = new ArrayList<HashMap<String, String>>();
        ResultSet resultSet = ResultSetFactory.fromXML(responseBody);
        while (resultSet.hasNext()) {
            QuerySolution solution = resultSet.next();
            String workspaceURI = solution.getResource("namedGraphURI").getURI();
            if (workspaceURI.equals(WITDRAWN_WORKSPACE_URI) || workspaceURI.equals(SANDBOX_WORKSPACE_URI)) continue;
            HashMap<String, String> workspaceMap = new HashMap<String, String>(5);
            workspaceMap.put("namedGraphLabel", solution.getLiteral("namedGraphLabel").getString());
            workspaceMap.put("namedGraphURI", solution.getResource("namedGraphURI").getURI());
            workspaceMap.put("typeURI", solution.getResource("typeURI").getURI());
            workspaceMap.put("add", String.valueOf(solution.getLiteral("add").getBoolean()));
            workspaceMap.put("remove", String.valueOf(solution.getLiteral("remove").getBoolean()));
            workspaceList.add(workspaceMap);
        }
        return workspaceList;
    }

    @Override
    public Session getSession(String sessionId) {
        RepositorySession session = SessionManager.getSession(sessionId);
        return session != null ? session.getInnerSession() : null;
    }

    private class SessionReaper
    extends Thread {
        private final long SLEEP_INTERVAL = 3600000L;

        SessionReaper() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block2: while (true) {
                try {
                    Thread.sleep(3600000L);
                }
                catch (InterruptedException e2) {
                    return;
                }
                Set<String> sessionList = SessionManager.getSessionIdSet();
                Iterator<String> i$ = sessionList.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block2;
                    String sessionId = i$.next();
                    RepositorySession repoSession = SessionManager.getSession(sessionId);
                    this.purgeExpiredSession(repoSession);
                }
                break;
            }
        }

        private void purgeExpiredSession(RepositorySession repoSession) {
            long currentTime = System.currentTimeMillis();
            if (!repoSession.isValid() || currentTime > repoSession.getLastAccess() + SESSION_TIMEOUT) {
                SessionManager.removeSession(repoSession.getSessionId());
            }
        }
    }

    private static class SessionManager {
        private static Map<String, RepositorySession> mapSessionIdToRepoSession = new HashMap<String, RepositorySession>();

        private SessionManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession getSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                RepositorySession repoSession = mapSessionIdToRepoSession.get(sessionId);
                if (repoSession == null) {
                    return null;
                }
                return repoSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession removeSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                RepositorySession repoSession = mapSessionIdToRepoSession.remove(sessionId);
                if (repoSession == null) {
                    return null;
                }
                if (isDebugEnabled) {
                    log.debug("Remove session for user: " + repoSession.getUserName() + " session id: " + sessionId);
                }
                return repoSession;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean hasSession(String sessionId) {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                return mapSessionIdToRepoSession.containsKey(sessionId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RepositorySession addSession(HttpClient client, Session session) throws RepositoryProviderException {
            RepositorySession newSession = new RepositorySession(session, client);
            if (!newSession.isValid()) {
                throw new RepositoryProviderException("Tried to add repository session with invalid session or null client.");
            }
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                mapSessionIdToRepoSession.put(newSession.getSessionId(), newSession);
            }
            return newSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Set<String> getSessionIdSet() {
            Map<String, RepositorySession> map = mapSessionIdToRepoSession;
            synchronized (map) {
                return mapSessionIdToRepoSession.keySet();
            }
        }
    }
}

