/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.mindswap.pellet.datatypes.AbstractDateTimeValueSpace;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseXSDAtomicType;
import org.mindswap.pellet.datatypes.ValueSpace;
import org.mindswap.pellet.datatypes.XSDAtomicType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.GenericIntervalList;
import org.relaxng.datatype.DatatypeException;

public class XSDTime
extends BaseXSDAtomicType
implements AtomicDatatype,
XSDAtomicType {
    private static XSDatatype dt = null;
    private static IDateTimeValueType min = null;
    private static IDateTimeValueType max = null;
    private static final ValueSpace TIME_VALUE_SPACE;
    public static XSDTime instance;

    protected XSDTime(ATermAppl name) {
        super(name, TIME_VALUE_SPACE);
    }

    public BaseXSDAtomicType create(GenericIntervalList intervals) {
        XSDTime type = new XSDTime(null);
        type.values = intervals;
        return type;
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    static {
        try {
            dt = DatatypeFactory.getTypeByName((String)"time");
            min = (IDateTimeValueType)dt.createValue("00:00:00.000Z", null);
            max = (IDateTimeValueType)dt.createValue("23:59:59.999Z", null);
        }
        catch (DatatypeException e2) {
            e2.printStackTrace();
        }
        TIME_VALUE_SPACE = new TimeValueSpace();
        instance = new XSDTime(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#time"));
    }

    private static class TimeValueSpace
    extends AbstractDateTimeValueSpace
    implements ValueSpace {
        public TimeValueSpace() {
            super(min, max, dt);
        }

        public int count(Object start, Object end) {
            long calendarStart = ((IDateTimeValueType)start).toCalendar().getTimeInMillis();
            long calendarEnd = ((IDateTimeValueType)end).toCalendar().getTimeInMillis();
            long diff = calendarStart - calendarEnd;
            if (calendarStart >= calendarEnd) {
                return 0;
            }
            if (diff > Integer.MAX_VALUE || diff < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)diff;
        }

        public Object succ(Object value, int n) {
            BigDecimal bigN = new BigDecimal(String.valueOf(n));
            BigTimeDurationValueType nSeconds = new BigTimeDurationValueType(BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, bigN);
            IDateTimeValueType s = ((IDateTimeValueType)value).add((ITimeDurationValueType)nSeconds);
            return s;
        }
    }
}

