/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.Bool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Taxonomy<T> {
    public static final boolean BOTTOM_UP = false;
    public static boolean DEBUG = false;
    public static boolean DETAILED_DEBUG = false;
    public static final Logger log = Logger.getLogger(Taxonomy.class.getName());
    public static final boolean SUB = true;
    public static final boolean SUPER = false;
    public static final boolean TOP_DOWN = true;
    protected TaxonomyNode<T> bottomNode;
    protected Map<T, TaxonomyNode<T>> nodes = CollectionUtils.makeMap();
    protected TaxonomyNode<T> topNode;

    public Taxonomy() {
        this(null, null, null);
    }

    public Taxonomy(Collection<T> elements, T top, T bottom) {
        if (top == null) {
            this.topNode = new TaxonomyNode<Object>((Object)null, true);
        } else {
            this.topNode = new TaxonomyNode<T>(top, false);
            this.nodes.put(top, this.topNode);
        }
        if (bottom == null) {
            this.bottomNode = new TaxonomyNode<Object>((Object)null, true);
        } else {
            this.bottomNode = new TaxonomyNode<T>(bottom, false);
            this.nodes.put(bottom, this.bottomNode);
        }
        if (elements == null || elements.isEmpty()) {
            this.topNode.addSub(this.bottomNode);
        } else {
            for (T t : elements) {
                this.addNode(t, false);
            }
        }
    }

    public void addEquivalentNode(T t, TaxonomyNode<T> node) {
        node.addEquivalent(t);
        this.nodes.put(t, node);
    }

    public void addEquivalents(T t, Collection<T> eqs) {
        assert (this.nodes.keySet().contains(t)) : "Element " + t.toString() + " not in taxonomy";
        TaxonomyNode<T> node = this.nodes.get(t);
        for (T eq : eqs) {
            assert (!this.nodes.keySet().contains(eq)) : "Element " + eq.toString() + " alread in taxonomy";
            node.addEquivalent(eq);
            this.nodes.put(eq, node);
        }
    }

    public TaxonomyNode<T> addNode(Collection<T> equivalents, Collection<T> sups, Collection<T> subs, boolean hidden) {
        assert (!equivalents.isEmpty()) : "Taxonomy nodes must have at least one element";
        assert (this.nodes.keySet().containsAll(sups)) : "At least one super element not in taxonomy";
        assert (this.nodes.keySet().containsAll(subs)) : "At least one sub element not in taxonomy";
        TaxonomyNode node = new TaxonomyNode(equivalents, hidden);
        for (T t : equivalents) {
            this.nodes.put(t, node);
        }
        if (sups.isEmpty()) {
            if (this.topNode.isHidden()) {
                this.topNode.addSub(node);
                if (this.topNode.getSubs().size() == 2) {
                    this.topNode.removeSub(this.bottomNode);
                }
            } else {
                node.addSupers(Collections.singleton(this.topNode));
            }
        } else {
            HashSet supNodes = new HashSet();
            for (T sup : sups) {
                supNodes.add(this.nodes.get(sup));
            }
            node.addSupers(supNodes);
        }
        if (subs.isEmpty()) {
            if (this.bottomNode.isHidden()) {
                this.bottomNode.addSupers(Collections.singleton(node));
                this.bottomNode.getSupers().removeAll(node.getSupers());
            } else {
                node.addSub(this.bottomNode);
            }
        } else {
            HashSet subNodes = new HashSet();
            for (T sub : subs) {
                subNodes.add(this.nodes.get(sub));
            }
            node.addSubs(subNodes);
        }
        node.removeMultiplePaths();
        return node;
    }

    public TaxonomyNode<T> addNode(T t, boolean hidden) {
        TaxonomyNode<T> node = new TaxonomyNode<T>(t, hidden);
        this.topNode.addSub(node);
        node.addSub(this.bottomNode);
        this.nodes.put(t, node);
        return node;
    }

    public void addSuper(Collection<T> subs, T sup) {
        assert (this.nodes.keySet().containsAll(subs)) : "At least one sub element not in taxonomy";
        assert (this.nodes.keySet().contains(sup)) : "Super element " + sup.toString() + " not in taxonomy";
        HashSet subNodes = new HashSet();
        for (T sub : subs) {
            subNodes.add(this.nodes.get(sub));
        }
        TaxonomyNode supNode = this.nodes.get(sup);
        for (TaxonomyNode taxonomyNode : subNodes) {
            if (taxonomyNode.getSupers().size() != 1 || !taxonomyNode.getSupers().contains(this.topNode)) continue;
            this.topNode.removeSub(taxonomyNode);
        }
        if (supNode.getSubs().size() == 1 && supNode.getSubs().contains(this.bottomNode)) {
            supNode.removeSub(this.bottomNode);
        }
        supNode.addSubs(subNodes);
    }

    public void addSuper(T sub, T sup) {
        TaxonomyNode<T> supNode;
        assert (this.nodes.keySet().contains(sub)) : "Sub element " + sub.toString() + " not in taxonomy";
        assert (this.nodes.keySet().contains(sup)) : "Super element " + sup.toString() + " not in taxonomy";
        TaxonomyNode<T> subNode = this.nodes.get(sub);
        if (subNode.equals(supNode = this.nodes.get(sup))) {
            throw new InternalReasonerException("Equivalent elements cannot have sub/super relationship");
        }
        if (subNode.getSupers().size() == 1 && subNode.getSupers().iterator().next() == this.topNode) {
            this.topNode.removeSub(subNode);
        }
        if (supNode.getSubs().size() == 1 && supNode.getSubs().iterator().next() == this.bottomNode) {
            supNode.removeSub(this.bottomNode);
        }
        supNode.addSub(subNode);
    }

    public void addSupers(T sub, Collection<T> sups) {
        assert (this.nodes.keySet().contains(sub)) : "Sub element " + sub.toString() + " not in taxonomy";
        assert (this.nodes.keySet().containsAll(sups)) : "At least one super element not in taxonomy";
        TaxonomyNode subNode = this.nodes.get(sub);
        HashSet supNodes = new HashSet();
        for (T t : sups) {
            supNodes.add(this.nodes.get(t));
        }
        if (subNode.getSupers().size() == 1 && subNode.getSupers().contains(this.topNode)) {
            this.topNode.removeSub(subNode);
        }
        for (TaxonomyNode taxonomyNode : supNodes) {
            if (taxonomyNode.getSubs().size() != 1 || !taxonomyNode.getSubs().contains(this.bottomNode)) continue;
            taxonomyNode.removeSub(this.bottomNode);
        }
        subNode.addSupers(supNodes);
    }

    public void assertValid() {
        assert (this.topNode.getSupers().isEmpty()) : "Top node in the taxonomy has parents";
        assert (this.bottomNode.getSubs().isEmpty()) : "Bottom node in the taxonomy has children";
    }

    public List<T> computeLCA(List<T> list) {
        if (list.isEmpty()) {
            return null;
        }
        T t = list.get(0);
        ArrayList<T> ancestors = new ArrayList<T>(this.getFlattenedSupers(t, false));
        for (int i = 1; i < list.size() && ancestors.size() > 0; ++i) {
            t = list.get(i);
            ancestors.retainAll(this.getFlattenedSupers(t, false));
        }
        HashSet toBeRemoved = new HashSet();
        for (Object a : ancestors) {
            if (toBeRemoved.contains(a)) continue;
            Set supers = this.getFlattenedSupers(a, false);
            toBeRemoved.addAll(supers);
        }
        ancestors.removeAll(toBeRemoved);
        return ancestors;
    }

    public boolean contains(T t) {
        return this.nodes.containsKey(t);
    }

    public Iterator<Map.Entry<Set<T>, Object>> datumEquivalentsPair(Object key) {
        return new DatumEquivalentsPairIterator(this, key);
    }

    public Iterator<Object> depthFirstDatumOnly(T t, Object key) {
        return new DepthFirstDatumOnlyIterator<T>(this, t, key);
    }

    public Set<T> getAllEquivalents(T t) {
        TaxonomyNode<T> node = this.nodes.get(t);
        if (node == null) {
            return new HashSet();
        }
        HashSet<T> result = new HashSet<T>(node.getEquivalents());
        return result;
    }

    public TaxonomyNode<T> getBottom() {
        return this.bottomNode;
    }

    public Set<T> getClasses() {
        return this.nodes.keySet();
    }

    public Object getDatum(T t, Object key) {
        TaxonomyNode<T> node = this.nodes.get(t);
        return node == null ? null : node.getDatum(key);
    }

    public Set<T> getEquivalents(T t) {
        Set<T> result = this.getAllEquivalents(t);
        result.remove(t);
        return result;
    }

    public Set<T> getFlattenedSubs(T t, boolean direct) {
        return this.getFlattenedSubSupers(t, direct, true);
    }

    public Set<T> getFlattenedSubSupers(T t, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this.nodes.get(t);
        HashSet result = new HashSet();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            Set add = node.getEquivalents();
            result.addAll(add);
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set<T> getFlattenedSupers(T t, boolean direct) {
        return this.getFlattenedSubSupers(t, direct, false);
    }

    public TaxonomyNode<T> getNode(T t) {
        return this.nodes.get(t);
    }

    public Collection<TaxonomyNode<T>> getNodes() {
        return this.nodes.values();
    }

    public Set<Set<T>> getSubs(T t) {
        return this.getSubs(t, false);
    }

    public Set<Set<T>> getSubs(T t, boolean direct) {
        return this.getSubSupers(t, direct, true);
    }

    public Set getSubs(T t, boolean direct, boolean flat) {
        return this.getSubSupers(t, direct, true, flat);
    }

    public Set<Set<T>> getSubSupers(T t, boolean direct, boolean subOrSuper) {
        TaxonomyNode node = this.nodes.get(t);
        if (node == null) {
            return Collections.emptySet();
        }
        HashSet<Set<T>> result = new HashSet<Set<T>>();
        ArrayList visit = new ArrayList();
        visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.isHidden()) continue;
            HashSet add = new HashSet(node.getEquivalents());
            if (!add.isEmpty()) {
                result.add(add);
            }
            if (direct) continue;
            visit.addAll(subOrSuper ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set getSubSupers(T t, boolean direct, boolean subOrSuper, boolean flat) {
        if (flat) {
            return this.getFlattenedSubSupers(t, direct, subOrSuper);
        }
        return this.getSubSupers(t, direct, subOrSuper);
    }

    public Set<Set<T>> getSupers(T t) {
        return this.getSupers(t, false);
    }

    public Set<Set<T>> getSupers(T t, boolean direct) {
        return this.getSubSupers(t, direct, false);
    }

    public Set getSupers(T t, boolean direct, boolean flat) {
        return this.getSubSupers(t, direct, false, flat);
    }

    public TaxonomyNode<T> getTop() {
        return this.topNode;
    }

    public Bool isEquivalent(T x, T y) {
        TaxonomyNode<T> nodeX = this.nodes.get(x);
        TaxonomyNode<T> nodeY = this.nodes.get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    public Bool isSubNodeOf(T x, T y) {
        TaxonomyNode<T> nodeX = this.nodes.get(x);
        TaxonomyNode<T> nodeY = this.nodes.get(y);
        if (nodeX == null || nodeY == null) {
            return Bool.UNKNOWN;
        }
        if (nodeX.equals(nodeY)) {
            return Bool.TRUE;
        }
        if (nodeX.isHidden()) {
            if (nodeY.isHidden()) {
                return Bool.UNKNOWN;
            }
            return this.getFlattenedSupers(x, false).contains(y) ? Bool.TRUE : Bool.FALSE;
        }
        return this.getFlattenedSubs(y, false).contains(x) ? Bool.TRUE : Bool.FALSE;
    }

    public void merge(TaxonomyNode<T> node1, TaxonomyNode<T> node2) {
        ArrayList<TaxonomyNode<T>> mergeList = new ArrayList<TaxonomyNode<T>>(2);
        mergeList.add(node1);
        mergeList.add(node2);
        TaxonomyNode<T> node = this.mergeNodes(mergeList);
        this.removeCycles(node);
    }

    private TaxonomyNode<T> mergeNodes(List<TaxonomyNode<T>> mergeList) {
        assert (mergeList.size() > 1) : "Attempt to merge less than two nodes";
        if (log.isLoggable(Level.FINER)) {
            log.finer("Merge " + mergeList);
        }
        TaxonomyNode<T> node = null;
        node = mergeList.contains(this.topNode) ? this.topNode : (mergeList.contains(this.bottomNode) ? this.bottomNode : mergeList.get(0));
        HashSet<TaxonomyNode<T>> merged = new HashSet<TaxonomyNode<T>>();
        merged.add(node);
        for (TaxonomyNode<T> other : mergeList) {
            if (merged.contains(other)) continue;
            merged.add(other);
            for (TaxonomyNode<T> sub : other.getSubs()) {
                if (sub == this.bottomNode || mergeList.contains(sub)) continue;
                if (node.getSubs().size() == 1 && node.getSubs().iterator().next() == this.bottomNode) {
                    node.removeSub(this.bottomNode);
                }
                node.addSub(sub);
            }
            for (TaxonomyNode<T> sup : other.getSupers()) {
                if (sup == this.topNode || mergeList.contains(sup)) continue;
                if (node.getSupers().size() == 1 && node.getSupers().iterator().next() == this.topNode) {
                    this.topNode.removeSub(node);
                }
                sup.addSub(node);
            }
            other.disconnect();
            for (TaxonomyNode<T> t : other.getEquivalents()) {
                this.addEquivalentNode(t, node);
            }
        }
        node.clearData();
        if (node != this.topNode && node.getSupers().isEmpty()) {
            this.topNode.addSub(node);
        }
        if (node != this.bottomNode && node.getSubs().isEmpty()) {
            node.addSub(this.bottomNode);
        }
        return node;
    }

    public Object putDatum(T t, Object key, Object value) {
        TaxonomyNode<T> node = this.nodes.get(t);
        if (node == null) {
            throw new RuntimeException(t + " is an unknown class!");
        }
        return node.putDatum(key, value);
    }

    public void remove(T t) {
        assert (this.nodes.containsKey(t)) : "Element not contained in taxonomy";
        TaxonomyNode<T> node = this.nodes.remove(t);
        if (node.getEquivalents().size() == 1) {
            List<TaxonomyNode<T>> subs = node.getSubs();
            List<TaxonomyNode<T>> supers = node.getSupers();
            node.disconnect();
            for (TaxonomyNode<T> sup : supers) {
                sup.addSubs(subs);
            }
        } else {
            node.removeEquivalent(t);
        }
    }

    public void removeCycles(TaxonomyNode<T> node) {
        if (!this.nodes.get(node.getName()).equals(node)) {
            throw new InternalReasonerException("This node does not exist in the taxonomy: " + node.getName());
        }
        this.removeCycles(node, new ArrayList<TaxonomyNode<T>>());
    }

    private boolean removeCycles(TaxonomyNode<T> node, List<TaxonomyNode<T>> path) {
        if (path.contains(node)) {
            this.mergeNodes(path);
            return true;
        }
        path.add(node);
        List<TaxonomyNode<T>> supers = node.getSupers();
        int i = 0;
        while (i < supers.size()) {
            TaxonomyNode<T> sup = supers.get(i);
            this.removeCycles(sup, path);
            path.remove(sup);
            if (i >= supers.size() || !supers.get(i).equals(sup)) continue;
            ++i;
        }
        return false;
    }

    public Object removeDatum(T t, Object key) {
        return this.getNode(t).removeDatum(key);
    }

    public void resetSupers(T t, Collection<T> supers) {
        assert (this.nodes.keySet().contains(t)) : "Element " + t.toString() + " not in taxonomy";
        assert (this.nodes.keySet().containsAll(supers)) : "Supers not all contained in taxonomy";
        TaxonomyNode<T> node = this.nodes.get(t);
        ArrayList<TaxonomyNode<T>> initial = new ArrayList<TaxonomyNode<T>>(node.getSupers());
        for (TaxonomyNode taxonomyNode : initial) {
            taxonomyNode.removeSub(node);
        }
        if (supers.isEmpty()) {
            this.topNode.addSub(node);
        } else {
            HashSet<TaxonomyNode<T>> added = new HashSet<TaxonomyNode<T>>();
            for (T sup : supers) {
                TaxonomyNode<T> n = this.nodes.get(sup);
                if (!added.add(n)) continue;
                n.addSub(node);
            }
        }
    }

    public List<T> topologocialSort(boolean includeEquivalents) {
        return this.topologocialSort(includeEquivalents, null);
    }

    public List<T> topologocialSort(boolean includeEquivalents, Comparator<? super T> comparator) {
        HashMap degrees = new HashMap();
        AbstractMap nodesPending = comparator == null ? new HashMap() : new TreeMap(comparator);
        HashSet<TaxonomyNode<T>> nodesLeft = new HashSet<TaxonomyNode<T>>();
        ArrayList nodesSorted = new ArrayList();
        log.fine("Topological sort...");
        for (TaxonomyNode<T> node : this.nodes.values()) {
            if (node.isHidden()) continue;
            nodesLeft.add(node);
            int degree = node.getSupers().size();
            if (degree == 0) {
                nodesPending.put(node.getName(), node);
                degrees.put(node, 0);
                continue;
            }
            degrees.put(node, degree);
        }
        int size = nodesLeft.size();
        for (int i = 0; i < size; ++i) {
            if (nodesPending.isEmpty()) {
                throw new InternalReasonerException("Cycle detected in the taxonomy!");
            }
            TaxonomyNode node = (TaxonomyNode)nodesPending.values().iterator().next();
            int deg = (Integer)degrees.get(node);
            if (deg != 0) {
                throw new InternalReasonerException("Cycle detected in the taxonomy " + node + " " + deg + " " + nodesSorted.size() + " " + this.nodes.size());
            }
            nodesPending.remove(node.getName());
            nodesLeft.remove(node);
            if (includeEquivalents) {
                nodesSorted.addAll(node.getEquivalents());
            } else {
                nodesSorted.add(node.getName());
            }
            for (TaxonomyNode sub : node.getSubs()) {
                int degree = (Integer)degrees.get(sub);
                if (degree == 1) {
                    nodesPending.put(sub.getName(), sub);
                    degrees.put(sub, 0);
                    continue;
                }
                degrees.put(sub, degree - 1);
            }
        }
        if (!nodesLeft.isEmpty()) {
            throw new InternalReasonerException("Failed to sort elements: " + nodesLeft);
        }
        log.fine("done");
        return nodesSorted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public SimpleImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DepthFirstDatumOnlyIterator<U>
    implements Iterator<Object> {
        private Object key;
        private List<TaxonomyNode<U>> pending;
        private Set<TaxonomyNode<U>> visited;

        public DepthFirstDatumOnlyIterator(Taxonomy<U> t, U u, Object key) {
            this.key = key;
            this.visited = new HashSet<TaxonomyNode<U>>();
            this.pending = new ArrayList<TaxonomyNode<U>>();
            TaxonomyNode<U> node = t.getNode(u);
            if (node != null) {
                this.pending.add(node);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.pending.isEmpty();
        }

        @Override
        public Object next() {
            if (this.pending.isEmpty()) {
                throw new NoSuchElementException();
            }
            TaxonomyNode<U> current = this.pending.remove(this.pending.size() - 1);
            this.visited.add(current);
            for (TaxonomyNode<U> sub : current.getSubs()) {
                if (this.visited.contains(sub)) continue;
                this.pending.add(sub);
            }
            return current.getDatum(this.key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DatumEquivalentsPairIterator<U>
    implements Iterator<Map.Entry<Set<U>, Object>> {
        private Iterator<TaxonomyNode<U>> i;
        private Object key;

        public DatumEquivalentsPairIterator(Taxonomy<U> t, Object key) {
            this.key = key;
            this.i = t.getNodes().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<Set<U>, Object> next() {
            TaxonomyNode<U> current = this.i.next();
            return new SimpleImmutableEntry<Set<U>, Object>(Collections.unmodifiableSet(current.getEquivalents()), current.getDatum(this.key));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

