/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import java.util.List;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;

public abstract class AbstractInterceptorDrivenBeanDefinitionDecorator
implements BeanDefinitionDecorator {
    public final BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definitionHolder, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String existingBeanName = definitionHolder.getBeanName();
        BeanDefinition existingDefinition = definitionHolder.getBeanDefinition();
        BeanDefinition interceptorDefinition = this.createInterceptorDefinition(node);
        String interceptorName = String.valueOf(existingBeanName) + "." + this.getInterceptorNameSuffix(interceptorDefinition);
        BeanDefinitionReaderUtils.registerBeanDefinition(new BeanDefinitionHolder(interceptorDefinition, interceptorName), registry);
        BeanDefinitionHolder result = definitionHolder;
        if (!this.isProxyFactoryBeanDefinition(existingDefinition)) {
            RootBeanDefinition proxyDefinition = new RootBeanDefinition();
            proxyDefinition.setBeanClass(ProxyFactoryBean.class);
            MutablePropertyValues mpvs = new MutablePropertyValues();
            proxyDefinition.setPropertyValues(mpvs);
            mpvs.add("target", existingDefinition);
            mpvs.add("interceptorNames", new ManagedList());
            result = new BeanDefinitionHolder(proxyDefinition, existingBeanName);
        }
        this.addInterceptorNameToList(interceptorName, result.getBeanDefinition());
        return result;
    }

    private void addInterceptorNameToList(String interceptorName, BeanDefinition beanDefinition) {
        List list = (List)beanDefinition.getPropertyValues().getPropertyValue("interceptorNames").getValue();
        list.add(interceptorName);
    }

    private boolean isProxyFactoryBeanDefinition(BeanDefinition existingDefinition) {
        return ProxyFactoryBean.class.getName().equals(existingDefinition.getBeanClassName());
    }

    protected String getInterceptorNameSuffix(BeanDefinition interceptorDefinition) {
        return StringUtils.uncapitalize(ClassUtils.getShortName(interceptorDefinition.getBeanClassName()));
    }

    protected abstract BeanDefinition createInterceptorDefinition(Node var1);
}

