/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.util.Date;
import java.util.TimeZone;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class CronTrigger
implements Trigger {
    private final CronSequenceGenerator sequenceGenerator;

    public CronTrigger(String cronExpression, TimeZone timeZone) {
        this.sequenceGenerator = new CronSequenceGenerator(cronExpression, timeZone);
    }

    public CronTrigger(String cronExpression) {
        this(cronExpression, TimeZone.getDefault());
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        Date date2 = triggerContext.lastCompletionTime();
        if (date2 == null) {
            date2 = new Date();
        }
        return this.sequenceGenerator.next(date2);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CronTrigger && this.sequenceGenerator.equals(((CronTrigger)obj).sequenceGenerator);
    }

    public int hashCode() {
        return this.sequenceGenerator.hashCode();
    }
}

