/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.el.RuleBasedELClassifier;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Interpreter;
import com.clarkparsia.pellet.rules.rete.Rule;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteBasedELClassifier
extends RuleBasedELClassifier
implements TaxonomyBuilder {
    private static final String PREDICATE_PREFIX = "";
    private static final ATermAppl PRED_SUB = ATermUtils.makeTermAppl("subclassOf");
    private static final ATermAppl PRED_SUB_SOME = ATermUtils.makeTermAppl("subclassOfSomeOf");
    private static final ATermAppl TOP = ATermUtils.TOP;
    private static final ATermAppl BOTTOM = ATermUtils.BOTTOM;
    private ConstantStore m_Names = new ConstantStore();
    private VariableStore m_Variables = new VariableStore();
    private List<Rule> m_Rules = CollectionUtils.makeList();
    private List<Fact> m_Facts = CollectionUtils.makeList();

    public ReteBasedELClassifier() {
        this.makeRuleAxioms();
    }

    @Override
    protected MultiValueMap<ATermAppl, ATermAppl> run(Collection<ATermAppl> classes) {
        KnowledgeBase reteKB = new KnowledgeBase();
        Interpreter interpreter = new Interpreter(reteKB.getABox());
        for (Rule rule : this.m_Rules) {
            interpreter.rete.compile(rule, null);
        }
        this.addClasses(interpreter, classes);
        this.addClasses(interpreter, this.m_Names.getAllAnons());
        for (Fact fact : this.m_Facts) {
            interpreter.addFact(fact);
        }
        this.m_Facts = null;
        this.m_Names.reset();
        Set<Fact> facts = interpreter.run();
        MultiValueMap<ATermAppl, ATermAppl> subsumers = this.getSubsumers(facts);
        for (ATermAppl c : classes) {
            subsumers.add(c, c);
            subsumers.add(c, ATermUtils.TOP);
        }
        return subsumers;
    }

    protected MultiValueMap<ATermAppl, ATermAppl> getSubsumers(Set<Fact> facts) {
        MultiValueMap<ATermAppl, ATermAppl> subsumers = new MultiValueMap<ATermAppl, ATermAppl>();
        for (Fact f : facts) {
            if (!((ATermAppl)f.getElements().get(0)).equals(PRED_SUB)) continue;
            List tuple = f.getElements();
            ATermAppl c1 = (ATermAppl)tuple.get(1);
            ATermAppl c2 = (ATermAppl)tuple.get(2);
            if (ConstantStore.isAnon(c1) || ConstantStore.isAnon(c2)) continue;
            subsumers.add(c1, c2);
        }
        return subsumers;
    }

    protected void addClasses(Interpreter interpreter, Collection<ATermAppl> classes) {
        for (ATermAppl c : classes) {
            interpreter.addFact(this.makeSubclassFact(c, c));
            interpreter.addFact(this.makeSubclassFact(c, TOP));
        }
    }

    @Override
    protected void addSubclassRule(ATermAppl sub, ATermAppl sup) {
        this.addSubclassRule(sub, sup, new FreeVariableStore());
    }

    @Override
    protected void addRoleDomainRule(ATermAppl p, ATermAppl domain) {
        List<TermTuple> body = CollectionUtils.makeList();
        List<TermTuple> head = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        ATermAppl var0 = freeVar.next();
        ATermAppl var1 = freeVar.next();
        body.add(this.makeSubOfSomeTuple(var0, p, var1));
        this.translateSuper(head, domain, freeVar, var0);
        this.m_Rules.add(new Rule(body, head));
    }

    @Override
    protected void addRoleRangeRule(ATermAppl p, ATermAppl range) {
        List<TermTuple> body = CollectionUtils.makeList();
        List<TermTuple> head = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        ATermAppl var0 = freeVar.next();
        ATermAppl var1 = freeVar.next();
        body.add(this.makeSubOfSomeTuple(var0, p, var1));
        ATermAppl someOfRange = ATermUtils.makeSomeValues(p, range);
        this.translateSuper(head, someOfRange, freeVar, var0);
        this.m_Rules.add(new Rule(body, head));
    }

    @Override
    protected void addRoleChainRule(ATerm[] chain, ATermAppl sup) {
        if (chain.length < 1) {
            return;
        }
        List<TermTuple> body = CollectionUtils.makeList();
        FreeVariableStore freeVar = new FreeVariableStore();
        ATermAppl[] var = new ATermAppl[chain.length + 1];
        var[0] = freeVar.next();
        for (int i = 0; i < chain.length; ++i) {
            var[i + 1] = freeVar.next();
            body.add(this.makeSubOfSomeTuple(var[i], (ATermAppl)chain[i], var[i + 1]));
        }
        TermTuple head = this.makeSubOfSomeTuple(var[0], sup, var[var.length - 1]);
        this.m_Rules.add(new Rule(body, Collections.singletonList(head)));
    }

    @Override
    protected void addRoleHierarchyRule(ATermAppl sub, ATermAppl sup) {
        this.addRoleChainRule(new ATerm[]{sub}, sup);
    }

    private void makeRuleAxioms() {
        this.makeBottomAxiom();
    }

    private void makeBottomAxiom() {
        FreeVariableStore freeVar = new FreeVariableStore();
        ATermAppl var0 = freeVar.next();
        ATermAppl var1 = freeVar.next();
        ATermAppl var2 = freeVar.next();
        List<TermTuple> body = CollectionUtils.makeList();
        body.add(this.makeSubOfSomeTuple(var0, var1, var2));
        body.add(this.makeSubclassTuple(var2, BOTTOM));
        TermTuple head = this.makeSubclassTuple(var0, BOTTOM);
        this.m_Rules.add(new Rule(body, Collections.singletonList(head)));
    }

    private void addSubclassRule(ATermAppl sub, ATermAppl sup, FreeVariableStore freeVar) {
        List<TermTuple> body = CollectionUtils.makeList();
        List<TermTuple> head = CollectionUtils.makeList();
        ATermAppl var = freeVar.next();
        this.translateSub(body, sub, freeVar, var);
        this.translateSuper(head, sup, freeVar, var);
        this.m_Rules.add(new Rule(body, head));
    }

    private void translateSub(List<TermTuple> outBody, ATermAppl sub, FreeVariableStore freeVar, ATermAppl currentVar) {
        AFun fun = sub.getAFun();
        if (ATermUtils.isPrimitive(sub) || ATermUtils.isBottom(sub)) {
            outBody.add(this.makeSubclassTuple(currentVar, sub));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sub.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSub(outBody, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sub.getArgument(0);
            ATermAppl q = (ATermAppl)sub.getArgument(1);
            ATermAppl nextVar = freeVar.next();
            outBody.add(this.makeSubOfSomeTuple(currentVar, prop, nextVar));
            this.translateSub(outBody, q, freeVar, nextVar);
        } else assert (false);
    }

    private void translateSuper(List<TermTuple> outHead, ATermAppl sup, FreeVariableStore freeVar, ATermAppl currentVar) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            outHead.add(this.makeSubclassTuple(currentVar, sup));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuper(outHead, conj, freeVar, currentVar);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl anon = this.m_Names.getNextAnon();
                this.translateSuperSome(anon, q);
                q = anon;
            }
            outHead.add(this.makeSubOfSomeTuple(currentVar, prop, q));
        } else assert (false);
    }

    private void translateSuperSome(ATermAppl anon, ATermAppl sup) {
        AFun fun = sup.getAFun();
        if (ATermUtils.isPrimitive(sup) || ATermUtils.isBottom(sup)) {
            this.m_Facts.add(this.makeSubclassFact(anon, sup));
        } else if (fun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)sup.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conj = (ATermAppl)list.getFirst();
                this.translateSuperSome(anon, conj);
                list = list.getNext();
            }
        } else if (fun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl prop = (ATermAppl)sup.getArgument(0);
            ATermAppl q = (ATermAppl)sup.getArgument(1);
            if (!ATermUtils.isPrimitive(q) && !ATermUtils.isBottom(q)) {
                ATermAppl nextAnon = this.m_Names.getNextAnon();
                this.translateSuperSome(nextAnon, q);
                q = nextAnon;
            }
            this.m_Facts.add(this.makeSubOfSomeFact(anon, prop, q));
        } else assert (false);
    }

    private Fact makeSubclassFact(ATermAppl t1, ATermAppl t2) {
        return new Fact(DependencySet.INDEPENDENT, PRED_SUB, t1, t2);
    }

    private Fact makeSubOfSomeFact(ATermAppl t1, ATermAppl t2, ATermAppl t3) {
        return new Fact(DependencySet.INDEPENDENT, PRED_SUB_SOME, t1, t2, t3);
    }

    private TermTuple makeSubclassTuple(ATermAppl t1, ATermAppl t2) {
        return new TermTuple(DependencySet.INDEPENDENT, PRED_SUB, t1, t2);
    }

    private TermTuple makeSubOfSomeTuple(ATermAppl t1, ATermAppl p, ATermAppl t2) {
        return new TermTuple(DependencySet.INDEPENDENT, PRED_SUB_SOME, t1, p, t2);
    }

    class FreeVariableStore {
        private int m_Next = 0;

        FreeVariableStore() {
        }

        protected ATermAppl next() {
            return ReteBasedELClassifier.this.m_Variables.get(this.m_Next++);
        }
    }

    static class VariableStore {
        private static final String PREFIX = "x";
        private List<ATermAppl> m_Variables = CollectionUtils.makeList();

        VariableStore() {
        }

        protected ATermAppl get(int target) {
            for (int size = this.m_Variables.size(); size <= target; ++size) {
                this.m_Variables.add(ATermUtils.makeVar(PREFIX + size));
            }
            return this.m_Variables.get(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstantStore {
        private static final String ANON = "tag:clarkparsia.com,2008:pellet:el:anon:";
        private static final int FIRST_ANON = 0;
        private Map<ATermAppl, ATermAppl> m_Constants = CollectionUtils.makeMap();
        private int m_NextAnon = 0;

        ConstantStore() {
        }

        public void reset() {
            this.m_Constants = CollectionUtils.makeMap();
            this.m_NextAnon = 0;
        }

        protected ATermAppl get(ATermAppl term) {
            ATermAppl c = this.m_Constants.get(term);
            if (c == null) {
                c = term;
                this.m_Constants.put(term, c);
            }
            return c;
        }

        protected ATermAppl getNextAnon() {
            return ConstantStore.makeAnon(this.m_NextAnon++);
        }

        protected Set<ATermAppl> getAllAnons() {
            Set<ATermAppl> anons = CollectionUtils.makeSet();
            for (int i = 0; i < this.m_NextAnon; ++i) {
                anons.add(ConstantStore.makeAnon(i));
            }
            return anons;
        }

        protected static boolean isAnon(ATermAppl c) {
            return c.getName().startsWith(ANON);
        }

        private static ATermAppl makeAnon(int id) {
            return ATermUtils.makeTermAppl(ANON + id);
        }
    }
}

