/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.EntailmentChecker;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.owlapiv3.PelletVisitor;
import com.clarkparsia.pellet.owlapiv3.ProgressAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.PelletRuntimeException;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.TimerInterruptedException;
import org.mindswap.pellet.exceptions.UndefinedEntityException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.VersionInfo;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.SimpleConfiguration;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDataPropertyNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;
import org.semanticweb.owlapi.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletReasoner
implements OWLReasoner,
OWLOntologyChangeListener {
    public static final Logger log = Logger.getLogger(PelletReasoner.class.getName());
    private static final Version VERSION = PelletReasoner.createVersion();
    private OWLDataFactory factory;
    private KnowledgeBase kb;
    private OWLOntologyManager manager;
    private ReasonerProgressMonitor monitor;
    private OWLOntology ontology;
    private Set<OWLOntology> importsClosure;
    private boolean shouldRefresh;
    private PelletVisitor visitor;
    private BufferingMode bufferingMode;
    private List<OWLOntologyChange> pendingChanges;
    private IndividualNodeSetPolicy individualNodeSetPolicy;
    private ChangeVisitor changeVisitor = new ChangeVisitor();
    private EntityMapper<OWLNamedIndividual> IND_MAPPER = new NamedIndividualMapper();
    private EntityMapper<OWLLiteral> LIT_MAPPER = new LiteralMapper();
    private EntityMapper<OWLObjectProperty> OP_MAPPER = new ObjectPropertyMapper();
    private EntityMapper<OWLDataProperty> DP_MAPPER = new DataPropertyMapper();
    private EntityMapper<OWLDatatype> DT_MAPPER = new DatatypeMapper();
    private EntityMapper<OWLClass> CLASS_MAPPER = new ClassMapper();

    private static Version createVersion() {
        String versionString = VersionInfo.getInstance().getVersionString();
        String[] versionNumbers = versionString.split("\\.");
        int major = PelletReasoner.parseNumberIfExists(versionNumbers, 0);
        int minor = PelletReasoner.parseNumberIfExists(versionNumbers, 1);
        int patch = PelletReasoner.parseNumberIfExists(versionNumbers, 2);
        int build = PelletReasoner.parseNumberIfExists(versionNumbers, 3);
        return new Version(major, minor, patch, build);
    }

    private static int parseNumberIfExists(String[] numbers, int index) {
        try {
            if (0 <= index && index < numbers.length) {
                return Integer.parseInt(numbers[index]);
            }
        }
        catch (NumberFormatException e2) {
            log.log(Level.FINE, "Invalid number in version identifier: " + numbers[index], e2);
        }
        return 0;
    }

    private static IRI iri(ATermAppl term) {
        if (term.getArity() != 0) {
            throw new OWLRuntimeException("Trying to convert an anonymous term " + term);
        }
        return IRI.create((String)term.getName());
    }

    public PelletReasoner(OWLOntology ontology, BufferingMode bufferingMode) {
        this(ontology, (OWLReasonerConfiguration)new SimpleConfiguration((ReasonerProgressMonitor)new NullReasonerProgressMonitor(), PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW, 0L, IndividualNodeSetPolicy.BY_SAME_AS), bufferingMode);
    }

    public PelletReasoner(OWLOntology ontology, OWLReasonerConfiguration config, BufferingMode bufferingMode) throws IllegalConfigurationException {
        this.individualNodeSetPolicy = config.getIndividualNodeSetPolicy();
        if (!this.getFreshEntityPolicy().equals((Object)config.getFreshEntityPolicy())) {
            throw new IllegalConfigurationException("PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING conflicts with reasoner configuration", config);
        }
        this.ontology = ontology;
        this.monitor = config.getProgressMonitor();
        this.kb = new KnowledgeBase();
        this.kb.setTaxonomyBuilderProgressMonitor(new ProgressAdapter(this.monitor));
        if (config.getTimeOut() > 0L) {
            this.kb.timers.mainTimer.setTimeout(config.getTimeOut());
        }
        this.manager = ontology.getOWLOntologyManager();
        this.factory = this.manager.getOWLDataFactory();
        this.visitor = new PelletVisitor(this.kb);
        this.bufferingMode = bufferingMode;
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.shouldRefresh = true;
        this.pendingChanges = new ArrayList<OWLOntologyChange>();
        this.refresh();
    }

    private PelletRuntimeException convert(PelletRuntimeException e2) throws InconsistentOntologyException, ReasonerInterruptedException, TimeOutException, FreshEntitiesException {
        if (e2 instanceof TimeoutException) {
            throw new TimeOutException();
        }
        if (e2 instanceof TimerInterruptedException) {
            throw new ReasonerInterruptedException((Throwable)e2);
        }
        if (e2 instanceof org.mindswap.pellet.exceptions.InconsistentOntologyException) {
            throw new InconsistentOntologyException();
        }
        if (e2 instanceof UndefinedEntityException) {
            Set unknown = Collections.emptySet();
            throw new FreshEntitiesException(unknown);
        }
        return e2;
    }

    public void dispose() {
        this.kb = null;
        this.manager.removeOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    public void flush() {
        this.processChanges(this.pendingChanges);
        this.pendingChanges.clear();
        this.refreshCheck();
    }

    public Node<OWLClass> getBottomClassNode() {
        this.refreshCheck();
        return this.toClassNode(this.kb.getAllEquivalentClasses(ATermUtils.BOTTOM));
    }

    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_DATA_PROPERTY));
    }

    public Node<OWLObjectProperty> getBottomObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.BOTTOM_OBJECT_PROPERTY));
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        HashSet<Node<OWLClass>> nodes = new HashSet<Node<OWLClass>>();
        try {
            ATermAppl some = ATermUtils.makeSomeValues(this.term((OWLObject)pe), ATermUtils.TOP_LIT);
            for (Set<ATermAppl> cls : this.kb.getSuperClasses(some, direct)) {
                nodes.add(this.toClassNode(cls));
            }
            return new OWLClassNodeSet(nodes);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual ind, OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getDataPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Set<OWLLiteral> getAnnotationPropertyValues(OWLNamedIndividual ind, OWLAnnotationProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toLiteralSet(this.kb.getPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getDifferents(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> values = new HashSet<Node<OWLClass>>();
            for (Set<ATermAppl> val : this.kb.getDisjointClasses(this.term((OWLObject)ce), direct)) {
                values.add(this.toClassNode(val));
            }
            return new OWLClassNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this.kb.getDisjointProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLObjectProperty> getDisjointObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectProperty>> values = new HashSet<Node<OWLObjectProperty>>();
            for (Set<ATermAppl> val : this.kb.getDisjointProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getEquivalentClasses(this.term((OWLObject)ce)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toDataPropertyNode(this.kb.getEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Node<OWLObjectProperty> getEquivalentObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getEquivalentProperties(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetBySameAs(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        HashSet<ATermAppl> seen = new HashSet<ATermAppl>();
        for (ATermAppl ind : individuals) {
            if (seen.contains(ind)) continue;
            Set<ATermAppl> equiv = this.kb.getAllSames(ind);
            instances.add(this.toIndividualNode(equiv));
            seen.addAll(equiv);
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSetByName(Collection<ATermAppl> individuals) {
        HashSet<Node<OWLNamedIndividual>> instances = new HashSet<Node<OWLNamedIndividual>>();
        for (ATermAppl ind : individuals) {
            for (ATermAppl equiv : this.kb.getAllSames(ind)) {
                instances.add(this.toIndividualNode(equiv));
            }
        }
        return new OWLNamedIndividualNodeSet(instances);
    }

    private NodeSet<OWLNamedIndividual> getIndividualNodeSet(Collection<ATermAppl> individuals) {
        if (IndividualNodeSetPolicy.BY_NAME.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetByName(individuals);
        }
        if (IndividualNodeSetPolicy.BY_SAME_AS.equals((Object)this.individualNodeSetPolicy)) {
            return this.getIndividualNodeSetBySameAs(individuals);
        }
        throw new AssertionError((Object)("Unsupported IndividualNodeSetPolicy : " + this.individualNodeSetPolicy));
    }

    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getInstances(this.term((OWLObject)ce), direct));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Node<OWLObjectProperty> getInverseObjectProperties(OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toObjectPropertyNode(this.kb.getInverses(this.term((OWLObject)pe)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> nodes = new HashSet<Node<OWLClass>>();
            ATermAppl some = ATermUtils.makeSomeValues(this.term((OWLObject)pe), ATermUtils.TOP);
            for (Set<ATermAppl> cls : this.kb.getSuperClasses(some, direct)) {
                nodes.add(this.toClassNode(cls));
            }
            return new OWLClassNodeSet(nodes);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> nodes = new HashSet<Node<OWLClass>>();
            ATermAppl some = ATermUtils.makeSomeValues(ATermUtils.makeInv(this.term((OWLObject)pe)), ATermUtils.TOP);
            for (Set<ATermAppl> cls : this.kb.getSuperClasses(some, direct)) {
                nodes.add(this.toClassNode(cls));
            }
            return new OWLClassNodeSet(nodes);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual ind, OWLObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.getIndividualNodeSet(this.kb.getObjectPropertyValues(this.term((OWLObject)pe), this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public Set<OWLAxiom> getPendingAxiomAdditions() {
        return Collections.emptySet();
    }

    public Set<OWLAxiom> getPendingAxiomRemovals() {
        return Collections.emptySet();
    }

    public List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges;
    }

    public String getReasonerName() {
        return PelletReasonerFactory.getInstance().getReasonerName();
    }

    public Version getReasonerVersion() {
        return VERSION;
    }

    public OWLOntology getRootOntology() {
        return this.ontology;
    }

    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual ind) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toIndividualNode(this.kb.getAllSames(this.term((OWLObject)ind)));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> values = new HashSet<Node<OWLClass>>();
            for (Set<ATermAppl> val : this.kb.getSubClasses(this.term((OWLObject)ce), direct)) {
                values.add(this.toClassNode(val));
            }
            return new OWLClassNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this.kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLObjectProperty> getSubObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectProperty>> values = new HashSet<Node<OWLObjectProperty>>();
            for (Set<ATermAppl> val : this.kb.getSubProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> values = new HashSet<Node<OWLClass>>();
            for (Set<ATermAppl> val : this.kb.getSuperClasses(this.term((OWLObject)ce), direct)) {
                values.add(this.toClassNode(val));
            }
            return new OWLClassNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLDataProperty>> values = new HashSet<Node<OWLDataProperty>>();
            for (Set<ATermAppl> val : this.kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toDataPropertyNode(val));
            }
            return new OWLDataPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public NodeSet<OWLObjectProperty> getSuperObjectProperties(OWLObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLObjectProperty>> values = new HashSet<Node<OWLObjectProperty>>();
            for (Set<ATermAppl> val : this.kb.getSuperProperties(this.term((OWLObject)pe), direct)) {
                values.add(this.toObjectPropertyNode(val));
            }
            return new OWLObjectPropertyNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public long getTimeOut() {
        return this.kb.timers.mainTimer.getTimeout();
    }

    public Node<OWLClass> getTopClassNode() {
        this.refreshCheck();
        return this.toClassNode(this.kb.getAllEquivalentClasses(ATermUtils.TOP));
    }

    public Node<OWLDataProperty> getTopDataPropertyNode() {
        this.refreshCheck();
        return this.toDataPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_DATA_PROPERTY));
    }

    public Node<OWLObjectProperty> getTopObjectPropertyNode() {
        this.refreshCheck();
        return this.toObjectPropertyNode(this.kb.getAllEquivalentProperties(ATermUtils.TOP_OBJECT_PROPERTY));
    }

    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            HashSet<Node<OWLClass>> values = new HashSet<Node<OWLClass>>();
            for (Set<ATermAppl> val : this.kb.getTypes(this.term((OWLObject)ind), direct)) {
                values.add(this.toClassNode(val));
            }
            return new OWLClassNodeSet(values);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.toClassNode(this.kb.getUnsatisfiableClasses());
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public void interrupt() {
        this.kb.timers.interrupt();
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        try {
            return this.kb.isConsistent();
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public boolean isEntailed(OWLAxiom axiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.isEntailed(Collections.singleton(axiom));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public boolean isEntailed(Set<? extends OWLAxiom> axioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            EntailmentChecker entailmentChecker = new EntailmentChecker(this);
            return entailmentChecker.isEntailed(axioms);
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public boolean isEntailmentCheckingSupported(AxiomType<?> axiomType) {
        return !EntailmentChecker.UNSUPPORTED_ENTAILMENT.contains(axiomType);
    }

    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.refreshCheck();
        try {
            return this.kb.isSatisfiable(this.term((OWLObject)classExpression));
        }
        catch (PelletRuntimeException e2) {
            throw this.convert(e2);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
        switch (this.bufferingMode) {
            case BUFFERING: {
                this.pendingChanges.addAll(changes);
                break;
            }
            case NON_BUFFERING: {
                this.processChanges(changes);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected buffering mode: " + this.bufferingMode));
            }
        }
    }

    public boolean processChanges(List<? extends OWLOntologyChange> changes) {
        if (this.shouldRefresh) {
            return false;
        }
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (log.isLoggable(Level.FINER)) {
                log.fine("Changed: " + oWLOntologyChange + " in " + oWLOntologyChange.getOntology());
            }
            if (!this.importsClosure.contains(oWLOntologyChange.getOntology()) || this.changeVisitor.process(oWLOntologyChange)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Reload required by ontology change " + oWLOntologyChange);
            }
            this.shouldRefresh = true;
            break;
        }
        return !this.shouldRefresh;
    }

    public void prepareReasoner() throws ReasonerInterruptedException, TimeOutException {
        this.refreshCheck();
        if (this.kb.isConsistent()) {
            this.kb.realize();
        }
    }

    public void refresh() {
        this.visitor.clear();
        this.kb.clear();
        this.importsClosure = this.ontology.getImportsClosure();
        this.visitor.setAddAxiom(true);
        for (OWLOntology ont : this.importsClosure) {
            ont.accept((OWLObjectVisitor)this.visitor);
        }
        this.visitor.verify();
        this.shouldRefresh = false;
    }

    private void refreshCheck() {
        if (this.kb == null) {
            throw new OWLRuntimeException("Trying to use a disposed reasoner");
        }
        if (this.shouldRefresh) {
            this.refresh();
        }
    }

    public ATermAppl term(OWLObject d) {
        this.refreshCheck();
        this.visitor.reset();
        this.visitor.setAddAxiom(false);
        d.accept((OWLObjectVisitor)this.visitor);
        ATermAppl a = this.visitor.result();
        if (a == null) {
            throw new InternalReasonerException("Cannot create ATerm from description " + d);
        }
        return a;
    }

    private Node<OWLClass> toClassNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLClassNode(this.CLASS_MAPPER.map(terms));
    }

    private Node<OWLDataProperty> toDataPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLDataPropertyNode(this.DP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLNamedIndividualNode(this.IND_MAPPER.map(terms));
    }

    private Set<OWLLiteral> toLiteralSet(Collection<ATermAppl> terms) {
        return this.LIT_MAPPER.map(terms);
    }

    private Node<OWLObjectProperty> toObjectPropertyNode(Set<ATermAppl> terms) {
        return NodeFactory.getOWLObjectPropertyNode(this.OP_MAPPER.map(terms));
    }

    private Node<OWLNamedIndividual> toIndividualNode(ATermAppl term) {
        return NodeFactory.getOWLNamedIndividualNode((OWLNamedIndividual)this.IND_MAPPER.map(term));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjectPropertyMapper
    extends EntityMapper<OWLObjectProperty> {
        private ObjectPropertyMapper() {
        }

        @Override
        public OWLObjectProperty map(ATermAppl term) {
            if (ATermUtils.TOP_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLTopObjectProperty();
            }
            if (ATermUtils.BOTTOM_OBJECT_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLBottomObjectProperty();
            }
            return PelletReasoner.this.factory.getOWLObjectProperty(PelletReasoner.iri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedIndividualMapper
    extends EntityMapper<OWLNamedIndividual> {
        private NamedIndividualMapper() {
        }

        @Override
        public OWLNamedIndividual map(ATermAppl term) {
            if (ATermUtils.isBnode(term)) {
                return null;
            }
            return PelletReasoner.this.factory.getOWLNamedIndividual(PelletReasoner.iri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LiteralMapper
    extends EntityMapper<OWLLiteral> {
        private LiteralMapper() {
        }

        @Override
        public OWLLiteral map(ATermAppl term) {
            String lexValue = ((ATermAppl)term.getArgument(0)).toString();
            ATermAppl lang = (ATermAppl)term.getArgument(1);
            ATermAppl dtype = (ATermAppl)term.getArgument(2);
            if (dtype.equals(ATermUtils.PLAIN_LITERAL_DATATYPE)) {
                if (lang.equals(ATermUtils.EMPTY)) {
                    return PelletReasoner.this.factory.getOWLStringLiteral(lexValue);
                }
                return PelletReasoner.this.factory.getOWLStringLiteral(lexValue, lang.toString());
            }
            OWLDatatype datatype = (OWLDatatype)PelletReasoner.this.DT_MAPPER.map(dtype);
            return PelletReasoner.this.factory.getOWLTypedLiteral(lexValue, datatype);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EntityMapper<T extends OWLObject> {
        private EntityMapper() {
        }

        public abstract T map(ATermAppl var1);

        public final Set<T> map(Collection<ATermAppl> terms) {
            HashSet<T> mappedSet = new HashSet<T>();
            for (ATermAppl term : terms) {
                T mapped = this.map(term);
                if (mapped == null) continue;
                mappedSet.add(mapped);
            }
            return mappedSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DatatypeMapper
    extends EntityMapper<OWLDatatype> {
        private DatatypeMapper() {
        }

        @Override
        public OWLDatatype map(ATermAppl term) {
            return PelletReasoner.this.factory.getOWLDatatype(PelletReasoner.iri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataPropertyMapper
    extends EntityMapper<OWLDataProperty> {
        private DataPropertyMapper() {
        }

        @Override
        public OWLDataProperty map(ATermAppl term) {
            if (ATermUtils.TOP_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLTopDataProperty();
            }
            if (ATermUtils.BOTTOM_DATA_PROPERTY.equals(term)) {
                return PelletReasoner.this.factory.getOWLBottomDataProperty();
            }
            return PelletReasoner.this.factory.getOWLDataProperty(PelletReasoner.iri(term));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassMapper
    extends EntityMapper<OWLClass> {
        private ClassMapper() {
        }

        @Override
        public OWLClass map(ATermAppl term) {
            if (term.equals(ATermUtils.TOP)) {
                return PelletReasoner.this.factory.getOWLThing();
            }
            if (term.equals(ATermUtils.BOTTOM)) {
                return PelletReasoner.this.factory.getOWLNothing();
            }
            return PelletReasoner.this.factory.getOWLClass(PelletReasoner.iri(term));
        }
    }

    private class ChangeVisitor
    implements OWLOntologyChangeVisitor {
        private boolean reloadRequired;

        private ChangeVisitor() {
        }

        public boolean isReloadRequired() {
            return this.reloadRequired;
        }

        public boolean process(OWLOntologyChange change) {
            this.reset();
            change.accept((OWLOntologyChangeVisitor)this);
            return !this.isReloadRequired();
        }

        public void reset() {
            PelletReasoner.this.visitor.reset();
            this.reloadRequired = false;
        }

        public void visit(AddAxiom change) {
            PelletReasoner.this.visitor.setAddAxiom(true);
            change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(RemoveAxiom change) {
            PelletReasoner.this.visitor.setAddAxiom(false);
            change.getAxiom().accept((OWLObjectVisitor)PelletReasoner.this.visitor);
            this.reloadRequired = PelletReasoner.this.visitor.isReloadRequired();
        }

        public void visit(AddImport change) {
            this.reloadRequired = true;
        }

        public void visit(AddOntologyAnnotation change) {
        }

        public void visit(RemoveImport change) {
            this.reloadRequired = true;
        }

        public void visit(RemoveOntologyAnnotation change) {
        }

        public void visit(SetOntologyID change) {
        }
    }
}

