/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Fact;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaNode
extends Node {
    protected TermTuple pattern;

    public AlphaNode(TermTuple t) {
        this.pattern = t;
        this.vars = this.pattern.getVars();
    }

    public boolean add(Fact fact) {
        List<ATermAppl> key = this.match(fact);
        if (key != null) {
            this.markDirty();
            return this.index.add(key, new Fact(fact.getDependencySet(), key));
        }
        return false;
    }

    public void markDirty() {
        for (BetaNode beta : this.getBetas()) {
            beta.markDirty();
        }
    }

    private List<ATermAppl> match(Fact fact) {
        if (fact.getElements().size() != this.pattern.getElements().size()) {
            return null;
        }
        HashMap<ATermAppl, ATermAppl> bindings = new HashMap<ATermAppl, ATermAppl>();
        List pList = this.pattern.getElements();
        List fList = fact.getElements();
        ATermAppl p = null;
        ATermAppl f = null;
        for (int i = 0; i < this.pattern.getElements().size(); ++i) {
            p = (ATermAppl)pList.get(i);
            f = (ATermAppl)fList.get(i);
            if (!ATermUtils.isVar(p)) {
                if (p.equals(f)) continue;
                return null;
            }
            if (!bindings.containsKey(p)) {
                bindings.put(p, f);
                continue;
            }
            if (((ATermAppl)bindings.get(p)).equals(f)) continue;
            return null;
        }
        ArrayList<ATermAppl> bindingList = new ArrayList<ATermAppl>();
        for (ATermAppl var : this.getKey()) {
            bindingList.add((ATermAppl)bindings.get(var));
        }
        return bindingList;
    }

    public boolean remove(Fact fact) {
        List<ATermAppl> key = this.match(fact);
        if (key != null) {
            this.markDirty();
            return this.index.remove(key, new Fact(fact.getDependencySet(), key));
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        for (BetaNode beta : this.getBetas()) {
            beta.reset();
        }
    }

    public String toString() {
        return "AlphaNode(" + this.pattern.toString() + ")";
    }
}

