/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.sparqldl.engine;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryCost;
import com.clarkparsia.pellet.sparqldl.engine.QueryPlan;
import com.clarkparsia.pellet.sparqldl.engine.QuerySizeEstimator;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryPredicate;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.UnsupportedQueryException;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CostBasedQueryPlanNew
extends QueryPlan {
    private static final Logger log = Logger.getLogger(CostBasedQueryPlanNew.class.getName());
    private List<QueryAtom> sortedAtoms;
    private int index;
    private int size;
    private QueryCost cost;

    public CostBasedQueryPlanNew(Query query2) {
        super(query2);
        QuerySizeEstimator.computeSizeEstimate(query2);
        this.index = 0;
        this.size = query2.getAtoms().size();
        this.cost = new QueryCost(query2.getKB());
        this.sortedAtoms = null;
        if (this.size == 0) {
            return;
        }
        if (this.size == 1) {
            this.sortedAtoms = query2.getAtoms();
        } else {
            double minCost = this.chooseOrdering(new ArrayList<QueryAtom>(query2.getAtoms()), new ArrayList<QueryAtom>(this.size), new HashSet<ATermAppl>(), false, Double.POSITIVE_INFINITY);
            if (this.sortedAtoms == null) {
                throw new UnsupportedQueryException("No safe ordering for query: " + query2);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "WINNER : Cost=" + minCost + " ,atoms=" + this.sortedAtoms);
            }
        }
    }

    private double chooseOrdering(List<QueryAtom> atoms, List<QueryAtom> orderedAtoms, Set<ATermAppl> boundVars, boolean notOptimal, double minCost) {
        if (atoms.isEmpty()) {
            if (notOptimal) {
                if (this.sortedAtoms == null) {
                    this.sortedAtoms = new ArrayList<QueryAtom>(orderedAtoms);
                }
            } else {
                double queryCost = this.cost.estimate(orderedAtoms);
                log.fine("Cost " + queryCost + " for " + orderedAtoms);
                if (queryCost < minCost) {
                    this.sortedAtoms = new ArrayList<QueryAtom>(orderedAtoms);
                    minCost = queryCost;
                }
            }
            return minCost;
        }
        block0: for (int i = 0; i < atoms.size(); ++i) {
            QueryAtom atom = atoms.get(i);
            boolean newNonOptimal = notOptimal;
            HashSet<ATermAppl> newBoundVars = new HashSet<ATermAppl>(boundVars);
            if (!atom.isGround()) {
                int boundCount = 0;
                int unboundCount = 0;
                for (ATermAppl a : atom.getArguments()) {
                    if (!ATermUtils.isVar(a)) continue;
                    if (newBoundVars.add(a)) {
                        ++unboundCount;
                        if (!atom.getPredicate().equals((Object)QueryPredicate.NotKnown)) continue;
                        for (int j = 0; j < atoms.size(); ++j) {
                            QueryAtom nextAtom = atoms.get(j);
                            if (i == j || nextAtom.getPredicate().equals((Object)QueryPredicate.NotKnown) || !nextAtom.getArguments().contains(a)) continue;
                            if (!log.isLoggable(Level.FINE)) continue block0;
                            log.fine("Unbound vars for not");
                            continue block0;
                        }
                        continue;
                    }
                    ++boundCount;
                }
                if (boundCount == 0 && newBoundVars.size() > unboundCount) {
                    if (this.sortedAtoms != null) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("Stop at not optimal ordering");
                        continue;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Continue not optimal ordering, no solution yet.");
                    }
                    newNonOptimal = true;
                }
            }
            atoms.remove(atom);
            orderedAtoms.add(atom);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Atom[" + i + "/" + atoms.size() + "] " + atom + " from " + atoms + " to " + orderedAtoms);
            }
            minCost = this.chooseOrdering(atoms, orderedAtoms, newBoundVars, newNonOptimal, minCost);
            atoms.add(i, atom);
            orderedAtoms.remove(orderedAtoms.size() - 1);
        }
        return minCost;
    }

    @Override
    public QueryAtom next(ResultBinding binding) {
        return this.sortedAtoms.get(this.index++).apply(binding);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public void back() {
        --this.index;
    }

    @Override
    public void reset() {
        this.index = 0;
    }
}

