/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ReaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSearcher
extends Searcher {
    IndexReader reader;
    private boolean closeReader;
    protected IndexReader[] subReaders;
    protected int[] docStarts;
    private boolean fieldSortDoTrackScores;
    private boolean fieldSortDoMaxScore;

    public IndexSearcher(Directory path) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, true), true);
    }

    public IndexSearcher(Directory path, boolean readOnly) throws CorruptIndexException, IOException {
        this(IndexReader.open(path, readOnly), true);
    }

    public IndexSearcher(IndexReader r) {
        this(r, false);
    }

    public IndexSearcher(IndexReader reader, IndexReader[] subReaders, int[] docStarts) {
        this.reader = reader;
        this.subReaders = subReaders;
        this.docStarts = docStarts;
        this.closeReader = false;
    }

    private IndexSearcher(IndexReader r, boolean closeReader) {
        this.reader = r;
        this.closeReader = closeReader;
        ArrayList<IndexReader> subReadersList = new ArrayList<IndexReader>();
        this.gatherSubReaders(subReadersList, this.reader);
        this.subReaders = subReadersList.toArray(new IndexReader[subReadersList.size()]);
        this.docStarts = new int[this.subReaders.length];
        int maxDoc = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.docStarts[i] = maxDoc;
            maxDoc += this.subReaders[i].maxDoc();
        }
    }

    protected void gatherSubReaders(List<IndexReader> allSubReaders, IndexReader r) {
        ReaderUtil.gatherSubReaders(allSubReaders, r);
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    @Override
    public void close() throws IOException {
        if (this.closeReader) {
            this.reader.close();
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return this.reader.docFreq(term);
    }

    @Override
    public Document doc(int i) throws CorruptIndexException, IOException {
        return this.reader.document(i);
    }

    @Override
    public Document doc(int i, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.reader.document(i, fieldSelector);
    }

    @Override
    public int maxDoc() throws IOException {
        return this.reader.maxDoc();
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        if (nDocs <= 0) {
            throw new IllegalArgumentException("nDocs must be > 0");
        }
        TopScoreDocCollector collector = TopScoreDocCollector.create(nDocs, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter, (Collector)collector);
        return collector.topDocs();
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        return this.search(weight, filter, nDocs, sort, true);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort, boolean fillFields) throws IOException {
        TopFieldCollector collector = TopFieldCollector.create(sort, nDocs, fillFields, this.fieldSortDoTrackScores, this.fieldSortDoMaxScore, !weight.scoresDocsOutOfOrder());
        this.search(weight, filter, (Collector)collector);
        return (TopFieldDocs)collector.topDocs();
    }

    @Override
    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        if (filter == null) {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                Scorer scorer = weight.scorer(this.subReaders[i], !collector.acceptsDocsOutOfOrder(), true);
                if (scorer == null) continue;
                scorer.score(collector);
            }
        } else {
            for (int i = 0; i < this.subReaders.length; ++i) {
                collector.setNextReader(this.subReaders[i], this.docStarts[i]);
                this.searchWithFilter(this.subReaders[i], weight, filter, collector);
            }
        }
    }

    private void searchWithFilter(IndexReader reader, Weight weight, Filter filter, Collector collector) throws IOException {
        assert (filter != null);
        Scorer scorer = weight.scorer(reader, true, false);
        if (scorer == null) {
            return;
        }
        int docID = scorer.docID();
        assert (docID == -1 || docID == Integer.MAX_VALUE);
        DocIdSet filterDocIdSet = filter.getDocIdSet(reader);
        if (filterDocIdSet == null) {
            return;
        }
        DocIdSetIterator filterIter = filterDocIdSet.iterator();
        if (filterIter == null) {
            return;
        }
        int filterDoc = filterIter.nextDoc();
        int scorerDoc = scorer.advance(filterDoc);
        collector.setScorer(scorer);
        while (true) {
            if (scorerDoc == filterDoc) {
                if (scorerDoc == Integer.MAX_VALUE) break;
                collector.collect(scorerDoc);
                filterDoc = filterIter.nextDoc();
                scorerDoc = scorer.advance(filterDoc);
                continue;
            }
            if (scorerDoc > filterDoc) {
                filterDoc = filterIter.advance(scorerDoc);
                continue;
            }
            scorerDoc = scorer.advance(filterDoc);
        }
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        Query query2 = original;
        Query rewrittenQuery = query2.rewrite(this.reader);
        while (rewrittenQuery != query2) {
            query2 = rewrittenQuery;
            rewrittenQuery = query2.rewrite(this.reader);
        }
        return query2;
    }

    @Override
    public Explanation explain(Weight weight, int doc) throws IOException {
        int n = ReaderUtil.subIndex(doc, this.docStarts);
        int deBasedDoc = doc - this.docStarts[n];
        return weight.explain(this.subReaders[n], deBasedDoc);
    }

    public void setDefaultFieldSortScoring(boolean doTrackScores, boolean doMaxScore) {
        this.fieldSortDoTrackScores = doTrackScores;
        this.fieldSortDoMaxScore = doMaxScore;
    }
}

