/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical;

import java.io.Serializable;
import org.eaglei.model.EIURI;

public class EntityMatchRequest
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String text;
    private EIURI uri;
    private String property;
    private int maxMatches;

    public EntityMatchRequest(String text) {
        assert (text != null);
        assert (!text.isEmpty());
        this.text = text;
    }

    public EntityMatchRequest(String text, EIURI uri) {
        this(text);
        this.uri = uri;
    }

    public String getText() {
        return this.text;
    }

    public EIURI getURI() {
        return this.uri;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public int getMaxMatches() {
        return this.maxMatches;
    }

    public void setMaxMatches(int maxMatches) {
        assert (maxMatches >= 0);
        this.maxMatches = maxMatches;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
        result = 31 * result + this.maxMatches;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityMatchRequest other = (EntityMatchRequest)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return this.maxMatches == other.maxMatches;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.text);
        sb.append("] ");
        sb.append(" (");
        if (this.uri != null) {
            sb.append("type: ");
            sb.append(this.uri.toString());
            sb.append(", ");
        }
        if (this.property != null) {
            sb.append("property: ");
            sb.append(this.property.toString());
            sb.append(", ");
        }
        sb.append("max matches: ");
        sb.append(this.maxMatches);
        sb.append(")");
        return sb.toString();
    }
}

