/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eaglei.network.actions.EagleIQueryActions;
import org.eaglei.network.actions.NetworkSearchConfig;
import org.eaglei.network.actions.QueryActionInstantiationException;
import org.eaglei.network.driver.Query;
import org.spin.node.DestroyableQueryActionMap;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;
import org.spin.tools.Util;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public final class EagleIQueryActionMap
extends DestroyableQueryActionMap {
    private final Set<String> knownQueryTypes = Collections.unmodifiableSet(Util.asSet(EagleIQueryActions.queryTypes));
    private final Map<Query, QueryAction<?>> queryTypesToActions = Util.makeEnumMap(Query.class);
    final ApplicationContext context = new AnnotationConfigApplicationContext(NetworkSearchConfig.class);

    public boolean containsQueryType(String queryType) {
        return this.knownQueryTypes.contains(queryType);
    }

    public QueryAction<?> getQueryAction(String queryType) throws UnknownQueryTypeException {
        this.guardContainsQueryType(queryType);
        QueryAction<?> action = this.queryTypesToActions.get((Object)Query.fromQueryType(queryType));
        if (action != null) {
            return action;
        }
        EagleIQueryActions queryActionDef = EagleIQueryActionMap.makeQueryActionDef(queryType);
        return this.createAndCacheQueryAction(queryActionDef);
    }

    private QueryAction<?> createAndCacheQueryAction(EagleIQueryActions queryActionDef) {
        try {
            QueryAction<?> newAction = this.createQueryAction(queryActionDef);
            this.queryTypesToActions.put(queryActionDef.query(), newAction);
            return newAction;
        }
        catch (BeansException e2) {
            throw new QueryActionInstantiationException("Couldn't instantiate query with type '" + queryActionDef.query().queryType + "' (tried to instantiate a " + queryActionDef.queryActionClass().getName() + ")", e2);
        }
    }

    void guardContainsQueryType(String queryType) throws UnknownQueryTypeException {
        if (!this.containsQueryType(queryType)) {
            throw new UnknownQueryTypeException("Unknown query type '" + queryType + "': known values are " + this.knownQueryTypes);
        }
    }

    private static EagleIQueryActions makeQueryActionDef(String queryType) {
        return EagleIQueryActions.fromQueryType(queryType);
    }

    private QueryAction<?> createQueryAction(EagleIQueryActions queryActionDef) throws BeansException {
        return queryActionDef.obtainQueryAction(this.context);
    }

    public Collection<String> getQueryTypes() {
        return this.knownQueryTypes;
    }
}

