/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.logging;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LogInfo {
    protected static final Log logger = LogFactory.getLog(LogInfo.class);
    private static MessageDigest hashFunction = null;
    protected static final String NOT_RECORDED = "Not recorded";
    protected static final String NOT_AVAILABLE = "Not available";

    LogInfo() {
        this.getHashFunction();
    }

    public final String oneWayHash(String s) {
        byte[] bytes;
        if (hashFunction == null) {
            return NOT_RECORDED;
        }
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            bytes = s.getBytes();
        }
        byte[] hash = hashFunction.digest(bytes);
        return this.getHexString(hash);
    }

    private final synchronized void getHashFunction() {
        if (hashFunction == null) {
            try {
                hashFunction = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e2) {
                hashFunction = null;
            }
            if (hashFunction == null) {
                logger.error("AsychronousLogger could not find a suitable hash function. User identities will be logged as 'Not recorded'");
            }
        }
    }

    private String getHexString(byte[] bytes) {
        String result = "";
        for (int i = 0; i < bytes.length; ++i) {
            result = result + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

