/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.search.provider.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.engine.http.QueryEngineHTTP;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResult;
import org.eaglei.search.provider.rdf.AbstractRDFProvider;
import org.eaglei.services.repository.RepositoryHttpConfig;

public class SPARQLProtocolProvider
extends AbstractRDFProvider {
    private static final Log logger = LogFactory.getLog(SPARQLProtocolProvider.class);
    private RepositoryHttpConfig repoConfig;

    public SPARQLProtocolProvider(EIOntModel eagleiOntModel, EIEntity institution, RepositoryHttpConfig repoConfig) {
        super(eagleiOntModel, institution);
        this.repoConfig = repoConfig;
    }

    @Override
    protected SearchResult createSearchResultFromModel(String uri, Model model) {
        SearchResult result = super.createSearchResultFromModel(uri, model);
        if (result != null) {
            result.setURL(result.getEntity().toString());
        }
        return result;
    }

    @Override
    protected QueryExecution getQueryExecution(Query query2) {
        QueryEngineHTTP qe = (QueryEngineHTTP)QueryExecutionFactory.sparqlService(this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.SPARQL_URL), query2);
        if (this.repoConfig.getSearchUsername() != null && this.repoConfig.getSearchPassword() != null) {
            qe.setBasicAuthentication(this.repoConfig.getSearchUsername(), this.repoConfig.getSearchPassword().toCharArray());
            qe.addDefaultGraph("http://eagle-i.org/ont/repo/1.0/NG_Published");
        }
        return qe;
    }

    @Override
    public ClassCountResult getResourceCount(SearchRequest request) {
        return null;
    }

    @Override
    public ClassCountResult getProviderTypeCount(SearchRequest request) {
        return null;
    }
}

