/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.solr.LuceneIndexSchema;

public abstract class AbstractLuceneIndexer
implements ResourceChangeListener,
LuceneIndexSchema {
    private static final Log logger = LogFactory.getLog(AbstractLuceneIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    protected String indexerLabel;
    private int count;
    protected EIOntModel eiOntModel;
    protected Analyzer analyzer;
    protected Directory directory;
    private boolean indexEmpty;
    private IndexWriter iwriter;
    private HashMap<EIURI, List<Document>> mapURIToDocuments;
    private Set<EIEntity> resourceRoots = new HashSet<EIEntity>();
    private Set<EIEntity> setInsitutionsWithInitialData = new HashSet<EIEntity>();
    private static final EIURI RESOURCE_PROVIDER_PROPERTY = EIURI.create("http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider");

    public AbstractLuceneIndexer(String indexerLabel, EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        this.indexerLabel = indexerLabel;
        this.eiOntModel = eiOntModel;
        this.analyzer = analyzer;
        this.directory = directory;
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.resourceRoots.add(c.getEntity());
        }
        this.indexEmpty = true;
    }

    protected IndexWriter getWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        return new IndexWriter(this.directory, this.analyzer, IndexWriter.MaxFieldLength.LIMITED);
    }

    @Override
    public void onChangeStreamStart(EIEntity institution) {
        logger.debug(this.indexerLabel + ": onChangeStreamStart: " + institution.getLabel());
        this.count = 0;
        try {
            this.iwriter = this.getWriter();
            this.mapURIToDocuments = new HashMap();
        }
        catch (IOException e2) {
            logger.error(this.indexerLabel + ": Error creating lucene IndexWriter" + e2);
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        assert (event != null) : this.indexerLabel + ": Null change event notification";
        ++this.count;
        if (this.count % 500 == 0) {
            logger.debug(this.indexerLabel + ": Received " + this.count + " change events...");
        }
    }

    @Override
    public boolean onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        logger.debug(this.indexerLabel + ": onChangeStreamEnd: " + institution.getLabel() + "   num change events " + this.count + " last modifed: " + dateFormat.format(lastModifiedDate));
        return this.commitDocumentCache(institution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean commitDocumentCache(EIEntity institution) {
        boolean success = false;
        try {
            for (EIURI uri : this.mapURIToDocuments.keySet()) {
                if (this.setInsitutionsWithInitialData.contains(institution)) {
                    logger.debug(this.indexerLabel + ": Updating " + uri.toString());
                }
                List<Document> docs = this.mapURIToDocuments.get(uri);
                if (!this.indexEmpty) {
                    this.deleteDocumentsFromIndex(uri);
                }
                for (Document doc : docs) {
                    this.iwriter.addDocument(doc);
                }
            }
            if (this.mapURIToDocuments.size() <= 0) return success;
            this.indexEmpty = false;
            this.setInsitutionsWithInitialData.add(institution);
            return success;
        }
        catch (Exception e2) {
            logger.error(this.indexerLabel + ": Error updating Documents: indexEmpty: " + this.indexEmpty, e2);
            return success;
        }
        finally {
            try {
                this.iwriter.close();
                success = true;
                logger.debug(this.indexerLabel + ": Wrote " + this.mapURIToDocuments.size() + " updated Documents to index.");
            }
            catch (Exception e3) {
                logger.error(this.indexerLabel + ": Error closing IndexWriter after Document update", e3);
                try {
                    if (IndexWriter.isLocked(this.directory)) {
                        IndexWriter.unlock(this.directory);
                    }
                }
                catch (IOException e2) {
                    logger.error(this.indexerLabel + ": Error unlocking after update", e2);
                }
            }
            finally {
                this.iwriter = null;
                this.mapURIToDocuments = null;
            }
        }
    }

    protected List<Document> getDocuments(EIURI uri) {
        List<Document> docs = this.mapURIToDocuments.get(uri);
        if (docs != null) {
            return docs;
        }
        if (!this.indexEmpty && (docs = this.getDocumentsFromIndex(uri)) != null) {
            this.setDocuments(uri, docs);
            return docs;
        }
        return docs;
    }

    protected void setDocuments(EIURI uri, List<Document> docs) {
        this.mapURIToDocuments.put(uri, docs);
    }

    protected List<Document> getDocumentsFromIndex(EIURI uri) {
        try {
            TermQuery uriQuery = new TermQuery(new Term("uri", uri.toString()));
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            searcher.setDefaultFieldSortScoring(true, true);
            TopDocs docs = searcher.search((Query)uriQuery, 1);
            if (docs.totalHits == 0) {
                return null;
            }
            ArrayList<Document> result = new ArrayList<Document>(docs.scoreDocs.length);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                result.add(searcher.doc(scoreDoc.doc));
            }
            return result;
        }
        catch (IOException e2) {
            logger.error(e2);
            return null;
        }
    }

    protected List<Document> deleteDocuments(EIURI uri) {
        List<Document> docs = this.getDocuments(uri);
        this.mapURIToDocuments.remove(uri);
        if (!this.indexEmpty) {
            this.deleteDocumentsFromIndex(uri);
        }
        return docs;
    }

    protected void deleteDocumentsFromIndex(EIURI uri) {
        try {
            TermQuery uriQuery = new TermQuery(new Term("uri", uri.toString()));
            this.iwriter.deleteDocuments((Query)uriQuery);
        }
        catch (IOException e2) {
            logger.error(this.indexerLabel + ": Unexpected error during delete", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize() {
        if (this.indexEmpty) {
            return;
        }
        logger.debug(this.indexerLabel + ": Optimizing index...");
        IndexWriter iwriter = null;
        try {
            iwriter = this.getWriter();
            iwriter.optimize();
        }
        catch (Exception e2) {
            logger.error(this.indexerLabel + ": Unexpected error during optimize", e2);
        }
        finally {
            try {
                iwriter.close();
                logger.debug(this.indexerLabel + ": Optimize complete.");
            }
            catch (Exception e3) {
                logger.error(this.indexerLabel + ": Error closing IndexWriter after optimize", e3);
                try {
                    if (IndexWriter.isLocked(this.directory)) {
                        IndexWriter.unlock(this.directory);
                    }
                }
                catch (IOException e2) {
                    logger.error(this.indexerLabel + ": Error unlocking after optimize", e2);
                }
            }
        }
    }
}

