/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.harvest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.search.harvest.DataHarvester;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.search.harvest.ResourceChangeListener;

public final class MultiDataSourceStreamHarvester
implements PollingDataHarvester {
    private static final Log logger = LogFactory.getLog(MultiDataSourceStreamHarvester.class);
    private boolean hasInitialData = false;
    private final List<DataHarvester> harvesters;
    private MultiDataSourceHarvestPoller pollingThread;
    private final List<ResourceChangeListener> listeners = new ArrayList<ResourceChangeListener>();

    public MultiDataSourceStreamHarvester() {
        this.harvesters = new ArrayList<DataHarvester>();
    }

    public void addDataHarvester(DataHarvester harvester) {
        this.harvesters.add(harvester);
    }

    @Override
    public void addChangeListener(ResourceChangeListener listener) {
        for (DataHarvester harvester : this.harvesters) {
            harvester.addChangeListener(listener);
        }
        this.listeners.add(listener);
    }

    @Override
    public boolean hasInitialData() {
        return this.hasInitialData;
    }

    @Override
    public void startPolling() {
        if (this.pollingThread != null) {
            return;
        }
        this.pollingThread = new MultiDataSourceHarvestPoller();
        this.pollingThread.start();
    }

    @Override
    public void harvest() {
        for (DataHarvester harvester : this.harvesters) {
            harvester.harvest();
        }
    }

    protected void notifyOptimize() {
        for (ResourceChangeListener listener : this.listeners) {
            try {
                listener.optimize();
            }
            catch (Throwable t) {
                logger.error("Unexpected error during optimize notification", t);
            }
        }
    }

    static /* synthetic */ List access$000(MultiDataSourceStreamHarvester x0) {
        return x0.harvesters;
    }

    static /* synthetic */ Log access$100() {
        return logger;
    }

    static /* synthetic */ boolean access$200(MultiDataSourceStreamHarvester x0) {
        return x0.hasInitialData;
    }

    static /* synthetic */ boolean access$202(MultiDataSourceStreamHarvester x0, boolean x1) {
        x0.hasInitialData = x1;
        return x0.hasInitialData;
    }

    private class MultiDataSourceHarvestPoller
    extends Thread {
        MultiDataSourceHarvestPoller() {
            super("MultiDataSourceHarvestPoller");
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                for (DataHarvester harvester : MultiDataSourceStreamHarvester.access$000(MultiDataSourceStreamHarvester.this)) {
                    try {
                        harvester.harvest();
                    }
                    catch (Throwable t) {
                        MultiDataSourceStreamHarvester.access$100().error("Unexpected error during harvest", t);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {}
                }
                if (MultiDataSourceStreamHarvester.access$200(MultiDataSourceStreamHarvester.this)) ** continue;
                allHaveData = true;
                for (DataHarvester harvester : MultiDataSourceStreamHarvester.access$000(MultiDataSourceStreamHarvester.this)) {
                    if (harvester.hasInitialData()) continue;
                    allHaveData = false;
                    break;
                }
                if (!allHaveData) ** continue;
                MultiDataSourceStreamHarvester.this.notifyOptimize();
                MultiDataSourceStreamHarvester.access$202(MultiDataSourceStreamHarvester.this, true);
            }
        }
    }
}

