/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.harvest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.services.repository.ProviderUtils;
import org.eaglei.services.repository.RepositoryHttpConfig;
import org.eaglei.solr.harvest.AbstractStreamHarvester;

public final class RepositoryStreamHarvester
extends AbstractStreamHarvester {
    private static final Log logger = LogFactory.getLog(RepositoryStreamHarvester.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private String lastModifiedStr = null;
    private Date lastModifiedDate = null;
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final SimpleDateFormat preciseHTTPDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss.SSS zzz");
    private final RepositoryHttpConfig repoConfig;
    private HttpClient httpclient;
    private String harvestURL;

    public RepositoryStreamHarvester(EIOntModel eiOntModel, EIEntity institution, InstitutionRegistry institutionRegistry) {
        super(eiOntModel, institution);
        this.repoConfig = institutionRegistry.getRepositoryHttpConfig(institution.getURI().toString());
        this.httpclient = RepositoryHttpConfig.createHttpClient(this.repoConfig.getSearchUsername(), this.repoConfig.getSearchPassword());
        this.httpclient.setHttpConnectionManager(new SimpleHttpConnectionManager(false));
        this.harvestURL = this.repoConfig.getFullRepositoryUrl(RepositoryHttpConfig.RepositoryLocale.HARVEST_URL);
        if (DEBUG) {
            logger.debug("Created repository harvester for " + institution.getLabel() + " url: " + this.harvestURL);
        }
    }

    @Override
    public String getHarvestInfo() {
        if (this.lastModifiedDate != null) {
            return "Dataset:   " + formatWithTZ.format(this.lastModifiedDate) + "    [" + this.harvestURL + "]";
        }
        return this.harvestURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void harvest() {
        PostMethod method = new PostMethod(this.harvestURL);
        method.setParameter("view", "published-resources");
        method.setParameter("detail", "full");
        if (this.lastModifiedDate != null) {
            method.setParameter("after", format.format(this.lastModifiedDate) + "Z");
        }
        InputStream is = null;
        Reader in = null;
        OutputStreamWriter fw = null;
        try {
            Date newLastModifiedDate;
            int status = this.httpclient.executeMethod(method);
            if (status != 200) {
                if (status == 401) {
                    return;
                }
                String response = ProviderUtils.getStringFromInputStream(method.getResponseBodyAsStream());
                logger.error(this.harvestURL + ": failed with status: " + status + "\r\n" + response);
                return;
            }
            String newLastModifiedStr = method.getResponseHeader("X-Precise-Last-Modified").getValue();
            if (newLastModifiedStr.equals(this.lastModifiedStr)) {
                return;
            }
            try {
                newLastModifiedDate = preciseHTTPDate.parse(newLastModifiedStr);
            }
            catch (ParseException e2) {
                logger.error(this.harvestURL + ": Error parsing X-Precise-Last-Modified " + newLastModifiedStr);
                method.releaseConnection();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                }
                if (fw == null) return;
                try {
                    fw.close();
                    return;
                }
                catch (IOException e5) {
                    // empty catch block
                }
                return;
            }
            is = method.getResponseBodyAsStream();
            this.notifyChangeStreamStart();
            int count = this.generateResourceChangeEvents(is);
            if (!this.notifyChangeStreamEnd(newLastModifiedDate)) return;
            if (count > 0) {
                this.lastModifiedStr = newLastModifiedStr;
                this.lastModifiedDate = newLastModifiedDate;
                if (this.hasInitialData) return;
                if (count <= 0) return;
                this.hasInitialData = true;
                logger.debug(this.institution.getLabel() + " initial data has been harvested.");
                return;
            }
            StringBuilder buf = new StringBuilder("Response with zero events\r\n");
            buf.append("Request url: " + method.getURI() + "\r\n");
            buf.append("Request param: after: " + format.format(this.lastModifiedDate) + "Z" + "\r\n");
            buf.append("Reponse header: X-Precise-Last-Modified: " + newLastModifiedStr + "\r\n");
            logger.error(buf.toString());
            return;
        }
        catch (IOException e6) {
            logger.debug("Unexpected error in RepositoryStreamHarvester " + this.harvestURL, e6);
            return;
        }
        finally {
            method.releaseConnection();
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e7) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e8) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e9) {}
            }
        }
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        preciseHTTPDate.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT"), Locale.getDefault()));
    }
}

