/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.search;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eaglei.lexical.lucene.PorterStemAnalyzer;
import org.eaglei.model.EIOntModel;
import org.eaglei.search.harvest.PollingDataHarvester;
import org.eaglei.services.InstitutionRegistry;
import org.eaglei.solr.harvest.DataHarvesterConfig;
import org.eaglei.solr.search.ClassUsageCache;
import org.eaglei.solr.search.LuceneSearchIndexer;
import org.eaglei.solr.search.LuceneSearchProvider;
import org.eaglei.solr.search.LuceneSearchQueryBuilder;
import org.eaglei.solr.search.ProviderUsageCache;
import org.eaglei.solr.suggest.LuceneAutoSuggestConfig;
import org.eaglei.solr.suggest.LuceneDataSuggestProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataHarvesterConfig.class, LuceneAutoSuggestConfig.class})
public class LuceneSearchConfig {
    private static final Log logger = LogFactory.getLog(LuceneSearchConfig.class);
    @Autowired
    private EIOntModel eagleiOntModel;
    @Autowired
    private InstitutionRegistry institutionRegistry;
    @Autowired
    private LuceneDataSuggestProvider autoSuggestProvider;
    @Autowired
    private PollingDataHarvester dataHarvester;

    @Bean
    public Directory searchDirectory() {
        try {
            String indexDir = System.getProperty("org.eaglei.lucene.dir");
            if (indexDir != null) {
                indexDir = indexDir + "/search";
                indexDir = indexDir + "/" + this.institutionRegistry.getLocalNodeId();
                File dir = new File(indexDir);
                logger.debug("Using Lucene index directory: " + dir.getAbsolutePath());
                if (dir.exists()) {
                    File[] contents = dir.listFiles();
                    if (contents != null) {
                        for (File f : contents) {
                            if (f.delete()) continue;
                            throw new RuntimeException("Error deleting lucene directory: " + f.getAbsolutePath());
                        }
                    }
                    if (!dir.delete()) {
                        throw new RuntimeException("Error deleting lucene directory: " + dir.getAbsolutePath());
                    }
                    logger.debug("Deleted Lucene index directory: " + dir.getAbsolutePath());
                }
                if (!dir.mkdirs()) {
                    throw new RuntimeException("Error creating lucene directory: " + dir.getAbsolutePath());
                }
                return FSDirectory.open(dir);
            }
            RAMDirectory ram = new RAMDirectory();
            logger.debug("Using Lucene RAMDirectory " + ram.toString());
            return ram;
        }
        catch (IOException e2) {
            logger.error("Exception getting Lucene directory, using RAMDirectory. ", e2);
            return new RAMDirectory();
        }
    }

    @Bean
    public Analyzer searchIndexAnalyzer() {
        return new PorterStemAnalyzer();
    }

    @Bean
    public ClassUsageCache classUsageCache() {
        ClassUsageCache classUsageCache = new ClassUsageCache(this.eagleiOntModel);
        return classUsageCache;
    }

    @Bean
    public ProviderUsageCache providerUsageCache() {
        ProviderUsageCache providerUsageCache = new ProviderUsageCache(this.eagleiOntModel);
        return providerUsageCache;
    }

    @Bean
    public LuceneSearchIndexer searchIndexer() {
        LuceneSearchIndexer indexer = new LuceneSearchIndexer(this.eagleiOntModel, this.searchIndexAnalyzer(), this.searchDirectory(), this.classUsageCache(), this.providerUsageCache());
        this.dataHarvester.addChangeListener(indexer);
        return indexer;
    }

    @Bean
    public LuceneSearchQueryBuilder searchQueryBuilder() {
        return new LuceneSearchQueryBuilder(this.eagleiOntModel, this.searchIndexAnalyzer());
    }

    @Bean
    public LuceneSearchProvider searchProvider() {
        LuceneSearchProvider provider = new LuceneSearchProvider(this.eagleiOntModel, this.institutionRegistry, this.searchDirectory(), this.searchIndexAnalyzer(), this.searchQueryBuilder(), this.classUsageCache(), this.providerUsageCache(), this.autoSuggestProvider);
        return provider;
    }
}

