/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.solr.AbstractLuceneIndexer;
import org.eaglei.solr.search.ClassUsageCache;
import org.eaglei.solr.search.LuceneSearchIndexSchema;
import org.eaglei.solr.search.LuceneSearchUtil;
import org.eaglei.solr.search.ProviderUsageCache;

public final class LuceneSearchIndexer
extends AbstractLuceneIndexer
implements LuceneSearchIndexSchema,
ResourceChangeListener {
    private static final EIURI ORGANIZATION_URI = EIURI.create("http://purl.obolibrary.org/obo/OBI_0000245");
    private static final EIURI LABORATORY_URI = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001");
    private static final EIURI CENTER_URI = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000622");
    private static final EIURI TECH_TRANSFER_URI = EIURI.create("http://purl.obolibrary.org/obo/ERO_0000565");
    private static final Log logger = LogFactory.getLog(LuceneSearchIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private Set<EIURI> flattenTypeURIs = new HashSet<EIURI>();
    private Set<EIURI> resourceProviderTypeURIs = new HashSet<EIURI>();
    private Set<EIURI> skipPropTextIndexing = new HashSet<EIURI>();
    private Map<EIURI, Float> mapTypeToBoost = new HashMap<EIURI, Float>();
    private Set<EIURI> unresolvedInstanceRefs = new HashSet<EIURI>();
    private Set<EIURI> flattenInstancesWithNoRefs = new HashSet<EIURI>();
    private ClassUsageCache classUsageCache;
    private ProviderUsageCache providerUsageCache;

    public LuceneSearchIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory, ClassUsageCache classUsageCache, ProviderUsageCache providerUsageCache) {
        super("SearchIndexer", eiOntModel, analyzer, directory);
        this.classUsageCache = classUsageCache;
        this.providerUsageCache = providerUsageCache;
        this.initBoostMap();
        this.initFlattenCache();
        this.initResourceProviderCache();
        this.skipPropTextIndexing.add(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000480"));
    }

    private boolean searchExclude(EIURI typeURI) {
        if (typeURI == null) {
            return false;
        }
        if (typeURI.equals(ORGANIZATION_URI)) {
            return true;
        }
        if (this.eiOntModel.isSubClass(ORGANIZATION_URI, typeURI)) {
            return !this.resourceProviderTypeURIs.contains(typeURI);
        }
        return false;
    }

    private void initBoostMap() {
        this.mapTypeToBoost.put(ORGANIZATION_URI, Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create("http://vivoweb.org/ontology/core#PrivateCompany"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create("http://purl.obolibrary.org/obo/IAO_0000310"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create("http://purl.obolibrary.org/obo/IAO_0000311"), Float.valueOf(0.1f));
        this.mapTypeToBoost.put(EIURI.create("http://xmlns.com/foaf/0.1/Person"), Float.valueOf(0.5f));
        this.mapTypeToBoost.put(EIURI.create("http://purl.obolibrary.org/obo/OBI_0000272"), Float.valueOf(0.8f));
    }

    private void initFlattenCache() {
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_embedded_class")) {
            this.addFlattenClass(c);
        }
        EIClass genAltClass = this.eiOntModel.getClass(EIURI.create("http://purl.org/obo/owl/SO#SO_0001059"));
        this.addFlattenClass(genAltClass);
    }

    private void addFlattenClass(EIClass c) {
        this.flattenTypeURIs.add(c.getEntity().getURI());
        if (c.hasSubClass()) {
            for (EIClass sub : this.eiOntModel.getSubClasses(c.getEntity().getURI())) {
                this.addFlattenClass(sub);
            }
        }
    }

    private boolean isFlattenClass(EIURI uri) {
        return this.flattenTypeURIs.contains(uri);
    }

    private void initResourceProviderCache() {
        for (EIClass c : this.eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_ResourceProvider")) {
            this.addResourceProviderClass(c);
        }
    }

    private void addResourceProviderClass(EIClass c) {
        this.resourceProviderTypeURIs.add(c.getEntity().getURI());
        if (c.hasSubClass()) {
            for (EIClass sub : this.eiOntModel.getSubClasses(c.getEntity().getURI())) {
                this.addResourceProviderClass(sub);
            }
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        super.onChangeEvent(event);
        if (event.isDelete()) {
            this.deleteResourceInstance(event);
        } else if (this.isFlattenClass(event.getType().getURI())) {
            this.indexFlattenClass(event);
        } else {
            this.indexResourceInstance(event);
        }
    }

    @Override
    public boolean onChangeStreamEnd(EIEntity institution, Date lastModifiedDate) {
        if (this.unresolvedInstanceRefs.size() > 0) {
            logger.warn("Unresolved instance references in search index:  num: " + this.unresolvedInstanceRefs.size());
        }
        if (this.flattenInstancesWithNoRefs.size() > 0) {
            logger.warn("Flatten instance URIs with no referring instance:  num: " + this.flattenInstancesWithNoRefs.size());
        }
        return super.onChangeStreamEnd(institution, lastModifiedDate);
    }

    private void deleteResourceInstance(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        EIEntity typeEntity = null;
        Field[] referencedByFields = null;
        List<Document> previousVersions = this.getDocuments(uri);
        String previousLabel = null;
        if (previousVersions != null && previousVersions.size() > 0) {
            Document previousVersion = previousVersions.get(0);
            previousLabel = previousVersion.get("entity_label");
            referencedByFields = previousVersion.getFields("referenced_by");
            if (referencedByFields != null) {
                for (Field f : referencedByFields) {
                    this.updateReferencingDocument(EIURI.create(f.stringValue()), uri.toString(), null, previousLabel);
                }
            }
            String typeLabel = previousVersion.get("asserted_type_label");
            String typeURIStr = previousVersion.get("asserted_type_uri");
            if (typeURIStr != null && typeLabel != null) {
                typeEntity = EIEntity.create(typeURIStr, typeLabel);
                this.classUsageCache.removeUsage(typeEntity, null, event);
            } else {
                logger.warn("Unexpected: LuceneSearchIndexer.deleteResourceInstance(): deleting previous version of resource, but it doesn't have type fields: " + event.getEntity());
            }
        }
        logger.debug(this.indexerLabel + ": Deleting " + uri.toString());
        this.deleteDocuments(uri);
    }

    private void indexFlattenClass(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        List<Document> referencingDocuments = this.getReferencingDocuments(uri);
        if (referencingDocuments == null || referencingDocuments.size() == 0) {
            logger.error("No referencing documents found for flatten instance event: " + event.getEntity());
            this.flattenInstancesWithNoRefs.add(uri);
            return;
        }
        this.updateReferencingDocument(uri, referencingDocuments, uri.toString(), event.getEntity().getLabel(), null);
        for (Document refDoc : referencingDocuments) {
            this.addProperties(uri, refDoc, event, true);
        }
        List<Document> docs = this.getDocuments(uri);
        if (docs == null) {
            logger.error("No document indexed for flatten doc: " + event.getEntity());
            return;
        }
        for (Document doc : docs) {
            doc.removeFields("referenced_by");
        }
        this.deleteDocuments(uri);
        this.unresolvedInstanceRefs.remove(uri);
    }

    private List<Document> indexResourceInstance(ResourceChangeEvent event) {
        EIURI uri = event.getEntity().getURI();
        EIURI typeURI = event.getType().getURI();
        if (this.searchExclude(typeURI)) {
            return Collections.emptyList();
        }
        Document doc = new Document();
        String previousLabel = null;
        Field[] referencedByFields = null;
        List<Document> previousVersions = this.getDocuments(uri);
        if (previousVersions != null && previousVersions.size() > 0) {
            previousLabel = previousVersions.get(0).get("entity_label");
            referencedByFields = previousVersions.get(0).getFields("referenced_by");
            if (referencedByFields != null) {
                for (Field f : referencedByFields) {
                    doc.add(f);
                }
            }
        }
        Field field = new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add(field);
        field = new Field("stub", Boolean.toString(false), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add(field);
        String label = event.getEntity().getLabel();
        field = new Field("entity_label", label, Field.Store.YES, Field.Index.NO);
        doc.add(field);
        field = new Field("label", label, Field.Store.YES, Field.Index.ANALYZED);
        doc.add(field);
        if (event.getInstitution() != null) {
            String institutionURI = event.getInstitution().getURI().toString();
            doc.add(new Field("institution_uri", institutionURI, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        field = new Field("asserted_type_uri", event.getType().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add(field);
        field = new Field("asserted_type_label", event.getType().getLabel(), Field.Store.YES, Field.Index.ANALYZED);
        doc.add(field);
        for (EIClass superclass : this.eiOntModel.getSuperClasses(event.getType().getURI())) {
            field = new Field("inferred_type_uri", superclass.getEntity().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add(field);
            field = new Field("inferred_type_label", superclass.getEntity().getLabel(), Field.Store.YES, Field.Index.ANALYZED);
            doc.add(field);
        }
        this.addProperties(uri, doc, event, false);
        ArrayList<Document> docs = new ArrayList<Document>(1);
        docs.add(doc);
        this.setDocuments(event.getEntity().getURI(), docs);
        this.unresolvedInstanceRefs.remove(uri);
        this.classUsageCache.addUsage(event.getType(), null, event);
        if (referencedByFields != null && !label.equals(previousLabel)) {
            for (Field f : referencedByFields) {
                this.updateReferencingDocument(EIURI.create(f.stringValue()), uri.toString(), label, previousLabel);
            }
        }
        return docs;
    }

    private void addProperties(EIURI uri, Document doc, ResourceChangeEvent event, boolean isFlattenClassEvent) {
        if (!isFlattenClassEvent && event.getProvider() != null) {
            this.setResourceProvider(uri, doc, event.getProvider());
        }
        for (EIDatatypeProperty eIDatatypeProperty : event.getDataTypeProperties()) {
            if (this.skipPropTextIndexing.contains(eIDatatypeProperty.getEntity().getURI())) continue;
            for (String valueLabel : event.getDataTypeProperty(eIDatatypeProperty)) {
                this.addDatatypePropertyTextField(doc, eIDatatypeProperty, valueLabel);
            }
        }
        for (EIObjectProperty eIObjectProperty : event.getObjectProperties()) {
            for (EIURI valueURI : event.getObjectProperty(eIObjectProperty)) {
                String valueLabel;
                Field entityLabelField;
                Field field;
                if (this.eiOntModel.isModelClassURI(valueURI.toString())) {
                    field = new Field("prop_uri", valueURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                    doc.add(field);
                    EIClass valueEIClass = this.eiOntModel.getClass(valueURI);
                    this.addObjectPropertyTextField(doc, eIObjectProperty, valueURI, valueEIClass.getEntity().getLabel());
                    for (EIClass superclass : this.eiOntModel.getSuperClasses(valueURI)) {
                        field = new Field("prop_uri", superclass.getEntity().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                        doc.add(field);
                        this.addObjectPropertyTextField(doc, eIObjectProperty, superclass.getEntity().getURI(), superclass.getEntity().getLabel());
                    }
                    continue;
                }
                field = new Field("prop_uri", valueURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add(field);
                List<Document> valueDocuments = this.getDocuments(valueURI);
                if (valueDocuments != null && valueDocuments.size() > 0 && (entityLabelField = valueDocuments.get(0).getField("entity_label")) != null && (valueLabel = entityLabelField.stringValue()) != null) {
                    this.addObjectPropertyTextField(doc, eIObjectProperty, valueURI, valueLabel);
                }
                this.setReferencingDocument(event.getEntity().getURI(), valueURI);
            }
        }
    }

    private void addDatatypePropertyTextField(Document doc, EIDatatypeProperty prop, String valueLabel) {
        String propFieldName = LuceneSearchUtil.getPropertyFieldName(prop.getEntity(), null);
        this.addPropertyTextField(doc, propFieldName, valueLabel);
    }

    private void addObjectPropertyTextField(Document doc, EIObjectProperty prop, EIURI valueURI, String valueLabel) {
        String propFieldName = LuceneSearchUtil.getPropertyFieldName(prop.getEntity(), valueURI.toString());
        this.addPropertyTextField(doc, propFieldName, valueLabel);
    }

    private void addPropertyTextField(Document doc, String propFieldName, String valueLabel) {
        Field field = new Field(propFieldName, valueLabel, Field.Store.YES, Field.Index.ANALYZED);
        doc.add(field);
        this.addPropertyTextField(doc, valueLabel);
    }

    private void addPropertyTextField(Document doc, String valueLabel) {
        Field field = new Field("prop_text", valueLabel, Field.Store.YES, Field.Index.ANALYZED);
        doc.add(field);
    }

    private void updateReferencingDocument(EIURI referencingURI, String valueURIStr, String valueLabel, String previousValueLabel) {
        List<Document> docs = this.getDocuments(referencingURI);
        if (docs == null || docs.size() == 0) {
            logger.error("No Document found for " + referencingURI + " which is expected to reference: " + valueLabel + " : " + valueURIStr);
            return;
        }
        this.updateReferencingDocument(referencingURI, docs, valueURIStr, valueLabel, previousValueLabel);
    }

    private void updateReferencingDocument(EIURI referencingURI, List<Document> referencingDocuments, String valueURIStr, String valueLabel, String previousValueLabel) {
        for (Document doc : referencingDocuments) {
            String providerURIStr = doc.get("provider_uri");
            if (providerURIStr != null && providerURIStr.equals(valueURIStr)) {
                doc.removeFields("provider_uri");
                if (valueLabel != null) {
                    this.setResourceProvider(referencingURI, doc, EIURI.create(providerURIStr));
                } else {
                    this.removeResourceProvider(referencingURI, doc, EIURI.create(providerURIStr));
                }
            }
            doc.removeFields("prop_text");
            HashMap<String, String> mapPropFieldNameToValue = new HashMap<String, String>();
            for (Fieldable fieldable : doc.getFields()) {
                String fieldName = fieldable.name();
                if (!fieldable.isTokenized()) continue;
                String someValueURIStr = LuceneSearchUtil.getPropertyValueURIString(fieldName);
                if (valueURIStr.equals(someValueURIStr)) {
                    if (valueLabel == null) continue;
                    mapPropFieldNameToValue.put(fieldName, valueLabel);
                    continue;
                }
                if (!fieldName.startsWith(LuceneSearchUtil.DATATYPE_PROP_FIELD_PREFIX) && !fieldName.startsWith(LuceneSearchUtil.OBJECT_PROP_FIELD_PREFIX)) continue;
                mapPropFieldNameToValue.put(fieldName, fieldable.stringValue());
            }
            for (Map.Entry entry : mapPropFieldNameToValue.entrySet()) {
                doc.removeFields((String)entry.getKey());
                this.addPropertyTextField(doc, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void setReferencingDocument(EIURI referencedBy, EIURI referenced) {
        List<Document> referencedDocuments = this.getDocuments(referenced);
        if (referencedDocuments == null || referencedDocuments.size() == 0) {
            Document stubDoc = this.createStubInstance(referenced);
            this.setReferencingDocument(referencedBy, stubDoc);
        } else {
            for (Document referencedDoc : referencedDocuments) {
                this.setReferencingDocument(referencedBy, referencedDoc);
            }
        }
    }

    private void setReferencingDocument(EIURI referencedBy, Document referenced) {
        Field field = new Field("referenced_by", referencedBy.toString(), Field.Store.YES, Field.Index.NO);
        referenced.add(field);
    }

    private List<Document> getReferencingDocuments(EIURI uri) {
        ArrayList<Document> result = new ArrayList<Document>();
        List<Document> docs = this.getDocuments(uri);
        if (docs != null && docs.size() > 0) {
            for (String refDocURI : docs.get(0).getValues("referenced_by")) {
                List<Document> refDocs = this.getDocuments(EIURI.create(refDocURI));
                if (refDocs == null) continue;
                result.addAll(refDocs);
            }
        }
        return result;
    }

    private Document createStubInstance(EIURI uri) {
        Document doc = new Document();
        Field field = new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add(field);
        field = new Field("stub", Boolean.toString(true), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add(field);
        ArrayList<Document> docs = new ArrayList<Document>(1);
        docs.add(doc);
        this.setDocuments(uri, docs);
        this.unresolvedInstanceRefs.add(uri);
        return doc;
    }

    private void setResourceProvider(EIURI uri, Document doc, EIURI providerURI) {
        List<Document> providerDocuments = this.getDocuments(providerURI);
        if (providerDocuments != null && providerDocuments.size() > 0) {
            Field field = new Field("provider_uri", providerURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
            doc.add(field);
            Document providerDoc = providerDocuments.get(0);
            String providerLabel = providerDoc.get("entity_label");
            if (providerLabel != null) {
                this.setReferencingDocument(uri, providerDoc);
                field = new Field("provider_label", providerLabel, Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add(field);
                String providerAssertedTypeURI = providerDoc.get("asserted_type_uri");
                if (providerAssertedTypeURI.equals(ORGANIZATION_URI.toString())) {
                    return;
                }
                field = new Field("provider_type_uri", providerAssertedTypeURI, Field.Store.YES, Field.Index.NOT_ANALYZED);
                doc.add(field);
                this.providerUsageCache.addUsage(providerAssertedTypeURI);
                for (Field f : providerDoc.getFields("inferred_type_uri")) {
                    String providerInferredTypeURI = f.stringValue();
                    if (providerInferredTypeURI.equals(ORGANIZATION_URI.toString())) continue;
                    field = new Field("provider_type_uri", providerInferredTypeURI, Field.Store.YES, Field.Index.NOT_ANALYZED);
                    doc.add(field);
                    this.providerUsageCache.addUsage(providerInferredTypeURI);
                }
            }
        }
    }

    private void removeResourceProvider(EIURI uri, Document doc, EIURI providerURI) {
        Document providerDoc;
        String providerLabel;
        List<Document> providerDocuments = this.getDocuments(providerURI);
        if (providerDocuments != null && providerDocuments.size() > 0 && (providerLabel = (providerDoc = providerDocuments.get(0)).get("entity_label")) != null) {
            String providerAssertedTypeURI = providerDoc.get("asserted_type_uri");
            this.providerUsageCache.removeUsage(providerAssertedTypeURI);
            for (Field f : providerDoc.getFields("inferred_type_uri")) {
                String providerInferredTypeURI = f.stringValue();
                if (providerInferredTypeURI.equals(ORGANIZATION_URI.toString())) continue;
                this.providerUsageCache.removeUsage(providerInferredTypeURI);
            }
        }
    }
}

