/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.tbox.TBox;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Bool;
import org.mindswap.pellet.utils.Comparators;
import org.mindswap.pellet.utils.MemUtils;
import org.mindswap.pellet.utils.Pair;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOptimizedTaxonomyBuilder
implements TaxonomyBuilder {
    protected static Logger log = Logger.getLogger(Taxonomy.class.getName());
    protected ProgressMonitor monitor = PelletOptions.USE_CLASSIFICATION_MONITOR.create();
    private static final byte PROPOGATE_UP = 1;
    private static final byte NO_PROPOGATE = 0;
    private static final byte PROPOGATE_DOWN = -1;
    protected Collection<ATermAppl> classes;
    private Map<ATermAppl, Set<ATermAppl>> toldDisjoints;
    private Map<ATermAppl, ATermList> unionClasses;
    private Set<ATermAppl> cyclicConcepts;
    protected Taxonomy<ATermAppl> toldTaxonomy;
    protected Taxonomy<ATermAppl> taxonomy;
    protected KnowledgeBase kb;
    private int count;
    private boolean useCD;
    private List<TaxonomyNode<ATermAppl>> markedNodes;
    private Map<ATermAppl, ConceptFlag> conceptFlags;
    private boolean prepared = false;

    @Override
    public void setKB(KnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    public void setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor == null ? new SilentProgressMonitor() : monitor;
    }

    @Override
    public Taxonomy<ATermAppl> getTaxonomy() {
        return this.taxonomy;
    }

    @Override
    public Taxonomy<ATermAppl> getToldTaxonomy() {
        if (!this.prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this.toldTaxonomy;
    }

    @Override
    public Map<ATermAppl, Set<ATermAppl>> getToldDisjoints() {
        if (!this.prepared) {
            this.reset();
            this.computeToldInformation();
        }
        return this.toldDisjoints;
    }

    @Override
    public boolean classify() {
        this.classes = this.kb.getClasses();
        int classCount = this.classes.size();
        if (!this.classes.contains(ATermUtils.TOP)) {
            ++classCount;
        }
        if (!this.classes.contains(ATermUtils.BOTTOM)) {
            ++classCount;
        }
        this.monitor.setProgressTitle("Classifying");
        this.monitor.setProgressLength(classCount);
        this.monitor.taskStarted();
        if (this.kb.getClasses().isEmpty()) {
            this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            this.kb.timers.createTimer("classifySub");
            log.fine("Classes: " + classCount + " Individuals: " + this.kb.getIndividuals().size());
        }
        if (!this.prepared) {
            this.prepare();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Starting classification...");
        }
        Collection[] phase = new Collection[2];
        if (this.useCD) {
            phase[0] = new ArrayList();
            phase[1] = new ArrayList();
            block3: for (ATermAppl c : this.classes) {
                switch (this.conceptFlags.get(c)) {
                    case COMPLETELY_DEFINED: 
                    case PRIMITIVE: 
                    case OTHER: {
                        phase[0].add(c);
                        continue block3;
                    }
                }
                phase[1].add(c);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Using CD classification with phaseOne: " + phase[0].size() + " phaseTwo: " + phase[1].size());
            }
        } else {
            phase[0] = Collections.emptyList();
            phase[1] = this.classes;
            if (log.isLoggable(Level.FINE)) {
                log.fine("CD classification disabled");
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Phase 1");
            int i = 0;
            for (ATermAppl c : phase[0]) {
                log.finer(i + ") " + c);
                ++i;
            }
            log.finer("Phase 2");
            i = 0;
            for (ATermAppl c : phase[1]) {
                log.finer(i + ") " + c);
                ++i;
            }
        }
        for (int p = 0; p < 2; ++p) {
            boolean requireTopSearch = p != 0;
            for (ATermAppl c : phase[p]) {
                this.classify(c, requireTopSearch);
                this.monitor.incrementProgress();
                this.kb.timers.getTimer("classify").check();
                if (!this.monitor.isCanceled()) continue;
                this.classes = this.kb.getClasses();
                return false;
            }
            phase[p] = null;
        }
        this.monitor.taskFinished();
        if (log.isLoggable(Level.FINE)) {
            log.fine("SubClass Count: " + this.kb.timers.getTimer("classifySub").getCount());
            log.fine("Satisfiability Count: " + (this.kb.getABox().satisfiabilityCount - (long)(2 * this.kb.getClasses().size())));
        }
        this.classes = this.kb.getClasses();
        this.taxonomy.assertValid();
        return true;
    }

    private void prepare() {
        this.reset();
        this.computeToldInformation();
        this.createDefinitionOrder();
        this.computeConceptFlags();
        this.prepared = true;
    }

    protected void reset() {
        this.count = 0;
        this.kb.prepare();
        Expressivity expr = this.kb.getExpressivity();
        TBox tbox = this.kb.getTBox();
        this.useCD = PelletOptions.USE_CD_CLASSIFICATION && tbox.getUC().isEmpty() && tbox.unfold(ATermUtils.TOP) == null && !expr.hasInverse() && !expr.hasNominal() && !expr.hasComplexSubRoles();
        this.classes = new ArrayList<ATermAppl>(this.kb.getClasses());
        this.toldDisjoints = CollectionUtils.makeIdentityMap();
        this.unionClasses = CollectionUtils.makeIdentityMap();
        this.markedNodes = CollectionUtils.makeList(this.classes.size());
        this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        this.toldTaxonomy = new Taxonomy();
        this.cyclicConcepts = CollectionUtils.makeIdentitySet();
        this.conceptFlags = CollectionUtils.makeIdentityMap();
    }

    private void computeToldInformation() {
        this.toldTaxonomy = new Taxonomy<ATermAppl>(this.classes, ATermUtils.TOP, ATermUtils.BOTTOM);
        TBox tbox = this.kb.getTBox();
        Collection<ATermAppl> axioms = tbox.getAxioms();
        for (ATermAppl axiom : axioms) {
            boolean reverseArgs;
            ATermAppl c1 = (ATermAppl)axiom.getArgument(0);
            ATermAppl c2 = (ATermAppl)axiom.getArgument(1);
            boolean equivalent = axiom.getAFun().equals(ATermUtils.EQCLASSFUN);
            Set<ATermAppl> explanation = tbox.getAxiomExplanation(axiom);
            boolean bl = reverseArgs = !ATermUtils.isPrimitive(c1) && ATermUtils.isPrimitive(c2);
            if (equivalent && reverseArgs) {
                this.addToldRelation(c2, c1, equivalent, explanation);
                continue;
            }
            this.addToldRelation(c1, c2, equivalent, explanation);
        }
        for (ATermAppl c : this.unionClasses.keySet()) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
            ATermList disj = this.unionClasses.get(c);
            while (!disj.isEmpty()) {
                list.add((ATermAppl)disj.getFirst());
                disj = disj.getNext();
            }
            List<ATermAppl> lca = this.toldTaxonomy.computeLCA(list);
            for (ATermAppl d : lca) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Union subsumption " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldSubsumer(c, d);
            }
        }
        this.unionClasses = null;
        this.toldTaxonomy.assertValid();
    }

    private void createDefinitionOrder() {
        Timer t = this.kb.timers.startTimer("createDefinitionOrder");
        Taxonomy<ATermAppl> definitionOrderTaxonomy = new Taxonomy<ATermAppl>(this.classes, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ATermAppl aTermAppl : this.classes) {
            List<Pair<ATermAppl, Set<ATermAppl>>> desc = this.kb.getTBox().unfold(aTermAppl);
            if (desc == null) continue;
            for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                Set<ATermAppl> usedByC = ATermUtils.findPrimitives((ATermAppl)pair.first, true, true);
                for (ATermAppl d : usedByC) {
                    if (aTermAppl.equals(d) || definitionOrderTaxonomy.isEquivalent(aTermAppl, d) == Bool.TRUE) continue;
                    TaxonomyNode<ATermAppl> cNode = definitionOrderTaxonomy.getNode(aTermAppl);
                    TaxonomyNode<ATermAppl> dNode = definitionOrderTaxonomy.getNode(d);
                    if (cNode == null) {
                        throw new InternalReasonerException(aTermAppl + " is not in the definition order");
                    }
                    if (cNode.equals(definitionOrderTaxonomy.getTop())) {
                        definitionOrderTaxonomy.merge(cNode, dNode);
                        continue;
                    }
                    definitionOrderTaxonomy.addSuper(aTermAppl, d);
                    definitionOrderTaxonomy.removeCycles(cNode);
                }
            }
        }
        definitionOrderTaxonomy.assertValid();
        this.classes = definitionOrderTaxonomy.topologocialSort(true, Comparators.termComparator);
        this.cyclicConcepts = new HashSet<ATermAppl>();
        for (TaxonomyNode taxonomyNode : definitionOrderTaxonomy.getNodes()) {
            Set names = taxonomyNode.getEquivalents();
            if (names.size() <= 1) continue;
            this.cyclicConcepts.addAll(names);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Cyclic concepts (" + this.cyclicConcepts.size() + "): " + this.cyclicConcepts);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Sorted: " + this.classes);
        }
        t.stop();
    }

    private void computeConceptFlags() {
        if (!this.useCD) {
            return;
        }
        for (Role r : this.kb.getRBox().getRoles()) {
            for (ATermAppl c : r.getDomains()) {
                ATermAppl d;
                ATermList list;
                if (ATermUtils.isPrimitive(c)) {
                    this.conceptFlags.put(c, ConceptFlag.OTHER);
                    continue;
                }
                if (ATermUtils.isAnd(c)) {
                    list = (ATermList)c.getArgument(0);
                    while (!list.isEmpty()) {
                        d = (ATermAppl)list.getFirst();
                        if (ATermUtils.isPrimitive(d)) {
                            this.conceptFlags.put(d, ConceptFlag.OTHER);
                        }
                        list = list.getNext();
                    }
                    continue;
                }
                if (!ATermUtils.isNot(c) || !ATermUtils.isAnd((ATermAppl)c.getArgument(0))) continue;
                list = (ATermList)((ATermAppl)c.getArgument(0)).getArgument(0);
                while (!list.isEmpty()) {
                    d = (ATermAppl)list.getFirst();
                    if (ATermUtils.isNegatedPrimitive(d)) {
                        this.conceptFlags.put((ATermAppl)d.getArgument(0), ConceptFlag.OTHER);
                    }
                    list = list.getNext();
                }
            }
        }
        TBox tbox = this.kb.getTBox();
        for (ATermAppl c : this.classes) {
            List<Pair<ATermAppl, Set<ATermAppl>>> desc = this.kb.getTBox().unfold(c);
            if (tbox.unfold(ATermUtils.makeNot(c)) != null || this.cyclicConcepts.contains(c) || this.toldTaxonomy.getAllEquivalents(c).size() > 1) {
                this.conceptFlags.put(c, ConceptFlag.NONPRIMITIVE);
                if (desc == null) continue;
                for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                    for (ATermAppl d : ATermUtils.findPrimitives((ATermAppl)pair.first)) {
                        ConceptFlag current = this.conceptFlags.get(d);
                        if (current != null && current != ConceptFlag.COMPLETELY_DEFINED) continue;
                        this.conceptFlags.put(d, ConceptFlag.PRIMITIVE);
                    }
                }
                continue;
            }
            boolean flagged = false;
            for (ATermAppl sup : this.toldTaxonomy.getFlattenedSupers(c, true)) {
                ConceptFlag supFlag = this.conceptFlags.get(sup);
                if (supFlag != ConceptFlag.NONPRIMITIVE && supFlag != ConceptFlag.NONPRIMITIVE_TA) continue;
                this.conceptFlags.put(c, ConceptFlag.NONPRIMITIVE_TA);
                flagged = true;
                break;
            }
            if (flagged || this.conceptFlags.get(c) != null) continue;
            this.conceptFlags.put(c, this.isCDDesc(desc) ? ConceptFlag.COMPLETELY_DEFINED : ConceptFlag.PRIMITIVE);
        }
        if (log.isLoggable(Level.FINE)) {
            int cd = 0;
            int p = 0;
            int np = 0;
            int npta = 0;
            int other = 0;
            block15: for (ATermAppl c : this.classes) {
                switch (this.conceptFlags.get(c)) {
                    case COMPLETELY_DEFINED: {
                        ++cd;
                        continue block15;
                    }
                    case PRIMITIVE: {
                        ++p;
                        continue block15;
                    }
                    case NONPRIMITIVE: {
                        ++np;
                        continue block15;
                    }
                    case NONPRIMITIVE_TA: {
                        ++npta;
                        continue block15;
                    }
                    case OTHER: {
                        ++other;
                        continue block15;
                    }
                }
                log.warning(c.getName() + " has no classification flag");
            }
            log.fine("CD,P,NP,NPTA,O: " + cd + "," + p + "," + np + "," + npta + "," + other);
        }
    }

    private void clearMarks() {
        for (TaxonomyNode<ATermAppl> n : this.markedNodes) {
            n.mark = null;
        }
        this.markedNodes.clear();
    }

    private boolean isCDDesc(List<Pair<ATermAppl, Set<ATermAppl>>> desc) {
        if (desc != null) {
            for (Pair<ATermAppl, Set<ATermAppl>> pair : desc) {
                if (this.isCDDesc((ATermAppl)pair.first)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isCDDesc(ATermAppl desc) {
        ATermAppl negd;
        if (desc == null) {
            return true;
        }
        if (ATermUtils.isPrimitive(desc)) {
            return true;
        }
        if (ATermUtils.isAllValues(desc)) {
            return true;
        }
        if (ATermUtils.isAnd(desc)) {
            ATermList conj;
            boolean allCDConj = true;
            ATermList subConj = conj = (ATermList)desc.getArgument(0);
            while (allCDConj && !subConj.isEmpty()) {
                ATermAppl ci = (ATermAppl)subConj.getFirst();
                allCDConj = this.isCDDesc(ci);
                subConj = subConj.getNext();
            }
            return allCDConj;
        }
        return ATermUtils.isNot(desc) && ATermUtils.isPrimitive(negd = (ATermAppl)desc.getArgument(0));
    }

    private void addToldRelation(ATermAppl c, ATermAppl d, boolean equivalent, Set<ATermAppl> explanation) {
        ATermAppl negation;
        if (!(equivalent || c != ATermUtils.BOTTOM && d != ATermUtils.TOP)) {
            return;
        }
        if (!ATermUtils.isPrimitive(c)) {
            if (c.getAFun().equals(ATermUtils.ORFUN)) {
                ATermList list;
                ATermList disj = list = (ATermList)c.getArgument(0);
                while (!disj.isEmpty()) {
                    ATermAppl e2 = (ATermAppl)disj.getFirst();
                    this.addToldRelation(e2, d, false, explanation);
                    disj = disj.getNext();
                }
            }
        } else if (ATermUtils.isPrimitive(d)) {
            if (ATermUtils.isBnode(d)) {
                return;
            }
            if (!equivalent) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Preclassify (1) " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldSubsumer(c, d, explanation);
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Preclassify (2) " + this.getName(c) + " " + this.getName(d));
                }
                this.addToldEquivalent(c, d);
            }
        } else if (d.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)d.getArgument(0);
            while (!conj.isEmpty()) {
                ATermAppl e3 = (ATermAppl)conj.getFirst();
                this.addToldRelation(c, e3, false, explanation);
                conj = conj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.ORFUN)) {
            ATermList list;
            boolean allPrimitive = true;
            ATermList disj = list = (ATermList)d.getArgument(0);
            while (!disj.isEmpty()) {
                ATermAppl e4 = (ATermAppl)disj.getFirst();
                if (ATermUtils.isPrimitive(e4)) {
                    if (equivalent) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Preclassify (3) " + this.getName(c) + " " + this.getName(e4));
                        }
                        this.addToldSubsumer(e4, c);
                    }
                } else {
                    allPrimitive = false;
                }
                disj = disj.getNext();
            }
            if (allPrimitive) {
                this.unionClasses.put(c, list);
            }
        } else if (d.equals(ATermUtils.BOTTOM)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Preclassify (4) " + this.getName(c) + " BOTTOM");
            }
            this.addToldEquivalent(c, ATermUtils.BOTTOM);
        } else if (d.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)d.getArgument(0))) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Preclassify (5) " + this.getName(c) + " not " + this.getName(negation));
            }
            this.addToldDisjoint(c, negation);
            this.addToldDisjoint(negation, c);
        }
    }

    private void addToldEquivalent(ATermAppl c, ATermAppl d) {
        if (c.equals(d)) {
            return;
        }
        TaxonomyNode<ATermAppl> cNode = this.toldTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this.toldTaxonomy.getNode(d);
        this.toldTaxonomy.merge(cNode, dNode);
        TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, c);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d) {
        this.addToldSubsumer(c, d, null);
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d, Set<ATermAppl> explanation) {
        TaxonomyNode<ATermAppl> cNode = this.toldTaxonomy.getNode(c);
        TaxonomyNode<ATermAppl> dNode = this.toldTaxonomy.getNode(d);
        if (cNode == null) {
            throw new InternalReasonerException(c + " is not in the definition order");
        }
        if (dNode == null) {
            throw new InternalReasonerException(d + " is not in the definition order");
        }
        if (cNode.equals(dNode)) {
            return;
        }
        if (cNode.equals(this.toldTaxonomy.getTop())) {
            this.toldTaxonomy.merge(cNode, dNode);
            TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, c);
        } else {
            this.toldTaxonomy.addSuper(c, d);
            this.toldTaxonomy.removeCycles(cNode);
            if (cNode.getEquivalents().size() > 1) {
                TaxonomyUtils.clearSuperExplanation(this.toldTaxonomy, c);
            } else if (explanation != null && !explanation.isEmpty()) {
                TaxonomyUtils.addSuperExplanation(this.toldTaxonomy, c, d, explanation);
            }
        }
    }

    private void addToldDisjoint(ATermAppl c, ATermAppl d) {
        Set<ATermAppl> disjoints = this.toldDisjoints.get(c);
        if (disjoints == null) {
            disjoints = new HashSet<ATermAppl>();
            this.toldDisjoints.put(c, disjoints);
        }
        disjoints.add(d);
    }

    private void markToldSubsumers(ATermAppl c) {
        TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
        if (node != null) {
            boolean newMark = this.mark(node, Boolean.TRUE, (byte)1);
            if (!newMark) {
                return;
            }
        } else if (log.isLoggable(Level.FINE) && this.markedNodes.size() > 2) {
            log.warning("Told subsumer " + c + " is not classified yet");
        }
        if (this.toldTaxonomy.contains(c)) {
            for (ATermAppl sup : this.toldTaxonomy.getFlattenedSupers(c, true)) {
                this.markToldSubsumers(sup);
            }
        }
    }

    private void markToldSubsumeds(ATermAppl c, Boolean b) {
        boolean newMark;
        TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
        if (node != null && !(newMark = this.mark(node, b, (byte)-1))) {
            return;
        }
        if (this.toldTaxonomy.contains(c)) {
            for (ATermAppl sub : this.toldTaxonomy.getFlattenedSubs(c, true)) {
                this.markToldSubsumeds(sub, b);
            }
        }
    }

    private void markToldDisjoints(Collection<ATermAppl> inputc, boolean topSearch) {
        HashSet<ATermAppl> cset = new HashSet<ATermAppl>();
        cset.addAll(inputc);
        for (ATermAppl c : inputc) {
            if (this.taxonomy.contains(c)) {
                cset.addAll(this.taxonomy.getFlattenedSupers(c, false));
            }
            if (!this.toldTaxonomy.contains(c)) continue;
            cset.addAll(this.toldTaxonomy.getFlattenedSupers(c, false));
        }
        HashSet<ATermAppl> disjoints = new HashSet<ATermAppl>();
        for (ATermAppl a : cset) {
            Set<ATermAppl> disj = this.toldDisjoints.get(a);
            if (disj == null) continue;
            disjoints.addAll(disj);
        }
        if (topSearch) {
            for (ATermAppl d : disjoints) {
                TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(d);
                if (node == null) continue;
                this.mark(node, Boolean.FALSE, (byte)0);
            }
        } else {
            for (ATermAppl d : disjoints) {
                this.markToldSubsumeds(d, Boolean.FALSE);
            }
        }
    }

    private TaxonomyNode<ATermAppl> checkSatisfiability(ATermAppl c) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Satisfiable ");
        }
        Timer t = this.kb.timers.startTimer("classifySat");
        boolean isSatisfiable = this.kb.getABox().isSatisfiable(c, true);
        t.stop();
        if (log.isLoggable(Level.FINER)) {
            log.finer((isSatisfiable ? "true" : "*****FALSE*****") + " (" + t.getLast() + "ms)");
        }
        if (!isSatisfiable) {
            this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
        }
        if (PelletOptions.USE_CACHING) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("...negation ");
            }
            t.start();
            ATermAppl notC = ATermUtils.makeNot(c);
            isSatisfiable = this.kb.getABox().isSatisfiable(notC, true);
            t.stop();
            if (!isSatisfiable) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getTop());
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(isSatisfiable + " (" + t.getLast() + "ms)");
            }
        }
        return this.taxonomy.getNode(c);
    }

    @Override
    public void classify(ATermAppl c) {
        this.classify(c, true);
    }

    private TaxonomyNode<ATermAppl> classify(ATermAppl c, boolean requireTopSearch) {
        List<ATermAppl> subs;
        boolean skipBottomSearch;
        List<TaxonomyNode<ATermAppl>> superNodes;
        boolean skipTopSearch;
        TaxonomyNode<ATermAppl> node;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Classify (" + ++this.count + ") " + this.getName(c) + "...");
        }
        if ((node = this.taxonomy.getNode(c)) != null) {
            return node;
        }
        node = this.checkSatisfiability(c);
        if (node != null) {
            return node;
        }
        this.clearMarks();
        ConceptFlag flag = this.conceptFlags.get(c);
        if (flag == null) {
            flag = ConceptFlag.OTHER;
        }
        boolean bl = skipTopSearch = !requireTopSearch && this.useCD && flag == ConceptFlag.COMPLETELY_DEFINED;
        if (skipTopSearch) {
            superNodes = this.getCDSupers(c);
            skipBottomSearch = true;
        } else {
            superNodes = this.doTopSearch(c);
            skipBottomSearch = this.useCD && (flag == ConceptFlag.PRIMITIVE || flag == ConceptFlag.COMPLETELY_DEFINED);
        }
        ArrayList<ATermAppl> supers = new ArrayList<ATermAppl>();
        for (TaxonomyNode<ATermAppl> n : superNodes) {
            supers.add(n.getName());
        }
        if (skipBottomSearch) {
            subs = Collections.singletonList(ATermUtils.BOTTOM);
        } else {
            TaxonomyNode<ATermAppl> supNode;
            ATermAppl sup;
            if (superNodes.size() == 1 && this.subsumes(c, sup = (supNode = superNodes.iterator().next()).getName())) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this.getName(c) + " = " + this.getName(sup));
                }
                this.taxonomy.addEquivalentNode(c, supNode);
                return supNode;
            }
            List<TaxonomyNode<ATermAppl>> subNodes = this.doBottomSearch(c, superNodes);
            subs = new ArrayList<ATermAppl>();
            for (TaxonomyNode<ATermAppl> n : subNodes) {
                subs.add(n.getName());
            }
        }
        node = this.taxonomy.addNode(Collections.singleton(c), supers, subs, !ATermUtils.isPrimitive(c));
        TaxonomyNode<ATermAppl> toldNode = this.toldTaxonomy.getNode(c);
        if (toldNode != null) {
            TaxonomyNode<ATermAppl> defOrder = this.toldTaxonomy.getNode(c);
            for (ATermAppl aTermAppl : defOrder.getEquivalents()) {
                this.taxonomy.addEquivalentNode(aTermAppl, node);
            }
            for (TaxonomyNode taxonomyNode : superNodes) {
                Set<Set<ATermAppl>> exps = TaxonomyUtils.getSuperExplanations(this.toldTaxonomy, c, (ATermAppl)taxonomyNode.getName());
                if (exps == null) continue;
                for (Set<ATermAppl> exp : exps) {
                    if (exp.isEmpty()) continue;
                    TaxonomyUtils.addSuperExplanation(this.taxonomy, c, (ATermAppl)taxonomyNode.getName(), exp);
                }
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
        }
        return node;
    }

    private List<TaxonomyNode<ATermAppl>> doBottomSearch(ATermAppl c, List<TaxonomyNode<ATermAppl>> supers) {
        HashSet<TaxonomyNode<ATermAppl>> searchFrom = new HashSet<TaxonomyNode<ATermAppl>>();
        for (TaxonomyNode<ATermAppl> sup : supers) {
            this.collectLeafs(sup, searchFrom);
        }
        if (searchFrom.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        this.clearMarks();
        this.mark(this.taxonomy.getTop(), Boolean.FALSE, (byte)0);
        this.taxonomy.getBottom().mark = Boolean.TRUE;
        this.markToldSubsumeds(c, Boolean.TRUE);
        for (TaxonomyNode<ATermAppl> sup : supers) {
            this.mark(sup, Boolean.FALSE, (byte)0);
        }
        log.finer("Bottom search...");
        ArrayList<TaxonomyNode<ATermAppl>> subs = new ArrayList<TaxonomyNode<ATermAppl>>();
        HashSet<TaxonomyNode<ATermAppl>> visited = new HashSet<TaxonomyNode<ATermAppl>>();
        for (TaxonomyNode taxonomyNode : searchFrom) {
            if (!this.subsumed(taxonomyNode, c)) continue;
            this.search(false, c, taxonomyNode, visited, subs);
        }
        if (subs.isEmpty()) {
            return Collections.singletonList(this.taxonomy.getBottom());
        }
        return subs;
    }

    private void collectLeafs(TaxonomyNode<ATermAppl> node, Collection<TaxonomyNode<ATermAppl>> leafs) {
        for (TaxonomyNode<ATermAppl> sub : node.getSubs()) {
            if (sub.isLeaf()) {
                leafs.add(sub);
                continue;
            }
            this.collectLeafs(sub, leafs);
        }
    }

    private List<TaxonomyNode<ATermAppl>> doTopSearch(ATermAppl c) {
        ArrayList<TaxonomyNode<ATermAppl>> supers = new ArrayList<TaxonomyNode<ATermAppl>>();
        this.mark(this.taxonomy.getTop(), Boolean.TRUE, (byte)0);
        this.taxonomy.getBottom().mark = Boolean.FALSE;
        this.markToldSubsumers(c);
        this.markToldDisjoints(Collections.singleton(c), true);
        log.finer("Top search...");
        this.search(true, c, this.taxonomy.getTop(), new HashSet<TaxonomyNode<ATermAppl>>(), supers);
        return supers;
    }

    private List<TaxonomyNode<ATermAppl>> getCDSupers(ATermAppl c) {
        ArrayList<TaxonomyNode<ATermAppl>> supers = new ArrayList<TaxonomyNode<ATermAppl>>();
        TaxonomyNode<ATermAppl> defOrder = this.toldTaxonomy.getNode(c);
        List<TaxonomyNode<ATermAppl>> cDefs = defOrder.getSupers();
        int nTS = cDefs.size();
        if (nTS == 1) {
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this.toldTaxonomy.getTop()) continue;
                TaxonomyNode<ATermAppl> parent = this.taxonomy.getNode(def.getName());
                if (parent == null) {
                    throw new RuntimeException("CD classification of " + this.getName(c) + " failed, told subsumer " + this.getName(def.getName()) + " not classified");
                }
                supers.add(parent);
                break;
            }
        } else {
            TaxonomyNode<ATermAppl> candidate;
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this.toldTaxonomy.getTop()) continue;
                candidate = this.taxonomy.getNode(def.getName());
                if (candidate == null) {
                    throw new RuntimeException("CD classification of " + this.getName(c) + " failed, told subsumer " + this.getName(def.getName()) + " not classified");
                }
                for (TaxonomyNode<ATermAppl> ancestor : candidate.getSupers()) {
                    this.mark(ancestor, Boolean.TRUE, (byte)1);
                }
            }
            for (TaxonomyNode<ATermAppl> def : cDefs) {
                if (def == this.toldTaxonomy.getTop()) continue;
                candidate = this.taxonomy.getNode(def.getName());
                if (candidate.mark != null) continue;
                supers.add(candidate);
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("...completely defined by " + candidate.getName().getName());
            }
        }
        if (supers.isEmpty()) {
            supers.add(this.taxonomy.getTop());
        }
        return supers;
    }

    private Collection<TaxonomyNode<ATermAppl>> search(boolean topSearch, ATermAppl c, TaxonomyNode<ATermAppl> x, Set<TaxonomyNode<ATermAppl>> visited, List<TaxonomyNode<ATermAppl>> result) {
        ArrayList<TaxonomyNode<ATermAppl>> posSucc = new ArrayList<TaxonomyNode<ATermAppl>>();
        visited.add(x);
        List<TaxonomyNode<ATermAppl>> list = topSearch ? x.getSubs() : x.getSupers();
        for (TaxonomyNode<ATermAppl> next : list) {
            if (topSearch) {
                if (!this.subsumes(next, c)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            for (TaxonomyNode<ATermAppl> y : posSucc) {
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result);
            }
        }
        return result;
    }

    private boolean subCheckWithCache(TaxonomyNode<ATermAppl> node, ATermAppl c, boolean topDown) {
        List<TaxonomyNode<ATermAppl>> others;
        Boolean cached = node.mark;
        if (cached != null) {
            return cached;
        }
        List<TaxonomyNode<ATermAppl>> list = others = topDown ? node.getSupers() : node.getSubs();
        if (others.size() > 1) {
            LinkedHashMap<TaxonomyNode, TaxonomyNode> visited = new LinkedHashMap<TaxonomyNode, TaxonomyNode>();
            visited.put(node, null);
            LinkedHashMap toBeVisited = new LinkedHashMap();
            for (TaxonomyNode<ATermAppl> n : others) {
                toBeVisited.put(n, node);
            }
            while (!toBeVisited.isEmpty()) {
                TaxonomyNode relative = (TaxonomyNode)toBeVisited.keySet().iterator().next();
                TaxonomyNode reachedFrom = (TaxonomyNode)toBeVisited.get(relative);
                Boolean ancestorMark = relative.mark;
                if (Boolean.FALSE.equals(ancestorMark)) {
                    TaxonomyNode n = reachedFrom;
                    while (n != null) {
                        this.mark(n, Boolean.FALSE, (byte)0);
                        n = (TaxonomyNode)visited.get(n);
                    }
                    return false;
                }
                if (ancestorMark == null) {
                    List moreRelatives = topDown ? relative.getSupers() : relative.getSubs();
                    for (TaxonomyNode n : moreRelatives) {
                        if (visited.keySet().contains(n) || toBeVisited.keySet().contains(n)) continue;
                        toBeVisited.put(n, relative);
                    }
                }
                toBeVisited.remove(relative);
                visited.put(relative, reachedFrom);
            }
        }
        boolean calcdMark = topDown ? this.subsumes(node.getName(), c) : this.subsumes(c, node.getName());
        this.mark(node, calcdMark, (byte)0);
        return calcdMark;
    }

    private boolean subsumes(TaxonomyNode<ATermAppl> node, ATermAppl c) {
        return this.subCheckWithCache(node, c, true);
    }

    private boolean subsumed(TaxonomyNode<ATermAppl> node, ATermAppl c) {
        return this.subCheckWithCache(node, c, false);
    }

    private boolean mark(TaxonomyNode<ATermAppl> node, Boolean value, byte propogate) {
        if (node.getEquivalents().contains(ATermUtils.BOTTOM)) {
            return true;
        }
        if (node.mark != null) {
            if (!node.mark.equals(value)) {
                throw new RuntimeException("Inconsistent classification result " + node.getName() + " " + node.mark + " " + value);
            }
            return false;
        }
        node.mark = value;
        this.markedNodes.add(node);
        if (propogate != 0) {
            List<TaxonomyNode<ATermAppl>> others = propogate == 1 ? node.getSupers() : node.getSubs();
            for (TaxonomyNode<ATermAppl> n : others) {
                this.mark(n, value, propogate);
            }
        }
        return true;
    }

    private boolean subsumes(ATermAppl sup, ATermAppl sub) {
        long time = 0L;
        long count = 0L;
        if (log.isLoggable(Level.FINER)) {
            time = System.currentTimeMillis();
            count = this.kb.getABox().satisfiabilityCount;
            log.finer("Subsumption testing for [" + this.getName(sub) + "," + this.getName(sup) + "]...");
        }
        Timer t = this.kb.timers.startTimer("classifySub");
        boolean result = this.kb.getABox().isSubClassOf(sub, sup);
        t.stop();
        if (log.isLoggable(Level.FINER)) {
            String sign = this.kb.getABox().satisfiabilityCount > count ? "+" : "-";
            time = System.currentTimeMillis() - time;
            log.finer(" done (" + (result ? "+" : "-") + ") (" + sign + time + "ms)");
        }
        return result;
    }

    private void mark(Set<ATermAppl> set, Map<ATermAppl, Boolean> marked, Boolean value) {
        for (ATermAppl c : set) {
            marked.put(c, value);
        }
    }

    @Override
    public boolean realize() {
        this.monitor.setProgressTitle("Realizing");
        return PelletOptions.REALIZE_INDIVIDUAL_AT_A_TIME ? this.realizeByIndividuals() : this.realizeByConcepts();
    }

    private boolean realizeByIndividuals() {
        this.monitor.setProgressLength(this.kb.getIndividuals().size());
        this.monitor.taskStarted();
        IndividualIterator i = this.kb.getABox().getIndIterator();
        int count = 0;
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            this.monitor.incrementProgress();
            this.kb.timers.getTimer("realize").check();
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer(count + ") Realizing " + this.getName(x.getName()) + " ");
            }
            HashMap<ATermAppl, Boolean> marked = new HashMap<ATermAppl, Boolean>();
            ArrayList<ATermAppl> obviousTypes = new ArrayList<ATermAppl>();
            ArrayList<ATermAppl> obviousNonTypes = new ArrayList<ATermAppl>();
            this.kb.getABox().getObviousTypes(x.getName(), obviousTypes, obviousNonTypes);
            for (ATermAppl c : obviousTypes) {
                if (!this.taxonomy.contains(c)) continue;
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.TRUE);
                this.mark(this.taxonomy.getFlattenedSupers(c, true), marked, Boolean.TRUE);
            }
            for (ATermAppl c : obviousNonTypes) {
                this.mark(this.taxonomy.getAllEquivalents(c), marked, Boolean.FALSE);
                this.mark(this.taxonomy.getFlattenedSubs(c, true), marked, Boolean.FALSE);
            }
            this.realizeByIndividual(x.getName(), ATermUtils.TOP, marked);
            ++count;
        }
        this.monitor.taskFinished();
        return true;
    }

    private boolean realizeByIndividual(ATermAppl n, ATermAppl c, Map<ATermAppl, Boolean> marked) {
        boolean isType;
        boolean realized = false;
        if (c.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        if (marked.containsKey(c)) {
            isType = marked.get(c);
        } else {
            long time = 0L;
            long count = 0L;
            if (log.isLoggable(Level.FINER)) {
                time = System.currentTimeMillis();
                count = this.kb.getABox().consistencyCount;
                log.finer("Type checking for [" + this.getName(n) + ", " + this.getName(c) + "]...");
            }
            Timer t = this.kb.timers.startTimer("classifyType");
            isType = this.kb.isType(n, c);
            t.stop();
            marked.put(c, isType ? Boolean.TRUE : Boolean.FALSE);
            if (log.isLoggable(Level.FINER)) {
                String sign = this.kb.getABox().consistencyCount > count ? "+" : "-";
                time = System.currentTimeMillis() - time;
                log.finer("done (" + (isType ? "+" : "-") + ") (" + sign + time + "ms)");
            }
        }
        if (isType) {
            TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
            for (TaxonomyNode<ATermAppl> sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                realized = this.realizeByIndividual(n, d, marked) || realized;
            }
            if (!realized) {
                HashSet<ATermAppl> instances = (HashSet<ATermAppl>)node.getDatum(TaxonomyUtils.INSTANCES_KEY);
                if (instances == null) {
                    instances = new HashSet<ATermAppl>();
                    node.putDatum(TaxonomyUtils.INSTANCES_KEY, instances);
                }
                instances.add(n);
                realized = true;
            }
        }
        return realized;
    }

    private boolean realizeByConcepts() {
        this.monitor.setProgressLength(this.classes.size() + 2);
        this.monitor.taskStarted();
        Set<ATermAppl> individuals = this.kb.getIndividuals();
        if (!individuals.isEmpty()) {
            this.realizeByConcept(ATermUtils.TOP, individuals);
        }
        this.kb.timers.getTimer("realize").check();
        if (this.monitor.isCanceled()) {
            return false;
        }
        this.monitor.taskFinished();
        return true;
    }

    private Set<ATermAppl> realizeByConcept(ATermAppl c, Collection<ATermAppl> individuals) {
        if (c.equals(ATermUtils.BOTTOM)) {
            return SetUtils.emptySet();
        }
        this.monitor.incrementProgress();
        this.kb.timers.getTimer("realize").check();
        if (this.monitor.isCanceled()) {
            return null;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Realizing concept " + c);
        }
        HashSet<ATermAppl> instances = new HashSet<ATermAppl>(this.kb.retrieve(c, individuals));
        HashSet<ATermAppl> mostSpecificInstances = new HashSet<ATermAppl>(instances);
        if (!instances.isEmpty()) {
            TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
            for (TaxonomyNode<ATermAppl> sub : node.getSubs()) {
                ATermAppl d = sub.getName();
                Set<ATermAppl> subInstances = this.realizeByConcept(d, instances);
                if (subInstances == null) {
                    return null;
                }
                mostSpecificInstances.removeAll(subInstances);
            }
            if (!mostSpecificInstances.isEmpty()) {
                node.putDatum(TaxonomyUtils.INSTANCES_KEY, mostSpecificInstances);
            }
        }
        return instances;
    }

    public void printStats() {
        Timer t1 = this.kb.timers.getTimer("satisfiability");
        Timer t2 = this.kb.timers.getTimer("subClassSat");
        StringBuilder sb = new StringBuilder(this.kb.getABox().getCache().toString());
        sb.append("sat: ");
        if (t1 != null) {
            sb.append(t1.getCount()).append(" ").append(t1.getTotal());
        } else {
            sb.append("0");
        }
        sb.append(" sub: ");
        if (t2 != null) {
            sb.append(t2.getCount()).append(" ").append(t2.getTotal());
        } else {
            sb.append("0");
        }
        int totalExps = 0;
        int totalAxioms = 0;
        Iterator<Object> i = this.taxonomy.depthFirstDatumOnly(ATermUtils.TOP, TaxonomyUtils.SUPER_EXPLANATION_KEY);
        while (i.hasNext()) {
            Map allExps = (Map)i.next();
            if (allExps == null) continue;
            ++totalExps;
            for (Set exps : allExps.values()) {
                for (Set exp : exps) {
                    totalAxioms += exp.size();
                }
            }
        }
        System.out.println(sb);
    }

    public void printMemory() {
        try {
            MemUtils.printMemory("Total: ", MemUtils.totalMemory());
            MemUtils.printMemory("Free : ", MemUtils.freeMemory());
            MemUtils.printMemory("Used*: ", MemUtils.totalMemory() - MemUtils.freeMemory());
            MemUtils.runGC();
            MemUtils.printMemory("Used : ", MemUtils.usedMemory());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private String getName(ATermAppl c) {
        if (c.equals(ATermUtils.TOP)) {
            return "owl:Thing";
        }
        if (c.equals(ATermUtils.BOTTOM)) {
            return "owl:Nothing";
        }
        if (ATermUtils.isPrimitive(c)) {
            return URIUtils.getLocalName(c.getName());
        }
        return c.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConceptFlag {
        COMPLETELY_DEFINED,
        PRIMITIVE,
        NONPRIMITIVE,
        NONPRIMITIVE_TA,
        OTHER;

    }
}

