package org.eaglei.network.actions;

import static org.eaglei.network.actions.SearchProviderOperations.invokesCount;
import static org.eaglei.search.common.Serializer.SearchCountRequestSerializer;
import static org.eaglei.search.common.Serializer.SearchCountsSerializer;

import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;

/**
 * 
 * @author Clint Gilbert
 * 
 * Jul 7, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public final class CountQueryAction extends SearchProviderQueryAction<SearchCountRequest, SearchCounts>
{
    public CountQueryAction(final SearchProvider provider)
    {
        super(SearchCountRequestSerializer, SearchCountsSerializer, invokesCount(provider));
    }
}
