package org.eaglei.network.actions;

import java.util.Collection;

import org.spin.node.DestroyableQueryActionMap;
import org.spin.node.UnknownQueryTypeException;
import org.spin.node.actions.QueryAction;

/**
 * 
 * @author Clint Gilbert
 * 
 * Nov 22, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 */
public final class EagleICentralQueryActionMap extends DestroyableQueryActionMap
{
    private final EagleIQueryActionMap delegate = new EagleIQueryActionMap();

    @Override
    public QueryAction<?> getQueryAction(final String queryType) throws UnknownQueryTypeException
    {
        delegate.guardContainsQueryType(queryType);
        
        return NoopQueryAction.instance();
    }

    @Override
    public boolean containsQueryType(final String queryType)
    {
        return delegate.containsQueryType(queryType);
    }

    @Override
    public Collection<String> getQueryTypes()
    {
        return delegate.getQueryTypes();
    }
}
