package org.eaglei.network.actions;

import org.eaglei.services.repository.RepositoryConfig;
import org.eaglei.solr.search.LuceneSearchConfig;
import org.eaglei.solr.search.LuceneSearchProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ImportResource("classpath:search-common-config.xml")
@Import({RepositoryConfig.class, LuceneSearchConfig.class})
public class NetworkSearchConfig
{
    private @Autowired LuceneSearchProvider searchProvider;

    @Bean
    public NetworkSearchProvider networkSearchProvider()
    {
        return new NetworkSearchProvider(searchProvider);
    }

    // TODO: is it right to call the NetworkSearchProvider factory method like
    // this?
    @Bean
    public RDFQueryAction rdfQueryAction()
    {
        return new RDFQueryAction(networkSearchProvider());
    }

    // TODO: is it right to call the NetworkSearchProvider factory method like
    // this?
    @Bean
    public CountQueryAction countQueryAction()
    {
        return new CountQueryAction(networkSearchProvider());
    }
}
