package org.eaglei.network.actions;

import org.eaglei.search.common.Serializer;
import org.spin.node.actions.AbstractQueryAction;
import org.spin.query.message.serializer.SerializationException;
import org.spin.tools.Util;

/**
 * 
 * @author Clint Gilbert
 * 
 * Feb 11, 2010
 *
 * Center for Biomedical Informatics (CBMI)
 * @link https://cbmi.med.harvard.edu/
 *
 * @param <In>
 */
public abstract class WithSerializerQueryAction<In> extends AbstractQueryAction<In>
{
    private final Serializer<In> inputSerializer;

    protected WithSerializerQueryAction(final Serializer<In> serializer)
    {
        super();
        
        Util.guardNotNull(serializer);
        
        this.inputSerializer = serializer;
    }

    protected final Serializer<In> getInputSerializer()
    {
        return inputSerializer;
    }
    
    @Override
    public final In unmarshal(final String serializedCriteria) throws SerializationException
    {
        try
        {
            return inputSerializer.deserialize(serializedCriteria);
        }
        catch(org.eaglei.search.common.SerializationException e)
        {
            throw new SerializationException(e.getMessage(), e);
        }
    }
}
