/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.owlapiv3.ConceptConverter;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;

public class AxiomConverter {
    public static Logger log = Logger.getLogger(AxiomConverter.class.getName());
    private ConceptConverter conceptConverter;
    private OWLDataFactory factory;
    private KnowledgeBase kb;

    public AxiomConverter(PelletReasoner reasoner) {
        this(reasoner.getKB(), reasoner.getManager().getOWLDataFactory());
    }

    public AxiomConverter(KnowledgeBase kb, OWLDataFactory factory) {
        if (kb == null) {
            throw new NullPointerException("KnowledgeBase is null");
        }
        if (factory == null) {
            throw new NullPointerException("OWLDataFactory is null");
        }
        this.kb = kb;
        this.factory = factory;
        this.conceptConverter = new ConceptConverter(kb, factory);
    }

    public OWLAxiom convert(ATermAppl term) {
        Object axiom = null;
        if (term.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLEquivalentClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.SUBFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLSubClassOfAxiom(c1, c2);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermAppl concept;
            OWLClassExpression c;
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            ATermList concepts = (ATermList)term.getArgument(0);
            while (!concepts.isEmpty() && (c = (OWLClassExpression)this.conceptConverter.convert(concept = (ATermAppl)concepts.getFirst())) != null) {
                descriptions.add(c);
                concepts = concepts.getNext();
            }
            if (concepts.isEmpty()) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            OWLClassExpression c1 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c2 = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLClassExpression> descriptions = new HashSet<OWLClassExpression>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            OWLObject p;
            HashSet<OWLObjectProperty> objProperties = new HashSet<OWLObjectProperty>();
            HashSet<OWLDataProperty> dataProperties = new HashSet<OWLDataProperty>();
            ATermList props = (ATermList)term.getArgument(0);
            while (!props.isEmpty() && (p = this.conceptConverter.convert((ATermAppl)term.getArgument(0))) != null) {
                if (p instanceof OWLObjectProperty) {
                    if (!dataProperties.isEmpty()) break;
                    objProperties.add((OWLObjectProperty)p);
                } else {
                    if (!objProperties.isEmpty()) break;
                    dataProperties.add((OWLDataProperty)p);
                }
                props = props.getNext();
            }
            if (props.isEmpty()) {
                axiom = !objProperties.isEmpty() ? this.factory.getOWLDisjointObjectPropertiesAxiom(objProperties) : this.factory.getOWLDisjointDataPropertiesAxiom(dataProperties);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)p1, (OWLObjectProperty)p2));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((OWLDataProperty)p1, (OWLDataProperty)p2));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (term.getArgument(0) instanceof ATermList) {
                ArrayList<OWLObjectPropertyExpression> subs = new ArrayList<OWLObjectPropertyExpression>();
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)this.conceptConverter.convert((ATermAppl)list.getFirst());
                    if (p == null) {
                        subs = null;
                        break;
                    }
                    subs.add(p);
                    list = list.getNext();
                }
                OWLObjectProperty sup = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (subs != null && sup != null) {
                    axiom = this.factory.getOWLSubPropertyChainOfAxiom(subs, (OWLObjectPropertyExpression)sup);
                }
            } else {
                OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (p1 != null && p2 != null) {
                    if (p1 instanceof OWLObjectPropertyExpression && p2 instanceof OWLObjectPropertyExpression) {
                        axiom = this.factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
                    } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                        axiom = this.factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)((OWLDataProperty)p1), (OWLDataPropertyExpression)((OWLDataProperty)p2));
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.EQPROPFUN)) {
            OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((OWLObjectProperty)p1, (OWLObjectProperty)p2));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((OWLDataProperty)p1, (OWLDataProperty)p2));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.DOMAINFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c != null && p != null) {
                axiom = p instanceof OWLObjectProperty ? this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, c) : this.factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)p, c);
            }
        } else if (term.getAFun().equals(ATermUtils.RANGEFUN)) {
            OWLPropertyRange e2 = (OWLPropertyRange)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (e2 != null) {
                if (e2 instanceof OWLClassExpression) {
                    OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p, (OWLClassExpression)e2);
                    }
                } else {
                    OWLDataProperty p = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)p, (OWLDataRange)e2);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVPROPFUN)) {
            OWLObjectProperty p1 = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObjectProperty p2 = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                axiom = this.factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
            }
        } else if (term.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this.factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                if (p instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p);
                } else if (p instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this.factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            OWLIndividual i = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLClassExpression c = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (i != null && c != null) {
                axiom = this.factory.getOWLClassAssertionAxiom(c, i);
            }
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (subj == null) {
                axiom = null;
            } else if (ATermUtils.isLiteral((ATermAppl)term.getArgument(2))) {
                OWLDataProperty pred = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLLiteral obj = (OWLLiteral)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)pred, subj, obj);
                }
            } else {
                OWLObjectProperty pred = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLIndividual obj = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)pred, subj, obj);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.NOTFUN) && ((ATermAppl)term.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = (OWLIndividual)this.conceptConverter.convert((ATermAppl)(term = (ATermAppl)term.getArgument(0)).getArgument(1));
            if (subj == null) {
                axiom = null;
            } else if (ATermUtils.isLiteral((ATermAppl)term.getArgument(2))) {
                OWLDataProperty pred = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLLiteral obj = (OWLLiteral)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)pred, subj, obj);
                }
            } else {
                OWLObjectProperty pred = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLIndividual obj = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLNegativeObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)pred, subj, obj);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            OWLIndividual ind1 = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLIndividual ind2 = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this.factory.getOWLSameIndividualAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            OWLIndividual ind1 = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLIndividual ind2 = (OWLIndividual)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this.factory.getOWLDifferentIndividualsAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermAppl ind;
            OWLIndividual i;
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            ATermList list = (ATermList)term.getArgument(0);
            while (!list.isEmpty() && (i = (OWLIndividual)this.conceptConverter.convert(ind = (ATermAppl)list.getFirst())) != null) {
                individuals.add(i);
                list = list.getNext();
            }
            if (list.isEmpty()) {
                axiom = this.factory.getOWLDifferentIndividualsAxiom(individuals);
            }
        } else if (term.getAFun().equals(ATermUtils.RULEFUN)) {
            HashSet<SWRLAtom> antecedent = new HashSet<SWRLAtom>();
            HashSet<SWRLAtom> consequent = new HashSet<SWRLAtom>();
            ATermList head = (ATermList)term.getArgument(1);
            ATermList body = (ATermList)term.getArgument(2);
            while (!body.isEmpty()) {
                antecedent.add(this.parseToSWRLAtom((ATermAppl)body.getFirst()));
                body = body.getNext();
            }
            while (!head.isEmpty()) {
                consequent.add(this.parseToSWRLAtom((ATermAppl)head.getFirst()));
                head = head.getNext();
            }
            if (!antecedent.contains(null) && !consequent.contains(null)) {
                ATermAppl name = (ATermAppl)term.getArgument(0);
                axiom = name == ATermUtils.EMPTY ? this.factory.getSWRLRule(antecedent, consequent) : (ATermUtils.isBnode(name) ? this.factory.getSWRLRule(NodeID.getNodeID((String)((ATermAppl)name.getArgument(0)).getName()), antecedent, consequent) : this.factory.getSWRLRule(IRI.create((String)name.getName()), antecedent, consequent));
            }
        }
        if (axiom == null) {
            log.warning("Cannot convert to OWLAPI: " + term);
        }
        return axiom;
    }

    private SWRLAtom parseToSWRLAtom(ATermAppl term) {
        SWRLClassAtom atom = null;
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl i = (ATermAppl)term.getArgument(0);
            SWRLIArgument io = this.parseToAtomIObject(i);
            OWLClassExpression c = (OWLClassExpression)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            atom = this.factory.getSWRLClassAtom(c, io);
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl i1 = (ATermAppl)term.getArgument(1);
            ATermAppl i2 = (ATermAppl)term.getArgument(2);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            if (this.kb.isObjectProperty(p)) {
                SWRLIArgument io2 = this.parseToAtomIObject(i2);
                OWLObjectProperty op = this.factory.getOWLObjectProperty(IRI.create((String)p.getName()));
                atom = this.factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)op, io1, io2);
            } else if (this.kb.isDatatypeProperty(p)) {
                SWRLDArgument do2 = this.parseToAtomDObject(i2);
                OWLDataProperty dp = this.factory.getOWLDataProperty(IRI.create((String)p.getName()));
                atom = this.factory.getSWRLDataPropertyAtom((OWLDataPropertyExpression)dp, io1, do2);
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            SWRLIArgument io2 = this.parseToAtomIObject(i2);
            atom = this.factory.getSWRLSameIndividualAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLIArgument io1 = this.parseToAtomIObject(i1);
            SWRLIArgument io2 = this.parseToAtomIObject(i2);
            atom = this.factory.getSWRLDifferentIndividualsAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            ArrayList<SWRLDArgument> list = new ArrayList<SWRLDArgument>();
            args = args.getNext();
            while (!args.isEmpty()) {
                ATermAppl arg = (ATermAppl)args.getFirst();
                list.add(this.parseToAtomDObject(arg));
                args = args.getNext();
            }
            atom = this.factory.getSWRLBuiltInAtom(IRI.create((String)builtin.getName()), list);
        }
        if (atom == null) {
            log.warning("Cannot convert to SWRLAtom: " + term);
        }
        return atom;
    }

    private SWRLIArgument parseToAtomIObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return this.factory.getSWRLVariable(IRI.create((String)((ATermAppl)t.getArgument(0)).getName()));
        }
        if (this.kb.isIndividual(t)) {
            return this.factory.getSWRLIndividualArgument((OWLIndividual)this.conceptConverter.convert(t));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    private SWRLDArgument parseToAtomDObject(ATermAppl t) {
        if (ATermUtils.isVar(t)) {
            return this.factory.getSWRLVariable(IRI.create((String)((ATermAppl)t.getArgument(0)).getName()));
        }
        if (ATermUtils.isLiteral(t)) {
            return this.factory.getSWRLLiteralArgument((OWLLiteral)this.conceptConverter.convert(t));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }
}

