/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.CircularReferenceException;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.MemoryRefStack;
import com.google.gson.ObjectNavigator;
import com.google.gson.ObjectNavigatorFactory;
import com.google.gson.ObjectTypePair;
import com.google.gson.Pair;
import com.google.gson.ParameterizedTypeHandlerMap;
import com.google.gson.Preconditions;
import com.google.gson.TypeInfoArray;
import com.google.gson.TypeInfoFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonSerializationVisitor
implements ObjectNavigator.Visitor {
    private final ObjectNavigatorFactory factory;
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final boolean serializeNulls;
    private final JsonSerializationContext context;
    private final MemoryRefStack ancestors;
    private JsonElement root;

    JsonSerializationVisitor(ObjectNavigatorFactory factory, boolean serializeNulls, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, JsonSerializationContext context, MemoryRefStack ancestors) {
        this.factory = factory;
        this.serializeNulls = serializeNulls;
        this.serializers = serializers;
        this.context = context;
        this.ancestors = ancestors;
    }

    @Override
    public Object getTarget() {
        return null;
    }

    @Override
    public void start(ObjectTypePair node) {
        if (node == null) {
            return;
        }
        if (this.ancestors.contains(node)) {
            throw new CircularReferenceException(node);
        }
        this.ancestors.push(node);
    }

    @Override
    public void end(ObjectTypePair node) {
        if (node != null) {
            this.ancestors.pop();
        }
    }

    @Override
    public void startVisitingObject(Object node) {
        this.assignToRoot(new JsonObject());
    }

    @Override
    public void visitArray(Object array, Type arrayType) {
        this.assignToRoot(new JsonArray());
        int length = Array.getLength(array);
        TypeInfoArray fieldTypeInfo = TypeInfoFactory.getTypeInfoForArray(arrayType);
        Type componentType = fieldTypeInfo.getSecondLevelType();
        for (int i = 0; i < length; ++i) {
            Object child = Array.get(array, i);
            Type childType = componentType;
            this.addAsArrayElement(new ObjectTypePair(child, childType, false));
        }
    }

    @Override
    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        try {
            if (this.isFieldNull(f, obj)) {
                if (this.serializeNulls) {
                    this.addChildAsElement(f, JsonNull.createJsonNull());
                }
            } else {
                Object array = this.getFieldValue(f, obj);
                this.addAsChildOfObject(f, new ObjectTypePair(array, typeOfF, false));
            }
        }
        catch (CircularReferenceException e2) {
            throw e2.createDetailedException(f);
        }
    }

    @Override
    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        try {
            if (this.isFieldNull(f, obj)) {
                if (this.serializeNulls) {
                    this.addChildAsElement(f, JsonNull.createJsonNull());
                }
            } else {
                Object fieldValue = this.getFieldValue(f, obj);
                this.addAsChildOfObject(f, new ObjectTypePair(fieldValue, typeOfF, false));
            }
        }
        catch (CircularReferenceException e2) {
            throw e2.createDetailedException(f);
        }
    }

    @Override
    public void visitPrimitive(Object obj) {
        JsonElement json = obj == null ? JsonNull.createJsonNull() : new JsonPrimitive(obj);
        this.assignToRoot(json);
    }

    private void addAsChildOfObject(Field f, ObjectTypePair fieldValuePair) {
        JsonElement childElement = this.getJsonElementForChild(fieldValuePair);
        this.addChildAsElement(f, childElement);
    }

    private void addChildAsElement(Field f, JsonElement childElement) {
        FieldNamingStrategy namingPolicy = this.factory.getFieldNamingPolicy();
        this.root.getAsJsonObject().add(namingPolicy.translateName(f), childElement);
    }

    private void addAsArrayElement(ObjectTypePair elementTypePair) {
        if (elementTypePair.getObject() == null) {
            this.root.getAsJsonArray().add(JsonNull.createJsonNull());
        } else {
            JsonElement childElement = this.getJsonElementForChild(elementTypePair);
            this.root.getAsJsonArray().add(childElement);
        }
    }

    private JsonElement getJsonElementForChild(ObjectTypePair fieldValueTypePair) {
        ObjectNavigator on = this.factory.create(fieldValueTypePair);
        JsonSerializationVisitor childVisitor = new JsonSerializationVisitor(this.factory, this.serializeNulls, this.serializers, this.context, this.ancestors);
        on.accept(childVisitor);
        return childVisitor.getJsonElement();
    }

    @Override
    public boolean visitUsingCustomHandler(ObjectTypePair objTypePair) {
        try {
            Object obj = objTypePair.getObject();
            if (obj == null) {
                if (this.serializeNulls) {
                    this.assignToRoot(JsonNull.createJsonNull());
                }
                return true;
            }
            JsonElement element = this.findAndInvokeCustomSerializer(objTypePair);
            if (element != null) {
                this.assignToRoot(element);
                return true;
            }
            return false;
        }
        catch (CircularReferenceException e2) {
            throw e2.createDetailedException(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement findAndInvokeCustomSerializer(ObjectTypePair objTypePair) {
        Pair<JsonSerializer<?>, ObjectTypePair> pair = objTypePair.getMatchingHandler(this.serializers);
        if (pair == null) {
            return null;
        }
        JsonSerializer<?> serializer = pair.getFirst();
        objTypePair = pair.getSecond();
        this.start(objTypePair);
        try {
            JsonElement element = serializer.serialize(objTypePair.getObject(), objTypePair.getType(), this.context);
            JsonElement jsonElement = element == null ? JsonNull.createJsonNull() : element;
            return jsonElement;
        }
        finally {
            this.end(objTypePair);
        }
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Type declaredTypeOfField, Object parent) {
        try {
            Preconditions.checkState(this.root.isJsonObject());
            Object obj = f.get(parent);
            if (obj == null) {
                if (this.serializeNulls) {
                    this.addChildAsElement(f, JsonNull.createJsonNull());
                }
                return true;
            }
            ObjectTypePair objTypePair = new ObjectTypePair(obj, declaredTypeOfField, false);
            JsonElement child = this.findAndInvokeCustomSerializer(objTypePair);
            if (child != null) {
                this.addChildAsElement(f, child);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException();
        }
        catch (CircularReferenceException e3) {
            throw e3.createDetailedException(f);
        }
    }

    private void assignToRoot(JsonElement newRoot) {
        Preconditions.checkNotNull(newRoot);
        this.root = newRoot;
    }

    private boolean isFieldNull(Field f, Object obj) {
        return this.getFieldValue(f, obj) == null;
    }

    private Object getFieldValue(Field f, Object obj) {
        try {
            return f.get(obj);
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public JsonElement getJsonElement() {
        return this.root;
    }
}

