/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.core.DataSourceGraph;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceImpl
implements DataSource {
    protected DataSourceGraph dsg = null;
    private Map<Graph, Model> cache = new HashMap<Graph, Model>();

    public DataSourceImpl() {
        this.dsg = new DataSourceGraphImpl();
    }

    public DataSourceImpl(DataSourceGraph otherDSG) {
        this.dsg = otherDSG;
    }

    public DataSourceImpl(Model model) {
        this.addToCache(model);
        this.dsg = new DataSourceGraphImpl(model.getGraph());
    }

    public DataSourceImpl(Dataset ds) {
        this.dsg = new DataSourceGraphImpl(ds);
    }

    @Override
    public Model getDefaultModel() {
        return this.graph2model(this.dsg.getDefaultGraph());
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    public DataSourceGraph getDataSourceGraph() {
        return this.dsg;
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    @Override
    public Model getNamedModel(String uri) {
        Node n = Node.createURI(uri);
        Graph g = this.dsg.getGraph(n);
        if (g == null) {
            return null;
        }
        return this.graph2model(g);
    }

    @Override
    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        this.addToCache(model);
        Node n = Node.createURI(uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void removeNamedModel(String uri) {
        Node n = Node.createURI(uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
    }

    @Override
    public void replaceNamedModel(String uri, Model model) {
        Node n = Node.createURI(uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
        this.addToCache(model);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void setDefaultModel(Model model) {
        this.removeFromCache(this.dsg.getDefaultGraph());
        this.addToCache(model);
        this.dsg.setDefaultGraph(model.getGraph());
    }

    @Override
    public boolean containsNamedModel(String uri) {
        Node n = Node.createURI(uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
        this.cache = null;
    }

    private synchronized void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    private synchronized void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    private synchronized Model graph2model(Graph graph) {
        Model model = this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph(graph);
            this.cache.put(graph, model);
        }
        return model;
    }
}

