/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.HashSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryTermExtractor {
    public static final WeightedTerm[] getTerms(Query query2) {
        return QueryTermExtractor.getTerms(query2, false);
    }

    public static final WeightedTerm[] getIdfWeightedTerms(Query query2, IndexReader reader, String fieldName) {
        WeightedTerm[] terms = QueryTermExtractor.getTerms(query2, false, fieldName);
        int totalNumDocs = reader.numDocs();
        for (int i = 0; i < terms.length; ++i) {
            try {
                int docFreq = reader.docFreq(new Term(fieldName, terms[i].term));
                if (totalNumDocs < docFreq) {
                    docFreq = totalNumDocs;
                }
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                terms[i].weight *= idf;
                continue;
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return terms;
    }

    public static final WeightedTerm[] getTerms(Query query2, boolean prohibited, String fieldName) {
        HashSet<WeightedTerm> terms = new HashSet<WeightedTerm>();
        if (fieldName != null) {
            fieldName = StringHelper.intern(fieldName);
        }
        QueryTermExtractor.getTerms(query2, terms, prohibited, fieldName);
        return terms.toArray(new WeightedTerm[0]);
    }

    public static final WeightedTerm[] getTerms(Query query2, boolean prohibited) {
        return QueryTermExtractor.getTerms(query2, prohibited, null);
    }

    private static final void getTerms(Query query2, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        try {
            if (query2 instanceof BooleanQuery) {
                QueryTermExtractor.getTermsFromBooleanQuery((BooleanQuery)query2, terms, prohibited, fieldName);
            } else if (query2 instanceof FilteredQuery) {
                QueryTermExtractor.getTermsFromFilteredQuery((FilteredQuery)query2, terms, prohibited, fieldName);
            } else {
                HashSet<Term> nonWeightedTerms = new HashSet<Term>();
                query2.extractTerms(nonWeightedTerms);
                for (Term term : nonWeightedTerms) {
                    if (fieldName != null && term.field() != fieldName) continue;
                    terms.add(new WeightedTerm(query2.getBoost(), term.text()));
                }
            }
        }
        catch (UnsupportedOperationException ignore) {
            // empty catch block
        }
    }

    private static final void getTermsFromBooleanQuery(BooleanQuery query2, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        BooleanClause[] queryClauses = query2.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].getOccur() == BooleanClause.Occur.MUST_NOT) continue;
            QueryTermExtractor.getTerms(queryClauses[i].getQuery(), terms, prohibited, fieldName);
        }
    }

    private static void getTermsFromFilteredQuery(FilteredQuery query2, HashSet<WeightedTerm> terms, boolean prohibited, String fieldName) {
        QueryTermExtractor.getTerms(query2.getQuery(), terms, prohibited, fieldName);
    }
}

