/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIBasicInstance;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;
import org.eaglei.model.NonOntologyProperties;
import org.eaglei.model.ReferencingResources;

public class EIInstance
implements Serializable {
    public static EIInstance NULL_INSTANCE = new EIInstance(EIClass.NULL_CLASS, EIEntity.NULL_ENTITY);
    private static final long serialVersionUID = 1L;
    private EIBasicInstance mainInstance;
    private NonOntologyProperties extendedInstanceProperties;
    private Map<EIEntity, EIInstance> embeddedInstances;
    private Set<EIEntity> stubs;
    private ReferencingResources referencingResources;

    private EIInstance() {
    }

    @Deprecated
    public static EIInstance createEmptyInstance(EIEntity instanceType, EIEntity instanceEntity) {
        return new EIInstance(instanceType, instanceEntity);
    }

    public static EIInstance createEmptyInstance(EIClass instanceClass, EIEntity instanceEntity) {
        return new EIInstance(instanceClass, instanceEntity);
    }

    @Deprecated
    private EIInstance(EIEntity instanceType, EIEntity instanceEntity) {
        this(instanceType, instanceEntity, false);
    }

    private EIInstance(EIClass instanceClass, EIEntity instanceEntity) {
        this.mainInstance = EIBasicInstance.createEmptyBasicInstance(instanceEntity);
        this.mainInstance.setInstanceClass(instanceClass);
    }

    @Deprecated
    private EIInstance(EIEntity instanceType, EIEntity instanceEntity, boolean isExtended) {
        this.mainInstance = EIBasicInstance.createEmptyBasicInstance(instanceEntity);
        this.mainInstance.setInstanceType(instanceType);
    }

    public EIEntity getEntity() {
        return this.mainInstance.getEntity();
    }

    public EIClass getInstanceClass() {
        return this.mainInstance.getInstanceClass();
    }

    public void setInstanceClass(EIClass instanceClass) {
        this.mainInstance.setInstanceClass(instanceClass);
    }

    public EIURI getInstanceURI() {
        return this.mainInstance.getInstanceURI();
    }

    public void setInstanceLabel(String instanceLabel) {
        this.mainInstance.setInstanceLabel(instanceLabel);
    }

    public String getInstanceLabel() {
        return this.mainInstance.getInstanceLabel();
    }

    public EIEntity getInstanceType() {
        return this.mainInstance.getInstanceType();
    }

    public void setInstanceType(EIEntity instanceType) {
        this.mainInstance.setInstanceType(instanceType);
    }

    public Map<EIEntity, Set<EIEntity>> getObjectProperties() {
        return this.mainInstance.getObjectProperties();
    }

    public void addObjectProperty(EIEntity property, EIEntity value) {
        this.mainInstance.addObjectProperty(property, value);
    }

    public Set<EIEntity> getObjectProperty(EIEntity property) {
        return this.mainInstance.getObjectProperty(property);
    }

    public void replaceObjectPropertyValue(EIEntity property, EIURI oldValue, EIEntity newValue) {
        this.mainInstance.replaceObjectPropertyValue(property, oldValue, newValue);
    }

    public void replaceObjectPropertyAllValues(EIEntity property, Set<EIEntity> values) {
        this.mainInstance.replaceObjectPropertyAllValues(property, values);
    }

    public Map<EIEntity, Set<String>> getDatatypeProperties() {
        return this.mainInstance.getDatatypeProperties();
    }

    public void addDatattypeProperty(EIEntity property, String value) {
        this.mainInstance.addDatattypeProperty(property, value);
    }

    public Set<String> getDatatypeProperty(EIEntity property) {
        return this.mainInstance.getDatatypeProperty(property);
    }

    public void replaceDatatypePropertyValue(EIEntity property, String oldValue, String newValue) {
        this.mainInstance.replaceDatatypePropertyValue(property, oldValue, newValue);
    }

    public void replaceDatatypePropertyAllValues(EIEntity property, Set<String> values) {
        this.mainInstance.replaceDatatypePropertyAllValues(property, values);
    }

    public void addEIType(EIEntity eiType) {
        this.mainInstance.addEIType(eiType);
    }

    public void setOtherEITypes(List<EIEntity> eiTypes) {
        this.mainInstance.setOtherEITypes(eiTypes);
    }

    public List<EIEntity> getOtherEITypes() {
        return this.mainInstance.getOtherEITypes();
    }

    public int compareTo(Object o) {
        return this.mainInstance.compareTo(o);
    }

    public String toString() {
        return this.mainInstance.toString();
    }

    public void setHasAllRequiredProperties(boolean instanceHasAllRequiredProperties) {
        this.mainInstance.setHasAllRequiredProperties(instanceHasAllRequiredProperties);
    }

    public boolean hasAllRequiredProperties() {
        return this.mainInstance.hasAllRequiredProperties();
    }

    public EIEntity getWFState() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getWFState();
        }
        return null;
    }

    public void setWFState(EIEntity state) {
        this.extendInstance();
        this.extendedInstanceProperties.setWFState(state);
    }

    public EIEntity getWFOwner() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getWFOwner();
        }
        return null;
    }

    public void setWFOwner(EIEntity ownerUri) {
        this.extendInstance();
        this.extendedInstanceProperties.setWFOwner(ownerUri);
    }

    public String getCreationDate() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getCreationDate();
        }
        return null;
    }

    public void setCreationDate(String date2) {
        this.extendInstance();
        this.extendedInstanceProperties.setCreationDate(date2);
    }

    public String getModificationDate() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getModificationDate();
        }
        return null;
    }

    public void setModificationDate(String date2) {
        this.extendInstance();
        this.extendedInstanceProperties.setModificationDate(date2);
    }

    public Map<EIEntity, Set<EIEntity>> getNonOntologyResourceProperties() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getNonOntologyResourceProperties();
        }
        return Collections.emptyMap();
    }

    public void addNonOntologyResourceProperty(EIEntity property, EIEntity resource) {
        this.extendInstance();
        this.extendedInstanceProperties.addNonOntologyResourceProperty(property, resource);
    }

    public Set<EIEntity> getNonOntologyResourceProperty(EIEntity property) {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getNonOntologyResourceProperty(property);
        }
        return Collections.emptySet();
    }

    public void replaceNonOntologyResourcePropertyValue(EIEntity property, EIURI oldValue, EIEntity newValue) {
        this.extendInstance();
        this.extendedInstanceProperties.replaceNonOntologyResourcePropertyValue(property, oldValue, newValue);
    }

    public void replaceNonOntologyResourcePropertyAllValues(EIEntity property, Set<EIEntity> values) {
        this.extendInstance();
        this.extendedInstanceProperties.replaceNonOntologyResourcePropertyAllValues(property, values);
    }

    public Map<EIEntity, Set<String>> getNonOntologyLiteralProperties() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getNonOntologyLiteralProperties();
        }
        return Collections.emptyMap();
    }

    public void addNonOntologyLiteralProperty(EIEntity property, String literal) {
        this.extendInstance();
        this.extendedInstanceProperties.addNonOntologyLiteralProperty(property, literal);
    }

    public Set<String> getNonOntologyLiteralProperty(EIEntity property) {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getNonOntologyLiteralProperty(property);
        }
        return Collections.emptySet();
    }

    public void replaceNonOntologyLiteralProperty(EIEntity property, String oldValue, String newValue) {
        this.extendInstance();
        this.extendedInstanceProperties.replaceNonOntologyLiteralProperty(property, oldValue, newValue);
    }

    public void replaceNonOntologyLiteralPropertyAllValues(EIEntity property, Set<String> values) {
        this.extendInstance();
        this.extendedInstanceProperties.replaceNonOntologyLiteralPropertyAllValues(property, values);
    }

    public Map<EIEntity, EIEntity> getReadOnlyResourceProperties() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getReadOnlyResourceProperties();
        }
        return Collections.emptyMap();
    }

    public void setReadOnlyResourceProperty(EIEntity property, EIEntity value) {
        this.extendInstance();
        this.extendedInstanceProperties.setReadOnlyResourceProperty(property, value);
    }

    public Map<EIEntity, String> getReadOnlyLiteralProperties() {
        if (this.isExtendedInstance()) {
            return this.extendedInstanceProperties.getReadOnlyLiteralProperties();
        }
        return Collections.emptyMap();
    }

    public void setReadOnlyLiteralProperties(Map<EIEntity, String> readOnlyLiteralProperties) {
        this.extendInstance();
        this.extendedInstanceProperties.setReadOnlyLiteralProperties(readOnlyLiteralProperties);
    }

    public void setReadOnlyLiteralProperty(EIEntity property, String value) {
        this.extendInstance();
        this.extendedInstanceProperties.setReadOnlyLiteralProperty(property, value);
    }

    public void addEmbeddedInstance(EIEntity property, EIInstance instance) {
        if (instance == null || NULL_INSTANCE.equals(instance)) {
            return;
        }
        if (this.embeddedInstances == null) {
            this.embeddedInstances = new HashMap<EIEntity, EIInstance>();
        }
        this.addObjectProperty(property, instance.getEntity());
        instance.setEmbedded(true);
        this.embeddedInstances.put(instance.getEntity(), instance);
    }

    public void removeEmbeddedInstance(EIEntity instanceEntity) {
        if (this.hasEmbeddedInstances()) {
            this.embeddedInstances.remove(instanceEntity);
            EIEntity property = this.findPropertyForEmbeddedInstance(instanceEntity);
            if (!EIEntity.NULL_ENTITY.equals(property)) {
                this.replaceObjectPropertyValue(property, instanceEntity.getURI(), EIEntity.NULL_ENTITY);
            }
        }
    }

    private EIEntity findPropertyForEmbeddedInstance(EIEntity instanceEntity) {
        for (Map.Entry<EIEntity, Set<EIEntity>> entry : this.getObjectProperties().entrySet()) {
            if (!entry.getValue().contains(instanceEntity)) continue;
            return entry.getKey();
        }
        return EIEntity.NULL_ENTITY;
    }

    public EIEntity findPropertyForInstance(EIEntity instanceEntity) {
        return this.mainInstance.findPropertyForInstance(instanceEntity);
    }

    public EIInstance getEmbeddedInstance(EIEntity instanceEntity) {
        if (instanceEntity == null || instanceEntity == EIEntity.NULL_ENTITY || !this.hasEmbeddedInstances()) {
            return NULL_INSTANCE;
        }
        return this.embeddedInstances.containsKey(instanceEntity) ? this.embeddedInstances.get(instanceEntity) : NULL_INSTANCE;
    }

    public Map<EIEntity, EIInstance> getEmbeddedInstances() {
        if (this.hasEmbeddedInstances()) {
            return this.embeddedInstances;
        }
        return Collections.emptyMap();
    }

    public List<EIInstance> getEmbeddedInstanceList() {
        if (this.hasEmbeddedInstances()) {
            return new ArrayList<EIInstance>(this.embeddedInstances.values());
        }
        return Collections.emptyList();
    }

    public List<EIURI> getEmbeddedInstanceUriList() {
        if (this.hasEmbeddedInstances()) {
            ArrayList<EIURI> uris = new ArrayList<EIURI>();
            for (EIEntity entity : this.embeddedInstances.keySet()) {
                uris.add(entity.getURI());
            }
            return uris;
        }
        return Collections.emptyList();
    }

    public boolean hasEmbeddedInstances() {
        return this.embeddedInstances != null && !this.embeddedInstances.isEmpty();
    }

    public boolean isExtendedInstance() {
        return this.extendedInstanceProperties != null;
    }

    private void extendInstance() {
        if (this.extendedInstanceProperties == null) {
            this.extendedInstanceProperties = new NonOntologyProperties();
        }
    }

    public boolean isEmbeddedInstance() {
        return this.mainInstance.isEmbedded();
    }

    public void setEmbedded(boolean isEmbedded) {
        this.mainInstance.setEmbedded(isEmbedded);
    }

    public EIClass getRootSuperType() {
        return this.mainInstance.getRootSuperType();
    }

    public void setRootSuperType(EIClass rootSuperType) {
        this.mainInstance.setRootSuperType(rootSuperType);
    }

    public boolean isStub() {
        if (!this.isExtendedInstance()) {
            return false;
        }
        String stubValue = this.extendedInstanceProperties.getStubPropertyValue();
        if (stubValue == null) {
            return false;
        }
        return stubValue.equalsIgnoreCase("True");
    }

    public boolean isPropertyValueAnEmbeddedInstance(EIEntity propertyEntity) {
        if (propertyEntity == null || EIEntity.NULL_ENTITY.equals(propertyEntity) || !this.hasEmbeddedInstances()) {
            return false;
        }
        if (this.isEmbeddedInstance()) {
            return false;
        }
        Set<EIEntity> propertyValues = this.getObjectProperty(propertyEntity);
        if (propertyValues == null || propertyValues.isEmpty()) {
            return false;
        }
        EIEntity propertyValue = propertyValues.iterator().next();
        if (propertyValue == null || EIEntity.NULL_ENTITY.equals(propertyValue)) {
            return false;
        }
        return this.embeddedInstances.containsKey(propertyValue);
    }

    public void setStubs(Set<EIEntity> stubs) {
        this.stubs = stubs;
    }

    public Set<EIEntity> getStubs() {
        if (this.stubs != null) {
            return this.stubs;
        }
        return Collections.emptySet();
    }

    public boolean isPropertyValueAStub(EIEntity propertyEntity, EIEntity propertyValue) {
        if (propertyEntity == null || EIEntity.NULL_ENTITY.equals(propertyEntity) || propertyValue == null || EIEntity.NULL_ENTITY.equals(propertyValue) || !this.hasStubs()) {
            return false;
        }
        if (this.getObjectProperty(propertyEntity) == null || !this.getObjectProperty(propertyEntity).contains(propertyValue)) {
            return false;
        }
        return this.stubs.contains(propertyValue);
    }

    public boolean hasStubs() {
        return this.stubs != null && !this.stubs.isEmpty();
    }

    public boolean hasReferencingResources() {
        return this.referencingResources != null;
    }

    public void addMaterializedInverseProperty(EIEntity property, EIInstanceMinimal instance) {
        if (this.referencingResources == null) {
            this.referencingResources = new ReferencingResources();
        }
        if (this.mainInstance.getObjectProperty(property) == null || this.mainInstance.getObjectProperty(property) != null && !this.mainInstance.getObjectProperty(property).contains(instance.getInstanceURI())) {
            this.referencingResources.addMaterializedInverseProperty(property, instance);
        }
    }

    public Map<EIEntity, List<EIInstanceMinimal>> getMaterializedInverseProperties() {
        if (this.referencingResources == null) {
            return Collections.emptyMap();
        }
        return this.referencingResources.getMaterializedInverseProperties();
    }

    public void setReferencedByList(List<EIInstanceMinimal> resources) {
        if (this.referencingResources == null) {
            this.referencingResources = new ReferencingResources();
        }
        this.referencingResources.setReferencedByList(resources);
    }

    public List<EIInstanceMinimal> getReferencedByList() {
        if (this.referencingResources == null) {
            return Collections.emptyList();
        }
        return this.referencingResources.getReferencedByList();
    }
}

