/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.HashMap;
import java.util.Map;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class MetadataConstants {
    private static final EIURI sourceUri = EIURI.create("http://eagle-i.org/ont/datatools/1.0/source");
    private static final EIEntity sourceEntity = EIEntity.create(sourceUri, "ETL data source");
    private static final EIURI WFStateUri = EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowState");
    private static final EIEntity WFStateEntity = EIEntity.create(WFStateUri, "Workflow state");
    private static final EIURI WFOwnerUri = EIURI.create("http://eagle-i.org/ont/repo/1.0/hasWorkflowOwner");
    private static final EIEntity WFOwnerEntity = EIEntity.create(WFOwnerUri, "Workflow owner");
    private static final EIURI editTokenUri = EIURI.create("http://eagle-i.org/ont/repo/1.0/hasEditToken");
    private static final EIEntity editTokenEntity = EIEntity.create(editTokenUri, "Edit token (repository internal)");
    private static final EIURI createdUri = EIURI.create("http://purl.org/dc/terms/created");
    private static final EIEntity createdEntity = EIEntity.create(createdUri, "Creation date");
    private static final EIURI modifiedUri = EIURI.create("http://purl.org/dc/terms/modified");
    private static final EIEntity modifiedEntity = EIEntity.create(modifiedUri, "Last modification date");
    private static final EIURI creatorUri = EIURI.create("http://purl.org/dc/terms/creator");
    private static final EIEntity creatorEntity = EIEntity.create(creatorUri, "Creator");
    private static final EIURI mediatorUri = EIURI.create("http://purl.org/dc/terms/mediator");
    private static final EIEntity mediatorEntity = EIEntity.create(mediatorUri, "Mediator");
    private static final EIURI contributorUri = EIURI.create("http://purl.org/dc/terms/contributor");
    private static final EIEntity contributorEntity = EIEntity.create(contributorUri, "Contributor");
    public static final Map<EIURI, EIEntity> readOnlyResources = new HashMap<EIURI, EIEntity>();
    public static final Map<EIURI, EIEntity> readOnlyLiterals;
    public static final String WORKSPACE_NAMED_GRAPH_URI = "namedGraphURI";
    public static final String WORKSPACE_NAMED_GRAPH_LABEL = "namedGraphLabel";
    public static final String WORKSPACE_ADD = "add";
    public static final String WORKSPACE_REMOVE = "remove";
    public static final String WORKSPACE_TYPE = "typeURI";
    public static final String WITHDRAW_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
    public static final String PUBLISH_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
    public static final String CURATION_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
    public static final String DRAFT_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
    public static final String CURATION_STATE_LABEL = "In curation";
    public static final String PUBLISH_STATE_LABEL = "Published";
    public static final String DRAFT_STATE_LABEL = "Draft";
    public static final String WITHDRAW_STATE_LABEL = "Withdrawn";
    public static final EIEntity CURATION_ENTITY;
    public static final EIEntity PUBLISH_ENTITY;
    public static final EIEntity DRAFT_ENTITY;
    public static final EIEntity WITHDRAW_ENTITY;

    public static EIEntity getStatusEntity(EIURI statusUri) {
        if (statusUri == null) {
            return EIEntity.NULL_ENTITY;
        }
        if (DRAFT_URI.equals(statusUri.toString())) {
            return DRAFT_ENTITY;
        }
        if (CURATION_URI.equals(statusUri.toString())) {
            return CURATION_ENTITY;
        }
        if (PUBLISH_URI.equals(statusUri.toString())) {
            return PUBLISH_ENTITY;
        }
        if (WITHDRAW_URI.equals(statusUri.toString())) {
            return WITHDRAW_ENTITY;
        }
        return EIEntity.NULL_ENTITY;
    }

    static {
        readOnlyResources.put(WFStateUri, WFStateEntity);
        readOnlyResources.put(WFOwnerUri, WFOwnerEntity);
        readOnlyResources.put(creatorUri, creatorEntity);
        readOnlyResources.put(mediatorUri, mediatorEntity);
        readOnlyResources.put(contributorUri, contributorEntity);
        readOnlyLiterals = new HashMap<EIURI, EIEntity>();
        readOnlyLiterals.put(sourceUri, sourceEntity);
        readOnlyLiterals.put(createdUri, createdEntity);
        readOnlyLiterals.put(modifiedUri, modifiedEntity);
        readOnlyLiterals.put(editTokenUri, editTokenEntity);
        CURATION_ENTITY = EIEntity.create(CURATION_URI, CURATION_STATE_LABEL);
        PUBLISH_ENTITY = EIEntity.create(PUBLISH_URI, PUBLISH_STATE_LABEL);
        DRAFT_ENTITY = EIEntity.create(DRAFT_URI, DRAFT_STATE_LABEL);
        WITHDRAW_ENTITY = EIEntity.create(WITHDRAW_URI, WITHDRAW_STATE_LABEL);
    }
}

