/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import com.hp.hpl.jena.query.QuerySolution;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.MetadataConstants;

public class SPARQLResultsUtil {
    public static EIEntity getEntityFromSolution(QuerySolution solution, String uriVariable, String labelVariable) {
        if (solution.contains(uriVariable)) {
            EIURI uri = EIURI.create(solution.getResource(uriVariable).getURI());
            if ("r_state".equals(uriVariable)) {
                return MetadataConstants.getStatusEntity(uri);
            }
            String label = "<none>";
            if (solution.contains(labelVariable)) {
                label = solution.getLiteral(labelVariable).getString();
            }
            return EIEntity.create(uri, label);
        }
        return EIEntity.NULL_ENTITY;
    }

    public static EIURI getUriFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return EIURI.create(solution.getResource(variable).getURI());
        }
        return EIURI.NULL_EIURI;
    }

    public static String getStringFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString();
        }
        return "";
    }

    public static boolean getBooleanFromSolution(QuerySolution solution, String variable) {
        if (solution.contains(variable)) {
            return solution.getLiteral(variable).getString().equals("True");
        }
        return false;
    }
}

