/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.network.actions;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eaglei.network.actions.SearchProviderOp;
import org.eaglei.network.actions.SearchProviderQueryAction;
import org.eaglei.network.actions.WithSearchProviderOp;
import org.eaglei.search.provider.SearchCountRequest;
import org.eaglei.search.provider.SearchCounts;
import org.eaglei.search.provider.SearchProvider;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.search.provider.SearchResultSet;
import org.spin.tools.Util;

public final class SearchProviderOperations {
    private static final Logger log = Logger.getLogger(SearchProviderQueryAction.class);
    private static final boolean INFO = log.isInfoEnabled();

    private SearchProviderOperations() {
    }

    public static SearchProviderOp<SearchCountRequest, SearchCounts> invokesCount(final SearchProvider provider) {
        return new WithSearchProviderOp<SearchCountRequest, SearchCounts>(provider){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SearchCounts perform(SearchCountRequest param) throws IOException {
                Util.guardNotNull((Object)param);
                if (INFO) {
                    log.info("Getting counts from search provider");
                }
                try {
                    SearchCounts searchCounts = provider.count(param);
                    return searchCounts;
                }
                finally {
                    if (INFO) {
                        log.info("Done getting counts from search provider");
                    }
                }
            }
        };
    }

    public static SearchProviderOp<SearchRequest, SearchResultSet> invokesQuery(final SearchProvider provider) {
        return new WithSearchProviderOp<SearchRequest, SearchResultSet>(provider){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SearchResultSet perform(SearchRequest param) throws IOException {
                Util.guardNotNull((Object)param);
                if (INFO) {
                    log.info("Querying repository");
                }
                try {
                    SearchResultSet searchResultSet = provider.query(param);
                    return searchResultSet;
                }
                finally {
                    if (INFO) {
                        log.info("Done querying repository");
                    }
                }
            }
        };
    }
}

