/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.search;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.solr.search.LuceneSearchIndexSchema;

public final class LuceneSearchQueryBuilder
implements LuceneSearchIndexSchema {
    private static final Log logger = LogFactory.getLog(LuceneSearchQueryBuilder.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private final EIOntModel eagleiOntModel;
    private Analyzer analyzer;

    public LuceneSearchQueryBuilder(EIOntModel eagleiOntModel, Analyzer analyzer) {
        assert (eagleiOntModel != null);
        assert (analyzer != null);
        this.eagleiOntModel = eagleiOntModel;
        this.analyzer = analyzer;
    }

    public Query createQuery(List<String> extractedURIs, SearchRequest request) throws ParseException {
        EIURI typeURI;
        SearchRequest.Term term = request.getTerm();
        BooleanQuery query2 = new BooleanQuery();
        if (request.getProvider() != null) {
            if (request.getProvider().getInstitution() != null) {
                PhraseQuery institutionQuery = new PhraseQuery();
                institutionQuery.add(new Term("institution_uri", request.getProvider().getInstitution().toString()));
                query2.add(institutionQuery, BooleanClause.Occur.MUST);
            }
            if (request.getProvider().getURI() != null) {
                if (request.getBinding() != null) {
                    EIURI providerPropertyURI = this.eagleiOntModel.getResourceProviderProperty(request.getBinding().getType());
                    if (providerPropertyURI == null) {
                        logger.error("Unable to compute a resource provider property for request type binding: " + request.getBinding().getType());
                    } else {
                        PhraseQuery propQuery = new PhraseQuery();
                        propQuery.add(new Term(providerPropertyURI.toString(), request.getProvider().getURI().toString()));
                        query2.add(propQuery, BooleanClause.Occur.MUST);
                    }
                } else {
                    BooleanQuery providerQuery = new BooleanQuery();
                    query2.add(providerQuery, BooleanClause.Occur.MUST);
                    String providerValue = request.getProvider().getURI().toString();
                    for (EIURI providerPropertyURI : this.eagleiOntModel.getResourceProviderProperties()) {
                        PhraseQuery propQuery = new PhraseQuery();
                        propQuery.add(new Term(providerPropertyURI.toString(), providerValue));
                        providerQuery.add(propQuery, BooleanClause.Occur.SHOULD);
                    }
                }
            }
            if (request.getProvider().getType() != null) {
                PhraseQuery typeQuery = new PhraseQuery();
                typeQuery.add(new Term("provider_type_uri", request.getProvider().getType().toString()));
                query2.add(typeQuery, BooleanClause.Occur.MUST);
            }
        }
        if (term != null) {
            String text;
            QueryParser labelParser = new QueryParser(Version.LUCENE_30, "label", this.analyzer);
            QueryParser propTextParser = new QueryParser(Version.LUCENE_30, "prop_text", this.analyzer);
            QueryParser inferredTypeLabelParser = new QueryParser(Version.LUCENE_30, "inferred_type_label", this.analyzer);
            QueryParser assertedTypeLabelParser = new QueryParser(Version.LUCENE_30, "asserted_type_label", this.analyzer);
            BooleanQuery termQuery = new BooleanQuery();
            query2.add(termQuery, BooleanClause.Occur.MUST);
            if (extractedURIs.size() > 0) {
                for (String uriStr : extractedURIs) {
                    EIURI uri = EIURI.create(uriStr);
                    if (this.eagleiOntModel.isModelClassURI(uriStr)) {
                        TermQuery typeQuery = new TermQuery(new Term("asserted_type_uri", uriStr));
                        typeQuery.setBoost(300.0f);
                        termQuery.add(typeQuery, BooleanClause.Occur.SHOULD);
                        typeQuery = new TermQuery(new Term("inferred_type_uri", uriStr));
                        typeQuery.setBoost(200.0f);
                        termQuery.add(typeQuery, BooleanClause.Occur.SHOULD);
                    } else {
                        TermQuery uriQuery = new TermQuery(new Term("uri", uriStr));
                        uriQuery.setBoost(1000.0f);
                        termQuery.add(uriQuery, BooleanClause.Occur.SHOULD);
                        TermQuery providerQuery = new TermQuery(new Term("provider_uri", uriStr));
                        providerQuery.setBoost(200.0f);
                        termQuery.add(providerQuery, BooleanClause.Occur.SHOULD);
                    }
                    TermQuery propQuery = new TermQuery(new Term("prop_uri", uriStr));
                    propQuery.setBoost(50.0f);
                    termQuery.add(propQuery, BooleanClause.Occur.SHOULD);
                }
            }
            if ((text = term.getQuery()) != null && text.length() > 0) {
                Query textQuery;
                if (!text.startsWith("\"")) {
                    String phraseText = "\"" + text + "\"";
                    textQuery = LuceneUtils.escapeIfInvalid(labelParser, phraseText);
                    textQuery.setBoost(2.0f);
                    termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                    textQuery = LuceneUtils.escapeIfInvalid(propTextParser, phraseText);
                    textQuery.setBoost(2.0f);
                    termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                }
                textQuery = LuceneUtils.escapeIfInvalid(labelParser, text);
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid(assertedTypeLabelParser, text);
                textQuery.setBoost(0.5f);
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid(inferredTypeLabelParser, text);
                textQuery.setBoost(0.4f);
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
                textQuery = LuceneUtils.escapeIfInvalid(propTextParser, text);
                textQuery.setBoost(0.2f);
                termQuery.add(textQuery, BooleanClause.Occur.SHOULD);
            }
        }
        if ((typeURI = request.getBindingType()) != null) {
            BooleanQuery typeQuery = new BooleanQuery();
            query2.add(typeQuery, BooleanClause.Occur.MUST);
            PhraseQuery assertedType = new PhraseQuery();
            assertedType.add(new Term("asserted_type_uri", typeURI.toString()));
            typeQuery.add(assertedType, BooleanClause.Occur.SHOULD);
            PhraseQuery inferredType = new PhraseQuery();
            inferredType.add(new Term("inferred_type_uri", typeURI.toString()));
            typeQuery.add(inferredType, BooleanClause.Occur.SHOULD);
        }
        if (query2.clauses().isEmpty()) {
            TermQuery allDocsQuery = new TermQuery(new Term("stub", Boolean.toString(false)));
            query2.add(allDocsQuery, BooleanClause.Occur.MUST);
            return query2;
        }
        return query2;
    }

    private void addLabelQuery(QueryParser labelParser, QueryParser propTextParser, BooleanQuery termQuery, String label, boolean isSynonym) {
        try {
            String phraseQueryStr = "\"" + label + "\"";
            Query labelQuery = LuceneUtils.escapeIfInvalid(labelParser, phraseQueryStr);
            if (isSynonym) {
                labelQuery.setBoost(0.8f);
            }
            termQuery.add(labelQuery, BooleanClause.Occur.SHOULD);
            labelQuery = LuceneUtils.escapeIfInvalid(propTextParser, phraseQueryStr);
            if (isSynonym) {
                labelQuery.setBoost(0.8f);
            }
            termQuery.add(labelQuery, BooleanClause.Occur.SHOULD);
        }
        catch (ParseException e2) {
            logger.error(e2);
        }
    }
}

