/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.search;

import java.util.HashMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.provider.ClassCountResult;
import org.eaglei.search.provider.CountResult;
import org.eaglei.search.provider.SearchRequest;
import org.eaglei.solr.search.ClassUsage;

public class ProviderUsageCache {
    private static final Log logger = LogFactory.getLog(ProviderUsageCache.class);
    private final EIOntModel eiOntModel;
    private final HashMap<EIEntity, ClassUsage> mapProviderTypeEntityToUsage = new HashMap();

    public ProviderUsageCache(EIOntModel eiOntModel) {
        this.eiOntModel = eiOntModel;
    }

    void removeUsage(String providerTypeURIStr) {
        EIClass providerClass = this.eiOntModel.getClass(EIURI.create(providerTypeURIStr));
        if (providerClass == null) {
            logger.warn("removeUsage: Unrecognized type for provider: " + providerTypeURIStr);
            return;
        }
        this.removeUsage(providerClass.getEntity());
    }

    void removeUsage(EIEntity providerTypeEntity) {
        ClassUsage providerUsage = this.mapProviderTypeEntityToUsage.get(providerTypeEntity);
        assert (providerUsage != null) : "removeUsage called for a type that had no usage previously recorded: " + providerTypeEntity;
        providerUsage.decrementUsage();
        if (providerUsage.getTotalCount().getCount() == 0) {
            this.mapProviderTypeEntityToUsage.remove(providerTypeEntity);
        }
    }

    void addUsage(String providerTypeURIStr) {
        EIClass providerClass = this.eiOntModel.getClass(EIURI.create(providerTypeURIStr));
        if (providerClass == null) {
            logger.warn("addUsage: Unrecognized type for provider: " + providerTypeURIStr);
            return;
        }
        this.addUsage(providerClass.getEntity());
    }

    void addUsage(EIEntity providerTypeEntity) {
        ClassUsage providerUsage = this.mapProviderTypeEntityToUsage.get(providerTypeEntity);
        if (providerUsage == null) {
            providerUsage = new ClassUsage(providerTypeEntity);
            this.mapProviderTypeEntityToUsage.put(providerTypeEntity, providerUsage);
        }
        providerUsage.incrementUsage();
    }

    public ClassCountResult getProviderCount(SearchRequest request) {
        CountResult providerTotalCount = new CountResult(null, 0);
        TreeSet<CountResult> providerTypes = new TreeSet<CountResult>();
        for (ClassUsage providerUsage : this.mapProviderTypeEntityToUsage.values()) {
            providerTypes.add(providerUsage.getTotalCount());
            providerTotalCount.increment(providerUsage.getTotalCount().getCount());
        }
        ClassCountResult result = new ClassCountResult(request);
        result.setClassCount(providerTotalCount);
        result.setSubClassCounts(providerTypes);
        return result;
    }
}

