/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.solr.suggest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;
import org.eaglei.search.harvest.ResourceChangeEvent;
import org.eaglei.search.harvest.ResourceChangeListener;
import org.eaglei.solr.AbstractLuceneIndexer;
import org.eaglei.solr.suggest.LuceneAutoSuggestIndexSchema;

public class LuceneAutoSuggestIndexer
extends AbstractLuceneIndexer
implements LuceneAutoSuggestIndexSchema,
ResourceChangeListener {
    private static final Log logger = LogFactory.getLog(LuceneAutoSuggestIndexer.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Set<EIEntity> resourceRoots = new HashSet<EIEntity>();
    private static final EIURI RESOURCE_PROVIDER_PROPERTY = EIURI.create("http://eagle-i.org/ont/app/1.0/PropertyGroup_RelatedResourceProvider");

    public LuceneAutoSuggestIndexer(EIOntModel eiOntModel, Analyzer analyzer, Directory directory) {
        super("SuggestIndexer", eiOntModel, analyzer, directory);
        for (EIClass c : eiOntModel.getClassesInGroup("http://eagle-i.org/ont/app/1.0/ClassGroup_DataModelCreate")) {
            this.resourceRoots.add(c.getEntity());
        }
    }

    @Override
    public void onChangeEvent(ResourceChangeEvent event) {
        super.onChangeEvent(event);
        if (event.isDelete()) {
            this.deleteDocuments(event.getEntity().getURI());
        } else {
            this.indexResourceInstance(event);
        }
    }

    @Override
    protected List<Document> getDocumentsFromIndex(EIURI uri) {
        try {
            PhraseQuery propQuery = new PhraseQuery();
            propQuery.add(new Term("uri", uri.toString()));
            IndexSearcher searcher = new IndexSearcher(this.directory, true);
            searcher.setDefaultFieldSortScoring(true, true);
            TopDocs docs = searcher.search((Query)propQuery, 1);
            if (docs.totalHits == 0) {
                return null;
            }
            ArrayList<Document> result = new ArrayList<Document>(docs.scoreDocs.length);
            for (ScoreDoc scoreDoc : docs.scoreDocs) {
                result.add(searcher.doc(scoreDoc.doc));
            }
            return result;
        }
        catch (IOException e2) {
            logger.error(e2);
            return null;
        }
    }

    private List<Document> addStubInstanceDocuments(EIURI uri) {
        ArrayList<Document> docs = new ArrayList<Document>(1);
        Document doc = new Document();
        doc.add(new Field("is_instance", Boolean.TRUE.toString(), Field.Store.YES, Field.Index.NO));
        doc.add(new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NO));
        docs.add(doc);
        this.setDocuments(uri, docs);
        return docs;
    }

    private List<Document> indexResourceInstance(ResourceChangeEvent event) {
        Field[] isValueOfFields = null;
        List<Document> docs = this.getDocuments(event.getEntity().getURI());
        if (docs != null) {
            isValueOfFields = docs.get(0).getFields("is_value_of");
        }
        docs = new ArrayList<Document>(1);
        Document doc = new Document();
        doc.add(new Field("is_instance", Boolean.TRUE.toString(), Field.Store.YES, Field.Index.NO));
        String uri = event.getEntity().getURI().toString();
        doc.add(new Field("uri", uri, Field.Store.YES, Field.Index.NOT_ANALYZED));
        String label = event.getEntity().getLabel();
        doc.add(new Field("entity_label", label, Field.Store.YES, Field.Index.NO));
        doc.add(new Field("label", label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        if (event.getInstitution() != null) {
            String institutionURI = event.getInstitution().getURI().toString();
            doc.add(new Field("institution_uri", institutionURI, Field.Store.YES, Field.Index.NO));
        }
        this.setTypeField(true, doc, event.getType().getURI());
        if (isValueOfFields != null) {
            for (Field f : isValueOfFields) {
                doc.add(f);
            }
        }
        for (EIObjectProperty prop : event.getObjectProperties()) {
            EIURI propURI = prop.getEntity().getURI();
            for (EIURI valueURI : event.getObjectProperty(prop)) {
                this.indexPropertyReference(valueURI, propURI);
            }
        }
        if (event.getProvider() != null) {
            EIURI resourceProviderURI = event.getProvider();
            this.indexPropertyReference(resourceProviderURI, RESOURCE_PROVIDER_PROPERTY);
        }
        docs.add(doc);
        this.setDocuments(event.getEntity().getURI(), docs);
        return docs;
    }

    private void indexPropertyReference(EIURI valueResourceURI, EIURI propertyURI) {
        List<Document> referencedDocs = this.getDocuments(valueResourceURI);
        if (referencedDocs == null) {
            EIClass typeClass = this.eiOntModel.getClass(valueResourceURI);
            referencedDocs = typeClass != null ? this.addTypeDocuments(typeClass.getEntity().getURI()) : this.addStubInstanceDocuments(valueResourceURI);
        }
        for (Document referencedDoc : referencedDocs) {
            boolean alreadyIndexed = false;
            for (String existingProp : referencedDoc.getValues("is_value_of")) {
                if (!existingProp.equals(propertyURI.toString())) continue;
                alreadyIndexed = true;
                break;
            }
            if (alreadyIndexed) break;
            referencedDoc.add(new Field("is_value_of", propertyURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private void setTypeField(boolean isInstance, Document doc, EIURI typeURI) {
        EIEntity rootType = null;
        doc.add(new Field("type", typeURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        List<Document> docs = this.getDocuments(typeURI);
        if (docs == null) {
            this.addTypeDocuments(typeURI);
        }
        if (rootType == null && isInstance) {
            EIClass type = this.eiOntModel.getClass(typeURI);
            rootType = type.getEntity();
        }
        List<EIClass> resourceSuperClasses = this.eiOntModel.getSuperClasses(typeURI);
        for (EIClass superClass : resourceSuperClasses) {
            EIURI superURI = superClass.getEntity().getURI();
            doc.add(new Field("type", superURI.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            List<Document> superDocs = this.getDocuments(superURI);
            if (superDocs == null) {
                this.addTypeDocuments(superURI);
            }
            if (rootType != null || !this.resourceRoots.contains(superClass.getEntity())) continue;
            rootType = superClass.getEntity();
        }
        if (rootType == null && resourceSuperClasses.size() > 0) {
            rootType = resourceSuperClasses.get(resourceSuperClasses.size() - 1).getEntity();
        }
        if (rootType != null) {
            doc.add(new Field("root_type", rootType.getLabel(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
    }

    private List<Document> addTypeDocuments(EIURI typeURI) {
        ArrayList<Document> docs = new ArrayList<Document>();
        this.setDocuments(typeURI, docs);
        EIClass clazz = this.eiOntModel.getClass(typeURI);
        EIURI uri = clazz.getEntity().getURI();
        for (String label : this.eiOntModel.getLabels(uri)) {
            Document doc = new Document();
            doc.add(new Field("is_instance", Boolean.FALSE.toString(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("uri", uri.toString(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("entity_label", clazz.getEntity().getLabel(), Field.Store.YES, Field.Index.NO));
            doc.add(new Field("label", label, Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
            this.setTypeField(false, doc, uri);
            docs.add(doc);
        }
        return docs;
    }
}

