/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mindswap.pellet.utils.iterator.IteratorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedIterator<O, I>
implements Iterator<I> {
    private Iterator<? extends O> outerIterator;
    private Iterator<? extends I> innerIterator;

    public NestedIterator(Iterable<? extends O> outerIterable) {
        this(outerIterable.iterator());
    }

    public NestedIterator(Iterator<? extends O> outerIterator) {
        this.outerIterator = outerIterator;
        this.findIterator();
    }

    private void findIterator() {
        while (this.outerIterator.hasNext()) {
            O subj = this.outerIterator.next();
            this.innerIterator = this.getInnerIterator(subj);
            if (!this.innerIterator.hasNext()) continue;
            return;
        }
        this.innerIterator = IteratorUtils.emptyIterator();
    }

    public abstract Iterator<? extends I> getInnerIterator(O var1);

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public I next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        I value = this.innerIterator.next();
        if (!this.innerIterator.hasNext()) {
            this.findIterator();
        }
        return value;
    }

    @Override
    public void remove() {
        this.innerIterator.remove();
    }
}

