# This script  
#!/bin/sh

# Modify the parameters to match your setup:
TARGET_HOST="localhost:8080"   
USERNAME="bigbird"
PASSWD="bigbird"

# This will result into weekly rotating of the backup
REQ_PARAMS="daily_cron_`date +%u`"

output=repo_backup.out

echo     "================================= Backing up the Eagle-I Repository ======================================"

# The following backs up the user authentication database database
echo "=========================================================================================================="
echo "Now backing up the authentication database..."

curl -S -s --basic -u "${USERNAME}:${PASSWD}" -d "backupDir=${REQ_PARAMS}" ${TARGET_HOST}/repository/admin/backup.jsp > $output

# we are grepping for the "The operation completed successfully!" phrase in the title of the page for redirect on success
if egrep -q 'The operation completed successfully!' $output ; then
    BACKUP_DIR=`egrep 'Backed up authentication data to: ' $output |  awk -F: '{print $2}'` 
    rm "$output"
    echo "...authentication database backup successful!"
else
    echo "***Backup failed!\n"
    cat "$output"
    rm "$output"
    exit 1
fi


# The following backs up the RDF database
echo "\n=========================================================================================================="
echo "Now backing up RDF content to: ${BACKUP_DIR} ..."
if [ -f ${BACKUP_DIR}/all-dump.trig ]
then
    rm ${BACKUP_DIR}/all-dump.trig
fi
curl -S -s -G -X GET -u "${USERNAME}:${PASSWD}" -o ${BACKUP_DIR}/all-dump.trig -d all -d format=application/x-trig http://${TARGET_HOST}/repository/graph > $output
if [ -f ${BACKUP_DIR}/all-dump.trig ]
then
    rm "$output"
    echo "RDF dump file ${BACKUP_DIR}/all-dump.trig created successfully"
    exit 0
fi

echo "***Backup failed!\n"
cat "$output"
rm "$output"
exit 1
