#!/bin/bash

# Get differences between two repositories taht are expected to contain
# the "same" data (i.e.  the same URI suffixes, as if both copied from
# same source by moev-evertyhing, or one m-e'd to the other.
#
# Algorithm is straightforward and stupid:
# 1. get /harvest report for each repo
# 2. transform it, replacing site name with SITE, and sort it.
# 3. compare the transformed reports with diff
# 4. transform back, replacing SITE in "<" line with first site, etc..
#
# Usage:  $0  user1 password1 site1    user2 password2 site2
#  e.g.   $0  kermitfrog qa.harvard.eagle-i.net  bert ernie stage.harvard.eagle-i.net
#
#  lcs 29-mar-11
# $Id: diff-repo.sh 8319 2011-03-29 18:59:22Z lcs14 $

if [ "$#" -ne 6 ]; then
    echo "Usage $0  user1 password1 site1    user2 password2 site2"
    exit 1
fi

# canonical scheme & port for repo access
scheme=https
port=8443

# control verbose messages
Verbose=true

#-------- boilerplate
# keep files in /tmp subdir, cleanup on exit
tmpDir="/tmp/repo-moveevery-$$"
mkdir $tmpDir

cleanup () {
  ## XXX insert echo here to retain the tmp work dir
  rm -rf $tmpDir
}
trap cleanup EXIT

# usage login site file
doHarvest () {
    local login=$1
    local site=$2
    local file=$3
    local status=""
    local repoURL="${scheme}://${site}:${port}"

    $Verbose && echo "Harvesting from $repoURL ..." 1>&2
    if status=`curl -k -s -S -G -u "${login}" -o "/home/mcherry/eagle-i-dev/apps/branches/1.2-MS2.x/target/checkout/repository/scripts/pom.xml" -d detail=identifier \
      --write-out '%{http_code}' -d format=text/plain "${repoURL}/repository/harvest"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to get harvest failed, status=${status}"  1>&2
            if [ -f "$file" ]; then
                echo "Response document:"  1>&2
                cat "$file"  1>&2
            fi
            return 1
        fi
    else
        local c=$?
        echo "curl failed to send HTTP request to get harvest, status=$c"  1>&2
        return 1
    fi
    return 0
}

# usage: site fromFile toFile
xfrm () {
    local prog="\$f=quotemeta('${1}'); while (<>) {s@//\${f}@//SITE@g;print}"
    if perl -CSD -e "$prog" < $2 | sort -u > $3; then
        true
    else
        echo "Transformation of resource data failed, see error messages above."
        exit 1
    fi
}


raw1=${tmpDir}/raw1
raw2=${tmpDir}/raw2
cooked1=${tmpDir}/cooked1
cooked2=${tmpDir}/cooked2

login1="${1}:$2"
site1=$3
login2="${4}:$5"
site2=$6

if doHarvest $login1 $site1 "$raw1" && xfrm $site1 "$raw1" "$cooked1" && \
   doHarvest $login2 $site2 "$raw2" && xfrm $site2 "$raw2" "$cooked2"; then
   diff "$cooked1"  "$cooked2" | \
    sed -e "s@^< http://SITE@< http://${site1}@" -e "s@^> http://SITE@> http://${site2}@" -e '/^[0-9][0-9,]/ d'
else
    echo ""  1>&2
    echo "Something failed while getting or transforming data."  1>&2
    exit 1
fi
