#!/bin/bash

# Move "resources" from one repo to another
#
#   * * * * *    W A R N I N G    * * * * *
#   Check the warnings of the move-everything script. 
#   Same caveats apply
#
# $Id: move-everything.sh 8214 2011-03-24 20:55:55Z lcs14 $
# Author: Ricardo De Lima

#
# TODO: Refactor the move-everything and move-resources script, common functions need to be shared.
#		
#

#------- Constants

format=application/x-trig

# useful namespace prefixs
repo="http://eagle-i.org/ont/repo/1.0/"
owl="http://www.w3.org/2002/07/owl#"
rdfs="http://www.w3.org/2000/01/rdf-schema#"

#-------- boilerplate
# keep files in /tmp subdir, cleanup on exit
tmpDir="/tmp/repo-moveevery-$$"
mkdir $tmpDir

cleanup () {
  ## XXX insert echo here to retain the tmp work dir
  rm -rf $tmpDir
}
#trap cleanup EXIT

# dump resources
# Usage: $0  login url  file
doGetResources () {
    local login=${1}
    local repoURL=$2
    local toFile=$3

    local status=""
    if status=`curl -k -s -G -u "${login}" -o "${toFile}" -d all=true \
      --write-out '%{http_code}' -d "format=${format}" "${repoURL}/repository/graph"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to get graph dump failed, status=${status}"
            if [ -f "$toFile" ]; then
                echo "Response document:"
                cat "$toFile"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get graph dump."
        return 1
    fi
    return 0
}

# dump users
# Usage: $0  login url  file
doGetUsers () {
    local login=${1}
    local repoURL=$2
    local toFile=$3

    local status=""
    if status=`curl -k -s -G -u "${login}" -o "${toFile}" -d type=user -d "exclude=${excludeUsers}" \
        --write-out '%{http_code}' -d "format=${format}" "${repoURL}/repository/export"` ; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to get user dump failed, status=${status}"
            if [ -f "$toFile" ]; then
                echo "Response document:"
                cat "$toFile"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get user dump."
        return 1
    fi
    return 0
}


# upload resources to destination
# Usage: $0  login url  file
doPutResources () {
    local login=${1}
    local repoURL=$2
    local fromFile=$3

    local status=""
    if status=`curl -k -s -u "${login}" -F all=true -F action=replace \
      -F "format=${format}" -F "content=@$fromFile" \
      --write-out '%{http_code}' "${repoURL}/repository/graph"`; then
        if [ "$status" != "201" ]; then
            echo "HTTP Request to PUT graph dump failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to PUT graph dump."
        return 1
    fi
    return 0
}

# upload users to destination
# Usage: $0  login url  file
doPutUsers () {
    local login=${1}
    local repoURL=$2
    local fromFile=$3

    local status=""
    if status=`curl -k -s -u "${login}" -F type=user -F duplicate=replace \
      -F transform=no -F "format=${format}" -F "content=@$fromFile" \
      --write-out '%{http_code}' "${repoURL}/repository/import"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to /import users failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to /import users."
        return 1
    fi
    return 0
}

# Usage: $0  login  url
# returns the URI prefix of the repo
getPrefix () {
    local login=${1}
    local repoURL=$2

    local tmp=${tmpDir}/prefix.txt
    local status=""
    rm -f ${tmp}

    if status=`curl -k -s -u "${login}" -o "${tmp}" -d format=text/plain \
                --write-out '%{http_code}' "${repoURL}/repository/new"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request /new to get URI prefix failed, status=${status}"
            if [ -f "$tmp" ]; then
                echo "Response document:"
                cat "$tmp"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get URI prefix."
        return 1
    fi
    tail -n +2 "${tmp}" | egrep -o '^(.+/)'
}

# Usage: $0 login repoURL username filepath
saveAdminUser () {
    local login=${1}
    local repoURL=$2
    local username=$3
    local out=$4
    local status=""
    rm -f "$out"

    # export the admin user's state
    if status=`curl -k -s -S -G -u "${login}" -o "${out}" -d type=user \
                -d "include=$username" -d format=${format} \
                --write-out '%{http_code}' "${repoURL}/repository/export"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request /export to get admin user failed, status=${status}"
            if [ -f "$out" ]; then
                echo "Response document:"
                cat "$out"
            fi
            return 1
        fi
    else
        echo "curl failed to send HTTP request to get /export, status=$?"
        return 1
    fi
}


# Usage: $0 login repoURL username filepath
# fix admin login user if necessary - check if it has URI, if not, invoke /whoami to create
restoreAdminUser () {
    local login=${1}
    local repoURL=$2
    local username=$3
    local in=$4
    local status=""
    local out=${tmpDir}/restore.out

    if status=`curl -k -s -u "${login}" -F type=user -F duplicate=replace \
      -F "include=$username" -F transform=no -F "format=${format}" -F "content=@$in" \
      --write-out '%{http_code}' "${repoURL}/repository/import"`; then
        if [ "$status" != "200" ]; then
            echo "HTTP Request to import admin user failed, status=${status}"
            return 1
        fi
    else
        echo "curl failed to send HTTP request to import admin user."
        return 1
    fi
    return 0
}

#------------------  Main ----------------------------
usage="${usage} Usage: $0  [--version] [ -f | --force ] [--resourcefile path-to-resource-file] from-url to-username  to-password  to-repo-URL "

excludeUsers=""
moveUsers=true

while echo "$1" | grep -q "^-"; do
    case "$1" in
        --version)
            echo "$0 from release 1.2-MS3.03 SCM revision 9255"
            exit 0 ;;
        -f|--force)
            forceOption=true ;;
        --resourcefile)
        	shift;
            resourceFilemove=true;
            resourceFile="$1" ;;                        
        -*)
              echo "Unknown option $1"
              echo -e $usage
              exit 1;;
    esac
    shift
done


if [ "${resourceFilemove:false}" != true ]; then
		echo $usage
		exit 1
else
	if [ $# -ne 4 ]; then
		echo $usage
		exit 1
	fi
	if [ ! -f ${resourceFile} ]; then
		echo "resource file doesn't exist"
		exit 1
	fi
fi

fromPrefix="${1}/i/"
toLogin="${2}:$3"
toURL=$4


# paths
resources=${resourceFile}
users=${tmpDir}/users.trig
newResources=${tmpDir}/newResources.trig



if [ "${forceOption:false}" != true ]; then

    echo "*************************************"
    echo "*****  DANGER! DANGER! DANGER!  *****   This is a VERY DANGEROUS procedure, and"
    echo "*****  DANGER! DANGER! DANGER!  *****   even when it works as intended it is a"
    echo "*****  DANGER! DANGER! DANGER!  *****   VERY BAD IDEA.  Reply YES below ONLY "
    echo "*****  DANGER! DANGER! DANGER!  *****   if you KNOW what will happen and are "
    echo "*****  DANGER! DANGER! DANGER!  *****   STILL SURE you want to continue."
    echo "*****  DANGER! DANGER! DANGER!  ***** "
    echo "*****  DANGER! DANGER! DANGER!  *****   This will ***DESTROY*** ALL contents"
    echo "*****  DANGER! DANGER! DANGER!  *****   of the repository on the repository at:"
    echo "*****  DANGER! DANGER! DANGER!  *****      $toURL "
    echo "*************************************"
    echo ""
    echo -n "Are you STILL sure you want to continue? "
    read answer
    if echo "$answer" | egrep -iq '^[[:space:]]*y(es)?'; then
        echo "OK, continuing..."
    else
        echo "Aborting."
        exit 0
    fi
fi




if toPrefix=`getPrefix "$toLogin" "$toURL"` ; then
    true
else
    echo "Failed getting prefix for destination."
    echo $toPrefix
    exit 1
fi



     
## Transform
prog="\$f=quotemeta('${fromPrefix}'); while (<>) {s@<\${f}@<${toPrefix}@g;print}"
if perl -CSD -e "$prog" < $resources > $newResources ; then
    true
else
    echo "Transformation of resource data failed, see error messages above."
    exit 1
fi



echo -n "  uploading RDF contents to ${toURL}...."
if doPutResources "$toLogin" "$toURL" "$newResources" ; then
    echo "done."
else
    echo "FAILED uploading resource contents."
    exit 1
fi



