package org.eaglei.repository.format;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;

/**
 * Boilerplate for Sesame RDF writer registry.
 *
 * @author Larry Stone
 * Started May 24, 2010
 * @version $Id: $
 */
public class RDFHTMLWriterFactory implements RDFWriterFactory
{
    /**
     * <p>getRDFFormat</p>
     *
     * @return a {@link org.openrdf.rio.RDFFormat} object.
     */
    public RDFFormat getRDFFormat()
    {
        return RDFHTMLWriter.FORMAT;
    }

    /** {@inheritDoc} */
    public RDFWriter getWriter(OutputStream out)
    {
        return new RDFHTMLWriter(new OutputStreamWriter(out));
    }
    /**
     * <p>getWriter</p>
     *
     * @param out a {@link java.io.Writer} object.
     * @return a {@link org.openrdf.rio.RDFWriter} object.
     */
    public RDFWriter getWriter(Writer out)
    {
        return new RDFHTMLWriter(out);
    }
}
