/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.format;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.eaglei.repository.DataRepository;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class SPARQLHTMLWriter
implements TupleQueryResultWriter {
    public static TupleQueryResultFormat theFormat = new TupleQueryResultFormat("Plain Old HTML", "text/html", ".html");
    private PrintStream out = null;
    private static final String localPrefix = DataRepository.getInstance().getDefaultNamespace();
    public static final String Prologue = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head>  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />  <title>SPARQL Query Results</title> <link rel=\"stylesheet\" type=\"text/css\" href=\"/repository/style/sparql.css\" /></head><body><div><table>\r\n";
    public static final String Postlogue = "</table></div></body></html>\r\n";
    private List<String> columns = null;

    public SPARQLHTMLWriter(OutputStream out) {
        this.out = new PrintStream(out);
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return theFormat;
    }

    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\"><head>  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />  <title>SPARQL Query Results</title> <link rel=\"stylesheet\" type=\"text/css\" href=\"/repository/style/sparql.css\" /></head><body><div><table>\r\n");
        this.out.print("<tr>");
        this.columns = bindingNames;
        for (String bn : bindingNames) {
            this.out.print("<th>" + StringEscapeUtils.escapeHtml((String)bn) + "</th>");
        }
        this.out.println("</tr>");
    }

    public void endQueryResult() throws TupleQueryResultHandlerException {
        this.out.println("</table></div></body></html>\r\n");
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        this.out.println("<tr>");
        for (String bn : this.columns) {
            Value v;
            Value value = v = bs.hasBinding(bn) ? bs.getValue(bn) : null;
            if (v == null) {
                this.out.print("<td>&nbsp;</td>");
                continue;
            }
            if (v instanceof URI) {
                this.out.print("<td>" + SPARQLHTMLWriter.renderLinkedURI((URI)((URI)v)) + "</td>");
                continue;
            }
            this.out.print("<td>" + StringEscapeUtils.escapeHtml((String)bs.getValue(bn).toString()) + "</td>");
        }
        this.out.println("</tr>");
    }

    protected static String renderLinkedURI(URI uri) {
        if (uri.getNamespace().equals(localPrefix)) {
            return "<a href=\"" + uri + "\">" + StringEscapeUtils.escapeHtml((String)uri.toString()) + "</a>";
        }
        return StringEscapeUtils.escapeHtml((String)uri.toString());
    }
}

