/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.DataRepository;

public class RepositoryContextListener
implements ServletContextListener {
    private static Logger log = LogManager.getLogger(RepositoryContextListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            DataRepository.initialize((ServletContext)sce.getServletContext());
        }
        catch (Exception e) {
            log.error((Object)"Got exception in Webapp context initialization, EXPECT NOTHING WILL WORK:", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        DataRepository dr = DataRepository.getInstance();
        if (dr == null) {
            log.error((Object)"Data Repository was not successfully initialized, cannot destroy!");
        } else {
            try {
                dr.destroy(sce.getServletContext());
            }
            catch (Exception e) {
                log.error((Object)"Got exception in Webapp context finalization, but forging ahead:", (Throwable)e);
            }
        }
    }
}

