package jsp.repository.admin;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Collection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.Access;
import org.eaglei.repository.User;
import org.eaglei.repository.admin.AuthUser;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ErrorSendingException;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.NotFoundException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.DataRepository;

public final class users_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List _jspx_dependants;

  static {
    _jspx_dependants = new java.util.ArrayList(1);
    _jspx_dependants.add("/repository/admin/banner.jsp");
  }

  private javax.el.ExpressionFactory _el_expressionfactory;
  private org.apache.AnnotationProcessor _jsp_annotationprocessor;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspInit() {
    _el_expressionfactory = _jspxFactory.getJspApplicationContext(getServletConfig().getServletContext()).getExpressionFactory();
    _jsp_annotationprocessor = (org.apache.AnnotationProcessor) getServletConfig().getServletContext().getAttribute(org.apache.AnnotationProcessor.class.getName());
  }

  public void _jspDestroy() {
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      response.setContentType("text/html;charset=UTF-8");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

      out.write("\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n");
      out.write("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n  <head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"/>\n    <title>Eagle-I Data Repository Admin - Manage User Accounts</title>\n  </head>\n");

    Logger log = LogManager.getLogger("org.eaglei.repository.admin.users.jsp");

    // feedback message about status of any chosen operation
    String message = null;
    boolean messageSuccess = true;

    try {
        if (!Access.isSuperuser(request))
            throw new ForbiddenException("This page is only for use by administrators.");

        // MUST call this before getting any parameters
        request.setCharacterEncoding("UTF-8");
        String action = request.getParameter("action");
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String disable = request.getParameter("disable");
        String reinstate = request.getParameter("reinstate");

        if (action != null) {
            if (username == null || username.length() == 0)
                throw new BadRequestException("You must enter a username for this action.");

            // disable a user
            if (action.equals("disable")) {
                AuthUser au = AuthUser.find(username);
                if (au == null)
                    throw new NotFoundException("User not found in authentication database: "+username);
                Connection c = AuthUser.startTransaction();
                try {
                    au.delete(c);
                    AuthUser.commitTransaction(c);
                    c = null;
                    log.debug("Deleted authUser, username="+username);
                } finally {
                    if (c != null)
                        AuthUser.abortTransaction(c);
                }
                message = "Disabled user "+username;
                 
            } else {
                throw new BadRequestException("Unrecognized value of 'action' arg: \""+action+"\"");
            }
        }

      out.write("\n  <body bgcolor=lightyellow>\n    ");
      out.write('\n');
      out.write("\n\n<hr/>\n    <table border=\"0\" width=\"100%\" >\n      <tr>\n        <td width=\"30%\"><a href=\"http://www.eagle-i.org/\"><img border=\"0\" alt=\"Institutional Logo\" align=\"right\"\n               src=\"");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.logo", "/repository/images/eagle-i_admin_logo.png") );
      out.write("\" /></a>\n        </td>\n        <td width=\"40%\"><div align=\"center\">\n          <font size=\"+2\" color=\"black\">\n            Repository Administration Area\n          </font>\n          <p>");
      out.print( DataRepository.getInstance().getConfigurationProperty("eaglei.repository.title", "(Config property <tt>eaglei.repository.title</tt> needs to be set)") );
      out.write("</p>\n        </div></td>\n        <td width=\"30%\">&nbsp;</td>\n      </tr>\n    </table>\n<hr/>\n");
      out.write("\n    <h2>Manage User Accounts</h2>\n\n");

        if (message != null) {

      out.write("\n    <h3><font color=\"");
      out.print( messageSuccess ? "GREEN" : "RED" );
      out.write("\">\n          ");
      out.print( messageSuccess ? "Success" : "FAILED" );
      out.write(':');
      out.write(' ');
      out.print( StringEscapeUtils.escapeHtml(message) );
      out.write("\n          </font>\n    </h3>\n");

        }

      out.write("\n     <h3>&#x26ab; <a href=\"/repository/admin/editUserPortlet.jsp?standalone&amp;create_auth\">\n         Create a New User Account</a>\n     </h3>\n    <h3>&#x26ab; Manage Existing User Accounts</h3>\n    <!-- columns: username, personal name, enabled? -->\n    <div style=\"margin: 0px 0px 0px 30px;\">\n    <table border=\"1\">\n    <tr>\n      <th>Login</th>\n      <th>Personal Name</th>\n      <th>Action</th>\n    </tr>\n");

    Map<String,AuthUser> username2auth = AuthUser.findAllAsMap();
    RepositoryConnection rc = WithRepositoryConnection.get(request);
    Map<String,User> username2user = new HashMap<String,User>();

    for (User u : User.findAll(request)) {
        username2user.put(u.getUsername(), u);
    }
    for (String aname : username2auth.keySet()) {
        if (!username2user.containsKey(aname))
            username2user.put(aname, null);
    }
    Set<String> userSet = username2user.keySet();
    String users[] = userSet.toArray(new String[userSet.size()]);
    Arrays.sort(users);
    for (String uu : users) {
        String eu = Utils.urlEncode(uu);
        User u = username2user.get(uu);
        String pn = u == null ? "<i>Undocumented</i>" : u.getPersonalName();
 
      out.write("\n        <tr>\n          <td>\n            <a href=\"/repository/admin/editUserPortlet.jsp?standalone=true&username=");
      out.print( eu );
      out.write("\">\n                  <tt>");
      out.print( uu );
      out.write("</tt>\n            </a>\n          </td>\n          <td>");
      out.print( pn == null ? "" : pn );
      out.write("</td>\n          <!-- skull == unicode &#x2620; heart=&#x2661, solidheart 2665  -->\n          <td>");
      out.print(  username2auth.containsKey(uu) ?
                     "<a href=\"/repository/admin/users.jsp?action=disable&username="+eu+"\">&#x2620 Disable</a>" :
                     "<a href=\"/repository/admin/editUserPortlet.jsp?standalone=true&create_auth=true&username="+eu+"\">&#x2665 Reinstate</a>" );
      out.write("\n          </td>\n        </tr>\n");

    }

      out.write("\n    </table>\n    <i>Click on username to edit user's properties, change password, etc.</i>\n    </div>\n    <br/>\n    <br/>\n    <a href=\"/repository/admin/index.jsp\">Return to Admin top level</a>\n  </body>\n");

    // see "try" at start of body tag.
    } catch (ErrorSendingException e) {
        response.sendError(e.getStatus(), e.getMessage());
    }

      out.write("\n</html>\n");
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          try { out.clearBuffer(); } catch (java.io.IOException e) {}
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
