package org.eaglei.repository.format;

import java.io.OutputStream;

import org.openrdf.query.resultio.TupleQueryResultWriter;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriterFactory;

/**
 * Boilerplate for Sesame query result writer registry.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class SPARQLTextWriterFactory implements TupleQueryResultWriterFactory
{
    /**
     * <p>getTupleQueryResultFormat</p>
     *
     * @return a {@link org.openrdf.query.resultio.TupleQueryResultFormat} object.
     */
    public TupleQueryResultFormat getTupleQueryResultFormat()
    {
        return SPARQLTextWriter.FORMAT;
    }

    /** {@inheritDoc} */
    public TupleQueryResultWriter getWriter(OutputStream out)
    {
        return new SPARQLTextWriter(out);
    }
}
