package org.eaglei.repository.rid;

/**
 ***************************************************************************
 * RIDSequence (=RepostoryIDSequence)
 *
 * Class represents a preallocated list of sequence numbers that can be accessed
 * by the Iterator interface. Class saves memory since the IDs are not
 * preallocated but rather get created on next();
 *
 * @author Carsten Schulz
 * @version $Id: $
 */

import java.util.UUID;
import java.util.Iterator;
public class RIDSequence implements Iterator<UUID> {
        private long time;
        private long clockID; //long that has clockid already shifted into it
        private int start;
        private int amount;
        private int i=0;
        
        /**
         * <p>Constructor for RIDSequence.</p>
         *
         * @param timeValue a long.
         * @param clockIDValue a long.
         * @param startValue a int.
         * @param amountValue a int.
         */
        public RIDSequence (long timeValue, long clockIDValue, int startValue, int amountValue){
                time=timeValue;
                clockID=clockIDValue;
                start = startValue;
                amount= amountValue;
        }
        
        /**
         * <p>next</p>
         *
         * @return a {@link java.util.UUID} object.
         */
        public UUID next(){
                long least=composeLeast(clockID, i);
                ++i;
                return (new UUID(time, least));
        }
    private long composeLeast(long clock, int sequence){
        // clock already shifted....
        return (clock | (((long) sequence) & 0xffffffffl));
     }
        
        /**
         * <p>hasNext</p>
         *
         * @return a boolean.
         */
        public boolean hasNext(){
                return (i<amount);
        }
        
        /**
         * <p>remove</p>
         *
         * @throws java.lang.UnsupportedOperationException if any.
         */
        public void remove()throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
        }

}
