package org.eaglei.repository.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

import org.apache.log4j.Logger;
import org.apache.log4j.LogManager;
import org.openrdf.query.impl.DatasetImpl;

import org.openrdf.OpenRDFException;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Literal;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;

import org.eaglei.repository.Access;
import org.eaglei.repository.AccessGrant;
import org.eaglei.repository.View;
import org.eaglei.repository.NamedGraph;
import org.eaglei.repository.vocabulary.REPO;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.status.BadRequestException;

/**
 * Returns a listing of available named graphs.
 * Optional type param narrows it down to a given Named Graph Type.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class ListGraphs extends RepositoryServlet
{
    private static Logger log = LogManager.getLogger(ListGraphs.class);

    /** {@inheritDoc} */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        doGet(request, response);
    }

    /** {@inheritDoc} */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
        throws ServletException, java.io.IOException
    {
        request.setCharacterEncoding("UTF-8");
        String format = request.getParameter("format");
        NamedGraph.Type type = (NamedGraph.Type)Utils.parseKeywordArg(NamedGraph.Type.class,
                    request.getParameter("type"), "type", false, null);

        Collection<NamedGraph> ngs = NamedGraph.findAll(request);
        NamedGraph nga[] = ngs.toArray(new NamedGraph[ngs.size()]);
        Arrays.sort(nga);
        ArrayList<BindingSet> result = new ArrayList<BindingSet>();
        boolean superuser = Access.isSuperuser(request);
        for (NamedGraph ng : nga) {
            NamedGraph.Type ngt = ng.getType();
            if (type != null && !type.equals(ngt))
                continue;
            MapBindingSet nbs = new MapBindingSet(7);
            URI uri = ng.getName();
            nbs.addBinding("namedGraphURI", uri);
            nbs.addBinding("namedGraphLabel", new LiteralImpl(ng.getLabel()));
            if (ngt != null) {
                nbs.addBinding("typeURI", ngt.uri);
                nbs.addBinding("typeLabel", new LiteralImpl(ngt.getTitle()));
            }
            if (superuser) {
                nbs.addBinding("read", BooleanLiteralImpl.TRUE);
                nbs.addBinding("add", BooleanLiteralImpl.TRUE);
                nbs.addBinding("remove", BooleanLiteralImpl.TRUE);
            } else {
                Literal hasRead = BooleanLiteralImpl.FALSE;
                Literal hasRemove = BooleanLiteralImpl.FALSE;
                Literal hasAdd = BooleanLiteralImpl.FALSE;
                for (AccessGrant g : Access.getGrants(request, uri, true)) {
                    if (g.access.uri.equals(REPO.HAS_READ_ACCESS))
                        hasRead = BooleanLiteralImpl.TRUE;
                    else if (g.access.uri.equals(REPO.HAS_ADD_ACCESS))
                        hasAdd = BooleanLiteralImpl.TRUE;
                    else if (g.access.uri.equals(REPO.HAS_REMOVE_ACCESS))
                        hasRemove = BooleanLiteralImpl.TRUE;
                }
                nbs.addBinding("read", hasRead);
                nbs.addBinding("add", hasAdd);
                nbs.addBinding("remove", hasRemove);
            }
            result.add(nbs);
        }
        SPARQL.sendTupleQueryResults(request, response, format, result);
    }
}
