package org.eaglei.repository.vocabulary;

import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.URI;

import org.eaglei.model.EagleIOntConstants;
import org.eaglei.model.jena.JenaModelConfig;

/**
 * Constants related to the eagle-i Data Model Ontology
 * URIs of useful classes and properties.
 *
 * @author Larry Stone
 * @version $Id: $
 */
public class DATAMODEL
{
    /**
     * URI of Data Model Ontology, at least for naming Named Graph.
     * It includes too many Namespace Prefixes to isolate one.
     */
    public static final String GRAPH_NAME = "http://purl.obolibrary.org/obo/ero.owl";

    /** Constant <code>GRAPH_NAME_URI</code> - the URI form*/
    public static final URI GRAPH_NAME_URI = new URIImpl(GRAPH_NAME);

    /**
     * This is my namespace.
     * There are many like it in the data model, but this one is mine.
     */
    public static final String APP_ONT_NAMESPACE = EagleIOntConstants.EAGLE_I_APP_ONT_URI;

    /**
     * This is one of the many like it.
     */
    public static final String APP_EXT_NAMESPACE = JenaModelConfig.EAGLE_I_APP_EXT_URI;
    public static final URI APP_EXT_NAMESPACE_URI = new URIImpl(APP_EXT_NAMESPACE);

    /** Borrow the inPropertyGroup property name from ont model */
    public static final URI IN_PROPERTY_GROUP = new URIImpl(EagleIOntConstants.IN_PROPERTY_GROUP);

    /**
     * Property group that marks properties which are not to be shown in
     * repository dissemination views or put into search indexes.
     */
    public static final URI PROPERTY_GROUP_ADMIN_DATA = new URIImpl(APP_ONT_NAMESPACE+"PropertyGroup/adminData");

    /**
     * Property group that marks properties containing JUST email contact info
     */
    public static final URI PROPERTY_GROUP_EMAIL_CONTACT = new URIImpl(APP_ONT_NAMESPACE+"PropertyGroup_EmailContact");
    /**
     * Property group that marks properties containing ANY contact info
     * e.g. email address, phone, mailing addr, ICBM coordinates, etc.
     */
    public static final URI PROPERTY_GROUP_CONTACT_LOCATION = new URIImpl(APP_ONT_NAMESPACE+"PropertyGroup_ContactLocation");
}
