/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.AccessGrant;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.User;
import org.eaglei.repository.servlet.ImportExport;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.BadRequestException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Access {
    READ(REPO.HAS_READ_ACCESS),
    ADD(REPO.HAS_ADD_ACCESS),
    REMOVE(REPO.HAS_REMOVE_ACCESS),
    ADMIN(REPO.HAS_ADMIN_ACCESS);

    private URI uri = null;
    public static final String SUPERUSER_ROLE_NAME = "superuser";
    private static final String S_USER = "org.eaglei.repository.Access.User";
    private static final String S_REMOTE_IP = "org.eaglei.repository.Access.REMOTE_IP";
    private static String importGrantQuery;
    private static final String getGrantsQueryPrefix;
    private static final String getGrantsQuery;
    private static final String getMyGrantsQuery;
    private static final String getImportGrantsQuery = "SELECT DISTINCT ?subject WHERE { ?subject ?access ?agent }";
    private static final String hasPermissionQuery;
    private static DatasetImpl internalAccessGraphs;
    private static Logger log;
    private static final String allAccessesQuery;

    private Access(URI uri) {
        this.uri = uri;
    }

    public static boolean isAccessPredicate(URI uri) {
        for (Access a : Access.values()) {
            if (!a.uri.equals(uri)) continue;
            return true;
        }
        return false;
    }

    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return this.name().toUpperCase();
    }

    public static boolean hasPermission(HttpServletRequest request, Resource subject, Access pred) {
        if (Access.isSuperuser((HttpServletRequest)request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Superuser elides check: hasPermission(" + subject + ", " + pred + ") => true"));
            }
            return true;
        }
        try {
            URI pu = Access.getPrincipalURI((HttpServletRequest)request);
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            BooleanQuery q = rc.prepareBooleanQuery(QueryLanguage.SPARQL, hasPermissionQuery);
            q.setIncludeInferred(true);
            q.setDataset((Dataset)internalAccessGraphs);
            q.clearBindings();
            q.setBinding("user", (Value)pu);
            q.setBinding("access", (Value)pred.uri);
            q.setBinding("resource", (Value)subject);
            boolean result = q.evaluate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Access Query: user=" + pu + ", access=" + pred + ", query=\n" + hasPermissionQuery));
                log.debug((Object)("hasPermission(" + subject + ", " + pred + ", " + pu + ") => " + result));
            }
            return result;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    public static boolean hasPermissionOnUser(HttpServletRequest request, String username) {
        Principal p = request.getUserPrincipal();
        return Access.isSuperuser((HttpServletRequest)request) || username != null && p != null && username.equals(p.getName());
    }

    public static void filterByPermission(HttpServletRequest request, URI aprincipal, String name, String results, String patternGroup, Access pred, Dataset dataset, BindingSet bindings, TupleQueryResultHandler handler) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            URI principal = aprincipal == null ? Access.getPrincipalURI((HttpServletRequest)request) : aprincipal;
            String qs = Access.makeAccessQuery((String)name, (String)("SELECT " + results + " WHERE"), (String)patternGroup);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query in filterByPermission, name=" + name + ", query=\n  " + qs));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setIncludeInferred(true);
            q.setDataset(dataset);
            q.clearBindings();
            q.setBinding("user", (Value)principal);
            q.setBinding("access", (Value)pred.uri);
            if (bindings != null && bindings.size() > 0) {
                for (Binding b : bindings) {
                    q.setBinding(b.getName(), b.getValue());
                }
            }
            q.evaluate(handler);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in access check: ", (Throwable)e);
        }
    }

    public static URI getPrincipalURI(HttpServletRequest request) {
        User u = Access.getPrincipalUser((HttpServletRequest)request);
        if (u == null) {
            log.debug((Object)"getPrincipalURI: Returning :Anonymous for unauthenticated user.");
            return request.isUserInRole("superuser") ? REPO.ROLE_SUPERUSER : REPO.ROLE_ANONYMOUS;
        }
        return u.getURI();
    }

    public static void decacheAuthentication(HttpServletRequest request, User u) {
        HttpSession session = Access.getValidatedSession((HttpServletRequest)request);
        User cu = (User)session.getAttribute("org.eaglei.repository.Access.User");
        if (cu != null && cu.equals((Object)u)) {
            session.removeAttribute("org.eaglei.repository.Access.User");
            log.debug((Object)"Decached authenticated user from Session.");
            Access.logout((HttpServletRequest)request);
        }
    }

    public static String getAuthenticatedUsername(HttpServletRequest request) {
        Principal p = request.getUserPrincipal();
        return p == null ? null : p.getName();
    }

    public static User getPrincipalUser(HttpServletRequest request) {
        User result = (User)request.getAttribute("org.eaglei.repository.Access.User");
        if (result != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning Request-cached user = " + result));
            }
            return result;
        }
        Principal p = request.getUserPrincipal();
        if (p == null) {
            return null;
        }
        String pname = p.getName();
        String anonUser = DataRepository.getInstance().getConfigurationProperty("eaglei.repository.anonymous.user");
        if (anonUser != null && anonUser.equals(pname)) {
            log.info((Object)("Anonymous login because of configured anonymous user: " + pname));
            return null;
        }
        HttpSession session = Access.getValidatedSession((HttpServletRequest)request);
        if (DataRepository.getInstance().isSessionStale(session)) {
            session.removeAttribute("org.eaglei.repository.Access.User");
            log.debug((Object)("Invalidating cached user URI in stale session, principal=" + pname));
        } else {
            result = (User)session.getAttribute("org.eaglei.repository.Access.User");
            if (result != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Returning cached user for principal=" + pname + " from session context: " + result));
                }
                request.setAttribute("org.eaglei.repository.Access.User", (Object)result);
                return result;
            }
        }
        try {
            User u = User.findByUsername((HttpServletRequest)request, (String)pname);
            if (u != null) {
                if (request.isUserInRole("superuser") && !u.isSuperuser()) {
                    u.setIsSuperuser(true);
                }
                session.setAttribute("org.eaglei.repository.Access.User", (Object)u);
                request.setAttribute("org.eaglei.repository.Access.User", (Object)u);
            }
            return u;
        }
        catch (ServletException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isSuperuser(HttpServletRequest request) {
        User u = Access.getPrincipalUser((HttpServletRequest)request);
        if (u == null) {
            return request.isUserInRole("superuser");
        }
        return u.isSuperuser();
    }

    private static HttpSession getValidatedSession(HttpServletRequest request) {
        HttpSession result = request.getSession(false);
        String remoteIP = request.getRemoteAddr();
        if (result == null) {
            result = request.getSession(true);
            result.setAttribute("org.eaglei.repository.Access.REMOTE_IP", (Object)remoteIP);
        } else {
            String testIP = (String)result.getAttribute("org.eaglei.repository.Access.REMOTE_IP");
            if (testIP == null) {
                log.debug((Object)("Initializing session's record of remote address, IP=" + remoteIP));
                result.setAttribute("org.eaglei.repository.Access.REMOTE_IP", (Object)remoteIP);
            } else if (!testIP.equals(remoteIP)) {
                log.error((Object)("POSSIBLE SESSION HIJACKING: session created by IP=" + testIP + ", but is being accessed by IP=" + remoteIP));
                throw new BadRequestException("Authentication denied, this session may only be accessed from the address that created it. Please login again.");
            }
        }
        return result;
    }

    public static void logout(HttpServletRequest request) {
        HttpSession s = request.getSession(false);
        if (s == null) {
            log.debug((Object)"Logout finds no session to destroy!");
        } else {
            s.invalidate();
            log.debug((Object)("Logout is destroying session ID=" + s.getId()));
        }
    }

    private static String makeAccessQuery(String resourceName, String prologue, String patternGroup) {
        StringBuilder result = new StringBuilder();
        result.append(prologue).append(" { ");
        if (patternGroup != null) {
            result.append(patternGroup);
        }
        result.append("{ { ?user <").append(REPO.HAS_ROLE).append("> ?r . ?").append(resourceName).append(" ?access ?r }\n");
        result.append(" UNION { ?").append(resourceName).append(" ?access ?user } } }");
        return result.toString();
    }

    public static boolean removeGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (Access.hasPermission((HttpServletRequest)request, (Resource)instance, (Access)ADMIN)) {
            return Access.removeGrantAsAdministrator((HttpServletRequest)request, (URI)instance, (URI)agent, (URI)access);
        }
        throw new ForbiddenException("You are not allowed to change access controls on " + instance);
    }

    public static boolean removeGrantAsAdministrator(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (instance == null || access == null || agent == null) {
            throw new BadRequestException("removeGrant called with an illegal null URI.");
        }
        if (Access.isAccessPredicate((URI)access)) {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            try {
                if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) {
                    rc.remove((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
                    return true;
                }
                return false;
            }
            catch (OpenRDFException e) {
                log.error((Object)e);
                throw new InternalServerErrorException("Failed in remove ACL: ", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("Access URI is not a valid access predicate: " + access.stringValue());
    }

    public static void addGrant(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (!Access.hasPermission((HttpServletRequest)request, (Resource)instance, (Access)ADMIN)) {
            throw new ForbiddenException("You are not allowed to change access controls on " + instance);
        }
        Access.addGrantAsAdministrator((HttpServletRequest)request, (URI)instance, (URI)agent, (URI)access);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGrantAsAdministrator(HttpServletRequest request, URI instance, URI agent, URI access) {
        if (!Access.isAccessPredicate((URI)access)) throw new IllegalArgumentException("Access URI is not a valid access predicate: " + access.stringValue());
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            if (rc.hasStatement((Resource)instance, access, (Value)agent, false, new Resource[]{REPO.NG_INTERNAL})) return;
            rc.add((Resource)instance, access, (Value)agent, new Resource[]{REPO.NG_INTERNAL});
            return;
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in add ACL: ", (Throwable)e);
        }
    }

    public static Iterable<AccessGrant> getGrants(HttpServletRequest request, URI uri) {
        return Access.getGrantsInternal((HttpServletRequest)request, (RepositoryConnection)WithRepositoryConnection.get((ServletRequest)request), (URI)uri, (boolean)false);
    }

    public static Iterable<AccessGrant> getGrants(RepositoryConnection rc, URI uri) {
        return Access.getGrantsInternal(null, (RepositoryConnection)rc, (URI)uri, (boolean)false);
    }

    public static Iterable<AccessGrant> getMyGrants(HttpServletRequest request, URI uri) {
        return Access.getGrantsInternal((HttpServletRequest)request, (RepositoryConnection)WithRepositoryConnection.get((ServletRequest)request), (URI)uri, (boolean)true);
    }

    private static Iterable<AccessGrant> getGrantsInternal(HttpServletRequest request, RepositoryConnection rc, URI uri, boolean mine) {
        try {
            String qs;
            String string = qs = mine ? getMyGrantsQuery : getGrantsQuery;
            if (log.isDebugEnabled()) {
                log.debug((Object)("SPARQL query to get " + (mine ? "MY (" + Access.getPrincipalURI((HttpServletRequest)request).stringValue() + ")" : "") + "grants, instance=" + uri.stringValue() + ", query=\n" + qs));
            }
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, qs);
            q.setBinding("instance", (Value)uri);
            if (mine) {
                if (request == null) {
                    throw new IllegalArgumentException("Cannot get grants for current user when request is null.");
                }
                q.setBinding("user", (Value)Access.getPrincipalURI((HttpServletRequest)request));
            }
            q.setDataset((Dataset)internalAccessGraphs);
            grantHandler h = new grantHandler();
            q.evaluate((TupleQueryResultHandler)h);
            return grantHandler.access$000((grantHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public static Iterable<Statement> exportGrants(URI uri, Iterable<AccessGrant> grants) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (AccessGrant g : grants) {
            result.add((Statement)new ContextStatementImpl((Resource)uri, g.access.uri, (Value)g.agent.uri, (Resource)REPO.NG_INTERNAL));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<Statement> importGrants(HttpServletRequest request, RepositoryConnection content, URI oldURI, URI newURI) {
        try {
            if (importGrantQuery == null) {
                StringBuilder igq = new StringBuilder("SELECT ?p ?o WHERE {?s ?p ?o FILTER(");
                RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
                TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT * WHERE { ?accessPred <" + RDFS.SUBPROPERTYOF + "> <" + REPO.HAS_ANY_ACCESS + ">}");
                q.setDataset((Dataset)internalAccessGraphs);
                TupleQueryResult qr = null;
                try {
                    qr = q.evaluate();
                    boolean first = true;
                    while (qr.hasNext()) {
                        String ap = ((BindingSet)qr.next()).getValue("accessPred").stringValue();
                        if (first) {
                            first = false;
                        } else {
                            igq.append(" || ");
                        }
                        igq.append("?p = <").append(ap).append(">");
                    }
                    igq.append(")}");
                    importGrantQuery = igq.toString();
                    log.debug((Object)("Generating fixed Access Import query: \"" + importGrantQuery + "\""));
                }
                finally {
                    if (qr != null) {
                        qr.close();
                    }
                }
            }
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, importGrantQuery);
            q.setDataset((Dataset)internalAccessGraphs);
            q.setBinding("s", (Value)oldURI);
            TupleQueryResult qr = null;
            ArrayList<Statement> result = new ArrayList<Statement>();
            try {
                qr = q.evaluate();
                while (qr.hasNext()) {
                    BindingSet bs = (BindingSet)qr.next();
                    result.add((Statement)new ContextStatementImpl((Resource)newURI, (URI)bs.getValue("p"), bs.getValue("o"), (Resource)REPO.NG_INTERNAL));
                }
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
            log.debug((Object)("importGrants(" + oldURI.stringValue() + "): returning " + result.size() + " grant statements."));
            return result;
        }
        catch (OpenRDFException e) {
            log.error((Object)"Failed in one of the Import Grant queries: ", (Throwable)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public static Iterable<AccessGrant.Term> getAllAccesses(HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAllAccesses query = " + allAccessesQuery));
        }
        return Access.getAllTermsInternal((HttpServletRequest)request, (String)allAccessesQuery);
    }

    private static Iterable<AccessGrant.Term> getAllTermsInternal(HttpServletRequest request, String query) {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, query);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            termHandler h = new termHandler(null);
            q.evaluate((TupleQueryResultHandler)h);
            return termHandler.access$200((termHandler)h);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException("Failed in query: ", (Throwable)e);
        }
    }

    public static void doExportGrants(HttpServletRequest request, HttpServletResponse response, RDFFormat format, Set<String> includes, Set<String> excludes) throws ServletException, IOException {
        try {
            RDFWriter out = Rio.createWriter((RDFFormat)format, (Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
            out.startRDF();
            if (includes.isEmpty()) {
                throw new BadRequestException("Export of grants requires an include list of URIs");
            }
            if (!excludes.isEmpty()) {
                throw new BadRequestException("Export of grants does not support an exclude list");
            }
            for (String iu : includes) {
                URIImpl uri = new URIImpl(iu);
                for (Statement s : Access.exportGrants((URI)uri, (Iterable)Access.getGrants((HttpServletRequest)request, (URI)uri))) {
                    out.handleStatement(s);
                }
            }
            out.endRDF();
        }
        catch (OpenRDFException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doImportGrants(HttpServletRequest request, HttpServletResponse response, RepositoryConnection content, Set<String> includes, Set<String> excludes, ImportExport.DuplicateArg duplicate, boolean transform, boolean ignoreACL) throws ServletException, IOException {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            log.debug((Object)"SPARQL query on imported GRANT statements: \n  SELECT DISTINCT ?subject WHERE { ?subject ?access ?agent }");
            TupleQuery q = content.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT DISTINCT ?subject WHERE { ?subject ?access ?agent }");
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            TupleQueryResult qr = null;
            try {
                qr = q.evaluate();
                while (qr.hasNext()) {
                    BindingSet bs = (BindingSet)qr.next();
                    URI uri = (URI)bs.getValue("subject");
                    String us = uri.stringValue();
                    if (excludes.contains(us)) {
                        log.debug((Object)("SKIP IMPORT GRANT because of exclude: uri=" + us));
                        continue;
                    }
                    if (!includes.isEmpty() && !includes.contains(us)) {
                        log.debug((Object)("SKIP IMPORT GRANT because of include: uri=" + us));
                        continue;
                    }
                    for (Statement s : Access.importGrants((HttpServletRequest)request, (RepositoryConnection)content, (URI)uri, (URI)uri)) {
                        log.debug((Object)("Adding access grant statement: " + s));
                        rc.add(s, new Resource[]{REPO.NG_INTERNAL});
                    }
                }
            }
            finally {
                if (qr != null) {
                    qr.close();
                }
            }
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new ServletException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }

    static {
        importGrantQuery = null;
        getGrantsQueryPrefix = "SELECT DISTINCT * WHERE { \nGRAPH <" + REPO.NG_INTERNAL + "> { ?instance ?access ?agent } . \n" + "?access <" + RDFS.SUBPROPERTYOF + "> <" + REPO.HAS_ANY_ACCESS + "> \n" + "OPTIONAL { ?access <" + RDFS.LABEL + "> ?accessLabel }\n" + "OPTIONAL { ?agent <" + RDFS.LABEL + "> ?agentLabel }\n" + "OPTIONAL { {{?agent <" + RDF.TYPE + "> ?agentType} UNION {?agent <" + RDFS.SUBCLASSOF + "> ?agentType}}\n" + "  FILTER (?agentType = <" + REPO.ROLE + "> || ?agentType = <" + REPO.PERSON + ">) \n" + "  OPTIONAL { ?agentType <" + RDFS.LABEL + "> ?agentTypeLabel }}\n";
        getGrantsQuery = getGrantsQueryPrefix + "}";
        getMyGrantsQuery = getGrantsQueryPrefix + "{{?user <" + REPO.HAS_ROLE + "> ?agent} UNION {?instance ?access ?user}}}";
        hasPermissionQuery = Access.makeAccessQuery((String)"resource", (String)"ASK", null);
        internalAccessGraphs = SPARQL.copyDataset((Dataset)SPARQL.InternalGraphs);
        internalAccessGraphs.addDefaultGraph(REPO.NG_USERS);
        log = LogManager.getLogger(Access.class);
        allAccessesQuery = "SELECT DISTINCT * WHERE { ?uri <" + RDFS.SUBPROPERTYOF + "> <" + REPO.HAS_ANY_ACCESS + "> \n" + " OPTIONAL { ?uri <" + RDFS.LABEL + "> ?label }}";
    }
}

