/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.HasContentCache;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.inferencer.MinimalInferencer;
import org.eaglei.repository.util.Utils;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.Sail;
import org.openrdf.sail.nativerdf.NativeStore;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataRepository {
    private static Logger log = LogManager.getLogger(DataRepository.class);
    private static final String REPO_ROOT = "org.eaglei.repository";
    private static final String OPENRDF_ROOT = "org.openrdf";
    private static final String SVN_BRANCHES_PREFIX = "branches/";
    private static final String SVN_TAGS_PREFIX = "tags/";
    public static final String AUTH_DB_NAME = "eagle-i-users.derby";
    private static final String SCTX_REPOSITORY = "org.eaglei.repository.SesameRepository";
    private static final String SCTX_GENERATION = "org.eaglei.repository.Generation";
    private static final String CONFIG_NAMESPACE = "eaglei.repository.namespace";
    private static final String CONFIG_LOGDIR = "eaglei.repository.log.dir";
    private static final String CONFIG_SESAMEDIR = "eaglei.repository.sesame.dir";
    private static final String CONFIG_SESAMEINDEXES = "eaglei.repository.sesame.indexes";
    public static final String CONFIG_TITLE = "eaglei.repository.title";
    public static final String CONFIG_INSTANCE_XSLT = "eaglei.repository.instance.xslt";
    public static final String CONFIG_INSTANCE_CSS = "eaglei.repository.instance.css";
    public static final String CONFIG_INSTANCE_JS = "eaglei.repository.instance.js";
    private static final String REPO_HOME = "org.eaglei.repository.home";
    private static final String BACKUP_HOME = "org.eaglei.repository.backup";
    private static final Map<URI, String> graphInitFile = new HashMap();
    public static final URI[] UPGRADEABLE_GRAPHS;
    public static final Date STARTUP;
    private ServletContext servletContext = null;
    private String defaultNamespace = null;
    private PropertiesConfiguration configuration = null;
    private Properties buildProperties = null;
    private Date lastModified = new Date();
    private static DataRepository instance;

    public static DataRepository getInstance() {
        return instance;
    }

    private static void printError(String msg) {
        System.err.println("***ERROR*** (at " + new Date().toString() + ") eagle-i DataRepository: " + msg);
    }

    private static void printInfo(String msg) {
        System.err.println("***INFO*** (at " + new Date().toString() + ") eagle-i DataRepository: " + msg);
    }

    public static void initialize(ServletContext sc) {
        if (instance == null) {
            try {
                instance = new DataRepository(sc);
                instance.finishInitialize();
            }
            catch (Exception e) {
                DataRepository.printError((String)("Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:" + e.toString()));
                log.fatal((Object)"Got exception in Webapp context initialization, DO NOT EXPECT ANYTHING TO WORK NOW:", (Throwable)e);
            }
        } else {
            log.fatal((Object)"Initialize was called after DataRepository already initialized!");
        }
    }

    public DataRepository(ServletContext sc) {
        this.servletContext = sc;
    }

    public void finishInitialize() throws IOException, OpenRDFException {
        File sesDir;
        File pf;
        File home = this.getHomeDirectory();
        DataRepository.printInfo((String)("Configuring with Eagle-I Repository Home dir = " + home.toString()));
        if (!home.exists()) {
            if (!home.mkdirs()) {
                DataRepository.printError((String)("Failed to create repository home directory, configured path = " + home));
                DataRepository.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
            }
        } else if (!home.isDirectory()) {
            DataRepository.printError((String)("Path configured as repository home is not a directory: " + home));
            DataRepository.printError((String)"THIS WILL CAUSE MANY OTHER ERRORS, DO NOT EXPECT THE REPOSITORY TO WORK!");
        }
        if (!(pf = new File(home, "configuration.properties")).exists()) {
            try {
                Utils.copyStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("default.configuration.properties"), (OutputStream)new FileOutputStream(pf));
            }
            catch (IOException e) {
                try {
                    pf.delete();
                }
                catch (Exception ee) {
                    // empty catch block
                }
                DataRepository.printError((String)("Failed to copy default configuration file to repository home dir: " + e));
            }
        }
        try {
            log.debug((Object)("Loading configuration from file=" + pf));
            this.configuration = new PropertiesConfiguration();
            this.configuration.setListDelimiter('\u0000');
            this.configuration.load(pf);
        }
        catch (Exception e) {
            DataRepository.printError((String)("Failed to read configuration, file=" + pf + ": " + e.toString()));
        }
        Properties lp = new Properties();
        Iterator pi = this.configuration.getKeys("log4j");
        while (pi.hasNext()) {
            String k = (String)pi.next();
            lp.setProperty(k, this.configuration.getString(k));
        }
        this.setupDefaultLogging(home, lp);
        String sesPath = this.configuration.getString("eaglei.repository.sesame.dir");
        File file = sesDir = sesPath == null ? new File(home, "sesame") : new File(sesPath);
        if (!sesDir.exists()) {
            sesDir.mkdirs();
        }
        String indexes = this.configuration.getString("eaglei.repository.sesame.indexes");
        NativeStore ns = new NativeStore(sesDir);
        SailRepository r = new SailRepository((Sail)new MinimalInferencer((NotifyingSail)ns));
        if (indexes != null) {
            ns.setTripleIndexes(indexes);
        }
        r.initialize();
        if (!r.isWritable()) {
            log.fatal((Object)"Sesame repo is not writable, this is going to cause trouble soon!");
        }
        this.servletContext.setAttribute("org.eaglei.repository.SesameRepository", (Object)r);
        log.info((Object)("Sesame Repository open, directory=" + sesDir.toString()));
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)1);
        log.debug((Object)"Generation initialized to 1.");
        for (URI key : graphInitFile.keySet()) {
            this.loadGraphFromInit((Repository)r, key, true);
        }
    }

    public void destroy(ServletContext sc) throws RepositoryException {
        Repository r = (Repository)sc.getAttribute("org.eaglei.repository.SesameRepository");
        sc.removeAttribute("org.eaglei.repository.SesameRepository");
        if (r != null) {
            r.shutDown();
            log.info((Object)"Sesame Repository closed.");
        }
        instance = null;
    }

    private void setPropertyUnlessOverride(Properties lp, String key, String value) {
        if (!lp.containsKey(key)) {
            lp.setProperty(key, value);
        }
    }

    private void setupDefaultLogging(File home, Properties lp) throws IOException {
        String logPath = this.configuration.getString("eaglei.repository.log.dir");
        File logDir = logPath == null ? new File(home, "logs") : new File(logPath);
        DataRepository.printInfo((String)("Set up default log4j config: logfile directory: " + logDir.toString()));
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        Logger repoRoot = LogManager.getLogger((String)"org.eaglei.repository");
        DataRepository.printInfo((String)("Got " + String.valueOf(lp.size()) + " initial log4j properties from repo configuration."));
        this.setPropertyUnlessOverride(lp, "log4j.logger.org.eaglei.repository", "INFO, repository");
        this.setPropertyUnlessOverride(lp, "log4j.additivity.org.eaglei.repository", "false");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository", RollingFileAppender.class.getName());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.File", new File(logDir, "repository.log").toString());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.ImmediateFlush", "false");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.BufferedIO", "true");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.Append", "true");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.Encoding", "UTF-8");
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.layout", PatternLayout.class.getName());
        this.setPropertyUnlessOverride(lp, "log4j.appender.repository.layout.ConversionPattern", "%d{ISO8601} T=%t %p %c - %m%n");
        this.setPropertyUnlessOverride(lp, "log4j.logger.org.openrdf", "WARN, repository");
        DataRepository.printInfo((String)("Configuring log4j with properties: " + lp.toString()));
        PropertyConfigurator.configure((Properties)lp);
        Enumeration rae = repoRoot.getAllAppenders();
        if (!rae.hasMoreElements()) {
            DataRepository.printError((String)"The org.eaglei.repository logger has no appenders!  This may result in no log records. Check your log4j configuration properties.");
        }
        while (rae.hasMoreElements()) {
            AppenderSkeleton ra = (AppenderSkeleton)rae.nextElement();
            DataRepository.printInfo((String)("Activating log4j appender \"" + ra.getName() + "\" for logger " + "org.eaglei.repository"));
            ra.activateOptions();
        }
        log.debug((Object)("logger " + repoRoot.getName() + " additivity=" + repoRoot.getAdditivity()));
    }

    public static String getInitFileVersion(URI uri) throws IOException, RDFParseException, RDFHandlerException {
        String resourcePath = (String)graphInitFile.get(uri);
        if (resourcePath != null) {
            RDFParser parser = Rio.createParser((RDFFormat)RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3));
            VersionFinder vf = new VersionFinder(uri, null);
            parser.setRDFHandler((RDFHandler)vf);
            parser.parse((Reader)new InputStreamReader(DataRepository.class.getClassLoader().getResourceAsStream(resourcePath), "UTF-8"), "");
            return VersionFinder.access$100((VersionFinder)vf);
        }
        log.warn((Object)("No resource path found for uri=" + uri));
        return null;
    }

    public static String getGraphInitFile(URI uri) {
        return (String)graphInitFile.get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGraphFromInit(Repository r, URI graphURI, boolean ifEmpty) throws RepositoryException, IOException, RDFParseException {
        RepositoryConnection rc = null;
        try {
            rc = r.getConnection();
            this.loadGraphFromInit(rc, graphURI, ifEmpty);
        }
        finally {
            if (rc != null) {
                rc.close();
            }
        }
    }

    public void loadGraphFromInit(RepositoryConnection rc, URI graphURI, boolean ifEmpty) throws RepositoryException, IOException, RDFParseException {
        if (!ifEmpty || rc.size(new Resource[]{graphURI}) == 0L) {
            String resourcePath = (String)graphInitFile.get(graphURI);
            if (resourcePath == null) {
                log.error((Object)("No local resource path found (NOT loading anything) for URI=" + graphURI));
                return;
            }
            URL rurl = this.getClass().getClassLoader().getResource(resourcePath);
            if (rurl == null) {
                log.error((Object)("Cannot find webapp resource at path=" + resourcePath));
            } else {
                URLConnection ruc = rurl.openConnection();
                long rdate = ruc.getLastModified();
                log.debug((Object)("Loading graph=" + graphURI.toString() + " from URL=" + rurl.toString() + ", mod-date=" + rdate));
                InputStreamReader is = new InputStreamReader(ruc.getInputStream(), "UTF-8");
                if (is == null) {
                    log.error((Object)("Cannot open webapp resource at url=" + rurl));
                } else {
                    rc.add((Reader)is, graphURI.toString(), RDFFormat.forFileName((String)resourcePath, (RDFFormat)RDFFormat.N3), new Resource[]{graphURI});
                    Provenance gp = new Provenance(graphURI);
                    gp.setProvenance(rc, DCTERMS.CREATED, (Value)Provenance.getDateTime((Date)new Date()));
                    gp.setProvenance(rc, DCTERMS.CREATOR, (Value)REPO.ROLE_SUPERUSER);
                    gp.setSource(rc, (Value)rc.getValueFactory().createURI(rurl.toString()), (Value)Provenance.getDateTime((Date)new Date(rdate)));
                    rc.commit();
                    log.info((Object)("Initialized the empty named graph, name=" + graphURI + ", from resource path=" + resourcePath));
                }
            }
        }
    }

    public Repository getSesameRepository() throws ServletException {
        Repository result = (Repository)this.servletContext.getAttribute("org.eaglei.repository.SesameRepository");
        if (result == null) {
            throw new ServletException("No RDF database connection, probably because of a failure in initialization.");
        }
        return result;
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            String cfg = this.configuration.getString("eaglei.repository.namespace");
            if (cfg != null) {
                log.debug((Object)("Got raw configured default namespace=" + cfg));
                try {
                    java.net.URI juri = new java.net.URI(cfg);
                    if (!juri.isAbsolute()) {
                        log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                    } else if (juri.getPath() == null) {
                        log.error((Object)("The configured namespace prefix must include a path ending with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else if (!juri.getPath().endsWith("/")) {
                        log.error((Object)("The configured namespace prefix must end with a slash ('/'): eaglei.repository.namespace = " + cfg));
                    } else {
                        String scheme = juri.getScheme();
                        if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https")) {
                            this.defaultNamespace = cfg;
                        } else {
                            log.error((Object)("The configured namespace prefix must be an absolute URI: eaglei.repository.namespace = " + cfg));
                        }
                    }
                }
                catch (URISyntaxException e) {
                    log.error((Object)("The configured namespace prefix has illegal URI syntax: eaglei.repository.namespace = " + cfg + ": " + e));
                }
            }
            if (this.defaultNamespace == null) {
                try {
                    this.defaultNamespace = "http://" + InetAddress.getLocalHost().getHostName() + "/i/";
                }
                catch (UnknownHostException e) {
                    log.error((Object)"Failed to get hostname for default URI prefix", (Throwable)e);
                    this.defaultNamespace = "http://failed-to-get-local-host-name/i/";
                }
                if (cfg == null) {
                    log.warn((Object)"Default Namespace Prefix URI not configured.  You really should set a configuration value for eaglei.repository.namespace");
                }
                log.warn((Object)("Using emergency default for namespace prefix URI (probably wrong) = " + this.defaultNamespace));
            }
        }
        return this.defaultNamespace;
    }

    public String getConfigurationProperty(String key) {
        return this.configuration.getString(key);
    }

    public String getConfigurationProperty(String key, String dflt) {
        String result = this.configuration.getString(key);
        return result == null ? dflt : result;
    }

    public String[] getConfigurationPropertyArray(String key, String[] dfault) {
        return this.configuration.containsKey(key) ? this.configuration.getString(key).split("\\s*,\\s*") : dfault;
    }

    public void notifyDataReplaced() {
        this.incrementGeneration();
        DataRepository.decacheAll();
    }

    private void incrementGeneration() {
        int gen = 1 + (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        this.servletContext.setAttribute("org.eaglei.repository.Generation", (Object)gen);
        log.debug((Object)("Generation is incremented to " + gen));
    }

    public boolean isSessionStale(HttpSession session) {
        Integer sessionGen = (Integer)session.getAttribute("org.eaglei.repository.Generation");
        Integer ctxGen = (Integer)this.servletContext.getAttribute("org.eaglei.repository.Generation");
        boolean result = sessionGen != null && sessionGen < ctxGen;
        session.setAttribute("org.eaglei.repository.Generation", (Object)ctxGen);
        return result;
    }

    public Reader getWebappResourceAsReader(String path) throws ServletException {
        if (this.servletContext == null) {
            log.error((Object)"getWebappResourceAsStream: currentContext not set!");
            return null;
        }
        try {
            return new InputStreamReader(this.servletContext.getResourceAsStream(path), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException("Unsupported encoding content-type spec: " + e);
        }
        catch (IllegalCharsetNameException e) {
            throw new ServletException("Illegal character set name in content-type spec: " + e);
        }
        catch (UnsupportedCharsetException e) {
            throw new ServletException("Unsupported character set name in content-type spec: " + e);
        }
    }

    public String getProjectVersion() {
        return this.getBuildProperties().getProperty("version");
    }

    public String getRevision() {
        return this.getBuildProperties().getProperty("revision");
    }

    public String getBranch() {
        String branch = this.getBuildProperties().getProperty("branch");
        if (branch == null) {
            log.warn((Object)"Cannot find build property \"branch\".");
            return null;
        }
        if (branch.startsWith("branches/")) {
            int nextSlash = branch.indexOf(47, "branches/".length());
            return nextSlash < 0 ? branch.substring(9) : branch.substring(9, nextSlash);
        }
        if (branch.startsWith("tags/")) {
            int nextSlash = branch.indexOf(47, "tags/".length());
            return nextSlash < 0 ? branch.substring(5) : branch.substring(5, nextSlash);
        }
        if (!branch.equals("trunk") && !branch.startsWith("${")) {
            log.warn((Object)("Build property \"branch\" has unexpected value: \"" + branch + "\""));
        }
        return null;
    }

    public String getTimestamp() {
        return this.getBuildProperties().getProperty("timestamp");
    }

    private Properties getBuildProperties() {
        if (this.buildProperties == null) {
            this.buildProperties = new Properties();
            try {
                this.buildProperties.load(this.getClass().getClassLoader().getResourceAsStream("build.properties"));
            }
            catch (IOException e) {
                log.error((Object)"Failed loading build.properties: ", (Throwable)e);
            }
        }
        return this.buildProperties;
    }

    public File getHomeDirectory() throws IOException {
        String home = System.getProperty("org.eaglei.repository.home");
        File result = null;
        boolean haveSysProp = home != null;
        result = !haveSysProp ? new File(System.getProperty("user.home"), "eaglei" + File.separator + "repository") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("repository home directory = " + result.toString()));
        if (!haveSysProp) {
            System.setProperty("org.eaglei.repository.home", result.toString());
        }
        return result;
    }

    public File getBackupDirectory() throws IOException {
        String home = System.getProperty("org.eaglei.repository.backup");
        File result = null;
        boolean haveProp = home != null;
        result = !haveProp ? new File(this.getHomeDirectory(), "backup") : new File(home);
        if (!result.exists() && !result.mkdirs()) {
            log.fatal((Object)("The configured home directory does not exist: " + result.toString()));
            throw new IOException("The configured home directory does not exist: " + result.toString());
        }
        if (!result.isDirectory()) {
            log.fatal((Object)("The configured home directory is not a directory or is protected: " + result.toString()));
            throw new IOException("The configured home directory is not a directory or is protected: " + result.toString());
        }
        log.debug((Object)("backup home directory = " + result.toString()));
        if (!haveProp) {
            System.setProperty("org.eaglei.repository.backup", result.toString());
        }
        return result;
    }

    public synchronized void setLastModified(Date lm) {
        if (this.lastModified.before(lm)) {
            this.lastModified = lm;
        }
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public String getSesameVersion() throws IOException {
        String result = null;
        Package rcp = RepositoryConnection.class.getPackage();
        if (rcp == null) {
            log.debug((Object)("Cannot get Sesame version from package, no package for class " + RepositoryConnection.class.getName()));
        } else {
            result = rcp.getImplementationVersion();
            if (result == null) {
                log.debug((Object)("Cannot get Sesame version, package has no ImplementationVersion: " + rcp.getName()));
            } else {
                return result;
            }
        }
        String classRes = "/" + RepositoryConnection.class.getName().replace('.', '/') + ".class";
        URL rurl = RepositoryConnection.class.getResource(classRes);
        if (rurl == null) {
            log.warn((Object)("Failed to find Sesame class resource path=" + classRes));
        } else {
            log.debug((Object)("Got sesame class resource URL =" + rurl));
            String surl = rurl.toString();
            if (surl.startsWith("jar:")) {
                Pattern ep = Pattern.compile("jar:([^!]+)!.*");
                log.debug((Object)("Groveling jar URL with pattern=\"" + ep.pattern() + "\""));
                Matcher em = ep.matcher(surl);
                if (em.matches()) {
                    String jarURLspec = em.group(1);
                    log.debug((Object)("Got jar URL = " + jarURLspec));
                    result = Utils.getMavenVersionFromJar((String)jarURLspec);
                    if (result != null) {
                        return result;
                    }
                } else {
                    log.warn((Object)("Failed matching jar URL regex on Sesame class URL; pattern=\"" + ep.pattern() + "\" against owl resource URL=" + surl));
                }
            } else {
                log.warn((Object)("Sesame Class Resource URL is NOT in Jar scheme: " + surl));
            }
        }
        return "(unknown)";
    }

    public static void decacheAll() {
        log.info((Object)"Decaching all content caches..");
        Reflections r = new Reflections("org.eaglei.repository", new Scanner[0]);
        for (Class c : r.getTypesAnnotatedWith(HasContentCache.class)) {
            log.debug((Object)("  Decaching " + c.getName()));
            try {
                c.getMethod("decache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("Class is marked as content cacher but has no static decache() method - " + c.getName() + ": " + e));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Failed calling decache() on content cacher class=" + c.getName() + ": " + e));
            }
            catch (InvocationTargetException e) {
                log.error((Object)("Failed calling decache() on content cacher class=" + c.getName() + ": " + e));
            }
        }
    }

    static {
        graphInitFile.put(REPO.NAMESPACE_URI, "repository-ont.n3");
        graphInitFile.put(REPO.NG_INTERNAL, "repository-internal.n3");
        graphInitFile.put(REPO.NG_QUERY, "query-macros.n3");
        UPGRADEABLE_GRAPHS = new URI[]{REPO.NAMESPACE_URI, REPO.NG_QUERY};
        STARTUP = new Date();
        instance = null;
    }
}

