/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.repository;

import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eaglei.repository.Access;
import org.eaglei.repository.DataRepository;
import org.eaglei.repository.Provenance;
import org.eaglei.repository.rid.RIDGenerator;
import org.eaglei.repository.servlet.WithRepositoryConnection;
import org.eaglei.repository.status.ConflictException;
import org.eaglei.repository.status.ForbiddenException;
import org.eaglei.repository.status.InternalServerErrorException;
import org.eaglei.repository.util.SPARQL;
import org.eaglei.repository.vocabulary.DCTERMS;
import org.eaglei.repository.vocabulary.REPO;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class EditToken
extends TupleQueryResultHandlerBase {
    private static Logger log = LogManager.getLogger(EditToken.class);
    private URI resource = null;
    private URI uri = null;
    private URI creator = null;
    private String creatorLabel = null;
    private String created = null;
    private static final String etQuery = "SELECT * WHERE { \n?instance <" + REPO.HAS_EDIT_TOKEN + "> ?editToken . \n" + "OPTIONAL { ?editToken <" + DCTERMS.CREATOR + "> ?creator  \n" + " OPTIONAL { ?creator <" + RDFS.LABEL + "> ?creatorLabel } } \n" + "OPTIONAL { ?editToken <" + DCTERMS.CREATED + "> ?created } }";

    private EditToken(URI resource) {
        this.resource = resource;
    }

    public static EditToken find(HttpServletRequest request, URI resource) {
        RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
        try {
            log.debug((Object)("Edit Token SPARQL query = " + etQuery));
            TupleQuery q = rc.prepareTupleQuery(QueryLanguage.SPARQL, etQuery);
            q.setBinding("instance", (Value)resource);
            q.setDataset((Dataset)SPARQL.InternalGraphs);
            q.setIncludeInferred(false);
            EditToken result = new EditToken(resource);
            q.evaluate((TupleQueryResultHandler)result);
            if (result.uri == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found edit token = " + result.uri + " for Resource Instance = " + resource));
            }
            return result;
        }
        catch (MalformedQueryException e) {
            log.error((Object)("Rejecting malformed query:" + (Object)((Object)e)));
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (OpenRDFException e) {
            log.error((Object)e);
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public void handleSolution(BindingSet bs) throws TupleQueryResultHandlerException {
        Value editToken = bs.getValue("editToken");
        Value bcreator = bs.getValue("creator");
        Value bcreatorLabel = bs.getValue("creatorLabel");
        Value bcreated = bs.getValue("created");
        if (editToken != null && editToken instanceof URI) {
            if (this.uri != null) {
                log.error((Object)("Unexpected multiple editToken results for resource instance URI =" + this.resource));
            }
            this.uri = (URI)editToken;
            if (bcreator != null && bcreator instanceof URI) {
                this.creator = (URI)bcreator;
            }
            if (bcreatorLabel != null && bcreatorLabel instanceof Literal) {
                this.creatorLabel = ((Literal)bcreatorLabel).getLabel();
            }
            if (bcreated != null && bcreated instanceof Literal) {
                this.created = ((Literal)bcreated).getLabel();
            }
        } else {
            log.error((Object)("Bad query result, editToken=" + editToken));
        }
    }

    public static EditToken create(HttpServletRequest request, URI resource) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            if (rc.hasStatement((Resource)resource, REPO.HAS_EDIT_TOKEN, null, false, new Resource[]{REPO.NG_INTERNAL})) {
                throw new ConflictException("There is already an edit token for resource instance: " + resource);
            }
            if (!Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.ADD) && !Access.hasPermission((HttpServletRequest)request, (Resource)resource, (Access)Access.REMOVE)) {
                throw new ForbiddenException("No permission to modify this resource instance: " + resource);
            }
            EditToken result = new EditToken(resource);
            result.creator = Access.getPrincipalURI((HttpServletRequest)request);
            Literal now = Provenance.getDateTime((Date)new Date());
            result.created = now.getLabel();
            ValueFactory vf = rc.getValueFactory();
            result.uri = vf.createURI(DataRepository.getInstance().getDefaultNamespace(), RIDGenerator.getInstance().newID().toString());
            rc.add((Resource)resource, REPO.HAS_EDIT_TOKEN, (Value)result.uri, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)result.uri, DCTERMS.CREATOR, (Value)result.creator, new Resource[]{REPO.NG_INTERNAL});
            rc.add((Resource)result.uri, DCTERMS.CREATED, (Value)now, new Resource[]{REPO.NG_INTERNAL});
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created edit token = " + result.uri + " for Resource Instance = " + resource));
            }
            return result;
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed creating edit token: ", (Throwable)e);
            throw new InternalServerErrorException("Failed creating edit token: ", (Throwable)e);
        }
    }

    public void clear(HttpServletRequest request) {
        try {
            RepositoryConnection rc = WithRepositoryConnection.get((ServletRequest)request);
            rc.remove((Resource)this.resource, REPO.HAS_EDIT_TOKEN, (Value)this.uri, new Resource[]{REPO.NG_INTERNAL});
            rc.remove((Resource)this.uri, null, null, new Resource[]{REPO.NG_INTERNAL});
        }
        catch (RepositoryException e) {
            log.error((Object)"Failed clearing edit token: ", (Throwable)e);
            throw new InternalServerErrorException("Failed clearing edit token: ", (Throwable)e);
        }
    }

    public URI getResource() {
        return this.resource;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getCreator() {
        return this.creator;
    }

    public String getCreatorLabel() {
        return this.creatorLabel == null ? this.creator.getLocalName() : this.creatorLabel;
    }

    public String getCreated() {
        return this.created;
    }

    public String toString() {
        return "<#EditToken: resource=" + this.resource + ", uri=" + this.uri + ", creator=" + this.creator + ", creatorLabel=" + this.creatorLabel + ", created=" + this.created + ">";
    }

    public boolean equals(Object o) {
        return o instanceof EditToken && this.uri != null && this.uri.equals(((EditToken)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

